/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConstraintType {
    CONSTRAINT_TYPE_NULL(0, "bNullConstraint"),
    CONSTRAINT_TYPE_CHILDOF(1, "bChildOfConstraint"),
    CONSTRAINT_TYPE_KINEMATIC(3, "bKinematicConstraint"),
    CONSTRAINT_TYPE_FOLLOWPATH(4, "bFollowPathConstraint"),
    CONSTRAINT_TYPE_ROTLIMIT(5, "bRotLimitConstraint"),
    CONSTRAINT_TYPE_LOCLIMIT(6, "bLocLimitConstraint"),
    CONSTRAINT_TYPE_SIZELIMIT(7, "bSizeLimitConstraint"),
    CONSTRAINT_TYPE_ROTLIKE(8, "bRotateLikeConstraint"),
    CONSTRAINT_TYPE_LOCLIKE(9, "bLocateLikeConstraint"),
    CONSTRAINT_TYPE_SIZELIKE(10, "bSizeLikeConstraint"),
    CONSTRAINT_TYPE_PYTHON(11, "bPythonConstraint"),
    CONSTRAINT_TYPE_ACTION(12, "bActionConstraint"),
    CONSTRAINT_TYPE_LOCKTRACK(13, "bLockTrackConstraint"),
    CONSTRAINT_TYPE_DISTLIMIT(14, "bDistLimitConstraint"),
    CONSTRAINT_TYPE_STRETCHTO(15, "bStretchToConstraint"),
    CONSTRAINT_TYPE_MINMAX(16, "bMinMaxConstraint"),
    CONSTRAINT_TYPE_RIGIDBODYJOINT(17, "bRigidBodyConstraint"),
    CONSTRAINT_TYPE_CLAMPTO(18, "bClampToConstraint"),
    CONSTRAINT_TYPE_TRANSFORM(19, "bTransformConstraint"),
    CONSTRAINT_TYPE_SHRINKWRAP(20, "bShrinkwrapConstraint");

    private int constraintId;
    private String className;
    private static final Map<String, ConstraintType> typesMap;
    private static final Map<Integer, ConstraintType> idsMap;

    private ConstraintType(int constraintId, String className) {
        this.constraintId = constraintId;
        this.className = className;
    }

    public static ConstraintType valueOf(int constraintId) {
        return idsMap.get(constraintId);
    }

    public int getConstraintId() {
        return this.constraintId;
    }

    public String getClassName() {
        return this.className;
    }

    public static ConstraintType getByBlenderClassName(String className) {
        ConstraintType result = typesMap.get(className);
        if (result == null) {
            ConstraintType[] constraints;
            for (ConstraintType constraint : constraints = ConstraintType.values()) {
                if (!constraint.className.equals(className)) continue;
                return constraint;
            }
        }
        return result;
    }

    public static int getLastDefinedTypeValue() {
        return CONSTRAINT_TYPE_SHRINKWRAP.getConstraintId();
    }

    static {
        typesMap = new HashMap<String, ConstraintType>(ConstraintType.values().length);
        idsMap = new HashMap<Integer, ConstraintType>(ConstraintType.values().length);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_NULL.constraintId, CONSTRAINT_TYPE_NULL);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_CHILDOF.constraintId, CONSTRAINT_TYPE_CHILDOF);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_KINEMATIC.constraintId, CONSTRAINT_TYPE_KINEMATIC);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_FOLLOWPATH.constraintId, CONSTRAINT_TYPE_FOLLOWPATH);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_ROTLIMIT.constraintId, CONSTRAINT_TYPE_ROTLIMIT);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_LOCLIMIT.constraintId, CONSTRAINT_TYPE_LOCLIMIT);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_SIZELIMIT.constraintId, CONSTRAINT_TYPE_SIZELIMIT);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_ROTLIKE.constraintId, CONSTRAINT_TYPE_ROTLIKE);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_LOCLIKE.constraintId, CONSTRAINT_TYPE_LOCLIKE);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_SIZELIKE.constraintId, CONSTRAINT_TYPE_SIZELIKE);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_PYTHON.constraintId, CONSTRAINT_TYPE_PYTHON);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_ACTION.constraintId, CONSTRAINT_TYPE_ACTION);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_LOCKTRACK.constraintId, CONSTRAINT_TYPE_LOCKTRACK);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_DISTLIMIT.constraintId, CONSTRAINT_TYPE_DISTLIMIT);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_STRETCHTO.constraintId, CONSTRAINT_TYPE_STRETCHTO);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_MINMAX.constraintId, CONSTRAINT_TYPE_MINMAX);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_RIGIDBODYJOINT.constraintId, CONSTRAINT_TYPE_RIGIDBODYJOINT);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_CLAMPTO.constraintId, CONSTRAINT_TYPE_CLAMPTO);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_TRANSFORM.constraintId, CONSTRAINT_TYPE_TRANSFORM);
        idsMap.put(ConstraintType.CONSTRAINT_TYPE_SHRINKWRAP.constraintId, CONSTRAINT_TYPE_SHRINKWRAP);
    }
}

