/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.file;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;

class Field
implements Cloneable {
    private static final int NAME_LENGTH = 24;
    private static final int TYPE_LENGTH = 16;
    public BlenderContext blenderContext;
    public String type;
    public String name;
    public Object value;
    public int pointerLevel;
    public int[] tableSizes;
    public boolean function;

    public Field(String name, String type, BlenderContext blenderContext) throws BlenderFileException {
        this.type = type;
        this.blenderContext = blenderContext;
        this.parseField(new StringBuilder(name));
    }

    private Field(Field field) {
        this.type = field.type;
        this.name = field.name;
        this.blenderContext = field.blenderContext;
        this.pointerLevel = field.pointerLevel;
        if (field.tableSizes != null) {
            this.tableSizes = (int[])field.tableSizes.clone();
        }
        this.function = field.function;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Field(this);
    }

    public void fill(BlenderInputStream blenderInputStream) throws BlenderFileException {
        int dataToRead = 1;
        if (this.tableSizes != null && this.tableSizes.length > 0) {
            for (int size : this.tableSizes) {
                if (size <= 0) {
                    throw new BlenderFileException("The field " + this.name + " has invalid table size: " + size);
                }
                dataToRead *= size;
            }
        }
        Structure.DataType dataType = this.pointerLevel == 0 ? Structure.DataType.getDataType(this.type, this.blenderContext) : Structure.DataType.POINTER;
        switch (dataType) {
            case POINTER: {
                int i;
                if (dataToRead == 1) {
                    Pointer pointer = new Pointer(this.pointerLevel, this.function, this.blenderContext);
                    pointer.fill(blenderInputStream);
                    this.value = pointer;
                    break;
                }
                Pointer[] data = new Pointer[dataToRead];
                for (i = 0; i < dataToRead; ++i) {
                    Pointer pointer = new Pointer(this.pointerLevel, this.function, this.blenderContext);
                    pointer.fill(blenderInputStream);
                    data[i] = pointer;
                }
                this.value = new DynamicArray<Pointer>(this.tableSizes, data);
                break;
            }
            case CHARACTER: {
                int i;
                if (dataToRead == 1) {
                    this.value = (byte)blenderInputStream.readByte();
                    break;
                }
                Character[] data = new Character[dataToRead];
                for (i = 0; i < dataToRead; ++i) {
                    data[i] = Character.valueOf((char)blenderInputStream.readByte());
                }
                this.value = new DynamicArray<Character>(this.tableSizes, data);
                break;
            }
            case SHORT: {
                int i;
                if (dataToRead == 1) {
                    this.value = blenderInputStream.readShort();
                    break;
                }
                Number[] data = new Number[dataToRead];
                for (i = 0; i < dataToRead; ++i) {
                    data[i] = blenderInputStream.readShort();
                }
                this.value = new DynamicArray<Number>(this.tableSizes, data);
                break;
            }
            case INTEGER: {
                int i;
                if (dataToRead == 1) {
                    this.value = blenderInputStream.readInt();
                    break;
                }
                Number[] data = new Number[dataToRead];
                for (i = 0; i < dataToRead; ++i) {
                    data[i] = blenderInputStream.readInt();
                }
                this.value = new DynamicArray<Number>(this.tableSizes, data);
                break;
            }
            case LONG: {
                int i;
                if (dataToRead == 1) {
                    this.value = blenderInputStream.readLong();
                    break;
                }
                Number[] data = new Number[dataToRead];
                for (i = 0; i < dataToRead; ++i) {
                    data[i] = blenderInputStream.readLong();
                }
                this.value = new DynamicArray<Number>(this.tableSizes, data);
                break;
            }
            case FLOAT: {
                int i;
                if (dataToRead == 1) {
                    this.value = Float.valueOf(blenderInputStream.readFloat());
                    break;
                }
                Number[] data = new Number[dataToRead];
                for (i = 0; i < dataToRead; ++i) {
                    data[i] = Float.valueOf(blenderInputStream.readFloat());
                }
                this.value = new DynamicArray<Number>(this.tableSizes, data);
                break;
            }
            case DOUBLE: {
                int i;
                if (dataToRead == 1) {
                    this.value = blenderInputStream.readDouble();
                    break;
                }
                Number[] data = new Number[dataToRead];
                for (i = 0; i < dataToRead; ++i) {
                    data[i] = blenderInputStream.readDouble();
                }
                this.value = new DynamicArray<Number>(this.tableSizes, data);
                break;
            }
            case VOID: {
                break;
            }
            case STRUCTURE: {
                int i;
                if (dataToRead == 1) {
                    Structure structure = this.blenderContext.getDnaBlockData().getStructure(this.type);
                    structure.fill(blenderInputStream);
                    this.value = structure;
                    break;
                }
                Structure[] data = new Structure[dataToRead];
                for (i = 0; i < dataToRead; ++i) {
                    Structure structure = this.blenderContext.getDnaBlockData().getStructure(this.type);
                    structure.fill(blenderInputStream);
                    data[i] = structure;
                }
                this.value = new DynamicArray<Structure>(this.tableSizes, data);
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented filling of type: " + this.type);
            }
        }
    }

    private void parseField(StringBuilder nameBuilder) throws BlenderFileException {
        this.removeWhitespaces(nameBuilder);
        int pointerIndex = nameBuilder.indexOf("*");
        while (pointerIndex >= 0) {
            ++this.pointerLevel;
            nameBuilder.deleteCharAt(pointerIndex);
            pointerIndex = nameBuilder.indexOf("*");
        }
        if (nameBuilder.indexOf("(") >= 0) {
            this.function = true;
            this.removeCharacter(nameBuilder, '(');
            this.removeCharacter(nameBuilder, ')');
        } else {
            int tableStartIndex = 0;
            ArrayList<Integer> lengths = new ArrayList<Integer>(3);
            do {
                if ((tableStartIndex = nameBuilder.indexOf("[")) <= 0) continue;
                int tableStopIndex = nameBuilder.indexOf("]");
                if (tableStopIndex < 0) {
                    throw new BlenderFileException("Invalid structure name: " + this.name);
                }
                try {
                    lengths.add(Integer.valueOf(nameBuilder.substring(tableStartIndex + 1, tableStopIndex)));
                }
                catch (NumberFormatException e) {
                    throw new BlenderFileException("Invalid structure name caused by invalid table length: " + this.name, e);
                }
                nameBuilder.delete(tableStartIndex, tableStopIndex + 1);
            } while (tableStartIndex > 0);
            if (!lengths.isEmpty()) {
                this.tableSizes = new int[lengths.size()];
                for (int i = 0; i < this.tableSizes.length; ++i) {
                    this.tableSizes[i] = (Integer)lengths.get(i);
                }
            }
        }
        this.name = nameBuilder.toString();
    }

    private void removeCharacter(StringBuilder text, char toRemove) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != toRemove) continue;
            text.deleteCharAt(i);
            --i;
        }
    }

    private void removeWhitespaces(StringBuilder text) {
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            text.deleteCharAt(i);
            --i;
        }
    }

    public String toString() {
        int i;
        int i2;
        StringBuilder result = new StringBuilder();
        if (this.function) {
            result.append('(');
        }
        for (i2 = 0; i2 < this.pointerLevel; ++i2) {
            result.append('*');
        }
        result.append(this.name);
        if (this.tableSizes != null) {
            for (i2 = 0; i2 < this.tableSizes.length; ++i2) {
                result.append('[').append(this.tableSizes[i2]).append(']');
            }
        }
        if (this.function) {
            result.append(")()");
        }
        int nameLength = result.length();
        result.append(' ');
        for (i = 1; i < 24 - nameLength; ++i) {
            result.append(' ');
        }
        result.append(this.type);
        nameLength = result.length();
        for (i = 0; i < 40 - nameLength; ++i) {
            result.append(' ');
        }
        if (this.value instanceof Character) {
            result.append(" = ").append((int)((Character)this.value).charValue());
        } else {
            result.append(" = ").append(this.value != null ? this.value.toString() : "null");
        }
        return result.toString();
    }
}

