/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGeneratorWood;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorMarble
extends TextureGeneratorWood {
    protected static final int TEX_SOFT = 0;
    protected static final int TEX_SHARP = 1;
    protected static final int TEX_SHARPER = 2;

    public TextureGeneratorMarble(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, BlenderContext blenderContext) {
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        TexturePixel texres = new TexturePixel();
        int halfW = width >> 1;
        int halfH = height >> 1;
        int halfD = depth >> 1;
        int index = 0;
        float wDelta = 1.0f / (float)halfW;
        float hDelta = 1.0f / (float)halfH;
        float dDelta = 1.0f / (float)halfD;
        float[][] colorBand = this.computeColorband(tex, blenderContext);
        Image.Format format = colorBand != null ? Image.Format.RGBA8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 4 : 1;
        TextureGenerator.BrightnessAndContrastData bacd = new TextureGenerator.BrightnessAndContrastData(tex);
        MarbleData marbleData = new MarbleData(tex);
        byte[] data = new byte[width * height * depth * bytesPerPixel];
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j;
                for (int k = -halfD; k < halfD; ++k) {
                    texvec[2] = dDelta * (float)k;
                    texres.intensity = this.marbleInt(marbleData, texvec[0], texvec[1], texvec[2]);
                    if (colorBand != null) {
                        int colorbandIndex = (int)(texres.intensity * 1000.0f);
                        texres.red = colorBand[colorbandIndex][0];
                        texres.green = colorBand[colorbandIndex][1];
                        texres.blue = colorBand[colorbandIndex][2];
                        this.applyBrightnessAndContrast(bacd, texres);
                        data[index++] = (byte)(texres.red * 255.0f);
                        data[index++] = (byte)(texres.green * 255.0f);
                        data[index++] = (byte)(texres.blue * 255.0f);
                        data[index++] = (byte)(colorBand[colorbandIndex][3] * 255.0f);
                        continue;
                    }
                    this.applyBrightnessAndContrast(texres, bacd.contrast, bacd.brightness);
                    data[index++] = (byte)(texres.intensity * 255.0f);
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(BufferUtils.createByteBuffer(data));
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }

    public float marbleInt(MarbleData marbleData, float x, float y, float z) {
        int waveform = marbleData.waveform > 2 || marbleData.waveform < 0 ? 0 : marbleData.waveform;
        float n = 5.0f * (x + y + z);
        float mi = n + marbleData.turbul * NoiseGenerator.NoiseFunctions.turbulence(x, y, z, marbleData.noisesize, marbleData.noisedepth, marbleData.noisebasis, marbleData.isHard);
        if (marbleData.stype >= 0) {
            mi = waveformFunctions[waveform].execute(mi);
            if (marbleData.stype == 1) {
                mi = (float)Math.sqrt(mi);
            } else if (marbleData.stype == 2) {
                mi = (float)Math.sqrt(Math.sqrt(mi));
            }
        }
        return mi;
    }

    private static class MarbleData {
        public final float noisesize;
        public final int noisebasis;
        public final int noisedepth;
        public final int stype;
        public final float turbul;
        public final int waveform;
        public final boolean isHard;

        public MarbleData(Structure tex) {
            this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
            this.noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
            this.noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
            this.stype = ((Number)tex.getFieldValue("stype")).intValue();
            this.turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
            int noisetype = ((Number)tex.getFieldValue("noisetype")).intValue();
            this.waveform = ((Number)tex.getFieldValue("noisebasis2")).intValue();
            this.isHard = noisetype != 0;
        }
    }
}

