/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Line
extends Mesh {
    private Vector3f start;
    private Vector3f end;

    public Line() {
    }

    public Line(Vector3f start, Vector3f end) {
        this.setMode(Mesh.Mode.Lines);
        this.updateGeometry(start, end);
    }

    protected void updateGeometry(Vector3f start, Vector3f end) {
        this.start = start;
        this.end = end;
        this.setBuffer(VertexBuffer.Type.Position, 3, new float[]{start.x, start.y, start.z, end.x, end.y, end.z});
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        this.setBuffer(VertexBuffer.Type.Normal, 3, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
        this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 1});
        this.updateBound();
    }

    public void updatePoints(Vector3f start, Vector3f end) {
        VertexBuffer posBuf = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fb = (FloatBuffer)posBuf.getData();
        fb.put(start.x).put(start.y).put(start.z);
        fb.put(end.x).put(end.y).put(end.z);
        posBuf.updateData(fb);
        this.updateBound();
    }

    public Vector3f getEnd() {
        return this.end;
    }

    public Vector3f getStart() {
        return this.start;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.start, "startVertex", null);
        out.write(this.end, "endVertex", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule in = im.getCapsule(this);
        this.start = (Vector3f)in.readSavable("startVertex", null);
        this.end = (Vector3f)in.readSavable("endVertex", null);
    }
}

