/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;

public class ShadowCamera {
    private Vector3f[] points = new Vector3f[8];
    private Light target;

    public ShadowCamera(Light target) {
        this.target = target;
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
    }

    public void updateLightCamera(Camera lightCam) {
        if (this.target.getType() == Light.Type.Directional) {
            DirectionalLight dl = (DirectionalLight)this.target;
            lightCam.setParallelProjection(true);
            lightCam.setLocation(Vector3f.ZERO);
            lightCam.lookAtDirection(dl.getDirection(), Vector3f.UNIT_Y);
            lightCam.setFrustum(-1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        } else {
            PointLight pl = (PointLight)this.target;
            lightCam.setParallelProjection(false);
            lightCam.setLocation(pl.getPosition());
            lightCam.setFrustumPerspective(45.0f, 1.0f, 1.0f, 300.0f);
        }
    }
}

