/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import android.graphics.Bitmap;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class AndroidTGALoader
implements AssetLoader {
    public static final int TYPE_NO_IMAGE = 0;
    public static final int TYPE_COLORMAPPED = 1;
    public static final int TYPE_TRUECOLOR = 2;
    public static final int TYPE_BLACKANDWHITE = 3;
    public static final int TYPE_COLORMAPPED_RLE = 9;
    public static final int TYPE_TRUECOLOR_RLE = 10;
    public static final int TYPE_BLACKANDWHITE_RLE = 11;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info) throws IOException {
        if (!(info.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        boolean flip = ((TextureKey)info.getKey()).isFlipY();
        InputStream in = null;
        try {
            Image img;
            in = info.openStream();
            Image image = img = AndroidTGALoader.load(in, flip);
            return image;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Image load(InputStream in, boolean flip) throws IOException {
        int i;
        Image.Format format;
        int j;
        int i2;
        byte blue;
        byte green;
        byte red;
        int dl;
        boolean flipH = false;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
        int idLength = dis.readUnsignedByte();
        int colorMapType = dis.readUnsignedByte();
        int imageType = dis.readUnsignedByte();
        dis.readShort();
        int cMapLength = AndroidTGALoader.flipEndian(dis.readShort());
        int cMapDepth = dis.readUnsignedByte();
        dis.readShort();
        dis.readShort();
        int width = AndroidTGALoader.flipEndian(dis.readShort());
        int height = AndroidTGALoader.flipEndian(dis.readShort());
        int pixelDepth = dis.readUnsignedByte();
        int imageDescriptor = dis.readUnsignedByte();
        if ((imageDescriptor & 0x20) != 0) {
            boolean bl = flip = !flip;
        }
        if ((imageDescriptor & 0x10) != 0) {
            boolean bl = flipH = !flipH;
        }
        if (idLength > 0) {
            in.skip(idLength);
        }
        ColorMapEntry[] cMapEntries = null;
        if (colorMapType != 0) {
            int bytesInColorMap = cMapDepth * cMapLength >> 3;
            int bitsPerColor = Math.min(cMapDepth / 3, 8);
            byte[] cMapData = new byte[bytesInColorMap];
            in.read(cMapData);
            if (imageType == 1 || imageType == 9) {
                cMapEntries = new ColorMapEntry[cMapLength];
                int alphaSize = cMapDepth - 3 * bitsPerColor;
                float scalar = 255.0f / (FastMath.pow(2.0f, bitsPerColor) - 1.0f);
                float alphaScalar = 255.0f / (FastMath.pow(2.0f, alphaSize) - 1.0f);
                for (int i3 = 0; i3 < cMapLength; ++i3) {
                    ColorMapEntry entry = new ColorMapEntry();
                    int offset = cMapDepth * i3;
                    entry.red = (byte)((float)AndroidTGALoader.getBitsAsByte(cMapData, offset, bitsPerColor) * scalar);
                    entry.green = (byte)((float)AndroidTGALoader.getBitsAsByte(cMapData, offset + bitsPerColor, bitsPerColor) * scalar);
                    entry.blue = (byte)((float)AndroidTGALoader.getBitsAsByte(cMapData, offset + 2 * bitsPerColor, bitsPerColor) * scalar);
                    entry.alpha = alphaSize <= 0 ? (byte)-1 : (byte)((float)AndroidTGALoader.getBitsAsByte(cMapData, offset + 3 * bitsPerColor, alphaSize) * alphaScalar);
                    cMapEntries[i3] = entry;
                }
            }
        }
        byte[] rawData = null;
        if (pixelDepth == 32) {
            rawData = new byte[width * height * 4];
            dl = 4;
        } else {
            rawData = new byte[width * height * 4];
            dl = 3;
        }
        int rawDataIndex = 0;
        if (imageType == 2) {
            red = 0;
            green = 0;
            blue = 0;
            int alpha = 0;
            if (pixelDepth == 16) {
                byte[] data = new byte[2];
                float scalar = 8.225806f;
                for (i2 = 0; i2 <= height - 1; ++i2) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i2) * width * dl;
                    }
                    for (j = 0; j < width; ++j) {
                        data[1] = dis.readByte();
                        data[0] = dis.readByte();
                        rawData[rawDataIndex++] = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 1, 5) * scalar);
                        rawData[rawDataIndex++] = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 6, 5) * scalar);
                        rawData[rawDataIndex++] = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 11, 5) * scalar);
                        if (dl == 4) {
                            alpha = AndroidTGALoader.getBitsAsByte(data, 0, 1);
                            if (alpha == 1) {
                                alpha = -1;
                            }
                            rawData[rawDataIndex++] = alpha;
                            continue;
                        }
                        rawData[rawDataIndex++] = -1;
                    }
                }
                format = dl == 4 ? Image.Format.RGBA8 : Image.Format.RGB8;
            } else if (pixelDepth == 24) {
                for (int y = 0; y < height; ++y) {
                    rawDataIndex = !flip ? (height - 1 - y) * width * dl : y * width * dl;
                    for (int x = 0; x < width; ++x) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        rawData[rawDataIndex++] = red;
                        rawData[rawDataIndex++] = green;
                        rawData[rawDataIndex++] = blue;
                        rawData[rawDataIndex++] = -1;
                    }
                }
                format = Image.Format.RGB8;
            } else {
                if (pixelDepth != 32) throw new IOException("Unsupported TGA true color depth: " + pixelDepth);
                for (i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j2 = 0; j2 < width; ++j2) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = dis.readByte();
                        rawData[rawDataIndex++] = red;
                        rawData[rawDataIndex++] = green;
                        rawData[rawDataIndex++] = blue;
                        rawData[rawDataIndex++] = alpha;
                    }
                }
                format = Image.Format.RGBA8;
            }
        } else if (imageType == 10) {
            int count;
            red = 0;
            green = 0;
            blue = 0;
            byte alpha = 0;
            if (pixelDepth == 32) {
                for (i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j3 = 0; j3 < width; ++j3) {
                        count = dis.readByte();
                        if ((count & 0x80) != 0) {
                            j3 += (count &= 0x7F);
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            alpha = dis.readByte();
                            while (count-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                                rawData[rawDataIndex++] = alpha;
                            }
                            continue;
                        }
                        j3 += count;
                        while (count-- >= 0) {
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            alpha = dis.readByte();
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                            rawData[rawDataIndex++] = alpha;
                        }
                    }
                }
                format = Image.Format.RGBA8;
            } else if (pixelDepth == 24) {
                for (i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j4 = 0; j4 < width; ++j4) {
                        count = dis.readByte();
                        if ((count & 0x80) != 0) {
                            j4 += (count &= 0x7F);
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            while (count-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                                rawData[rawDataIndex++] = -1;
                            }
                            continue;
                        }
                        j4 += count;
                        while (count-- >= 0) {
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                            rawData[rawDataIndex++] = -1;
                        }
                    }
                }
                format = Image.Format.RGB8;
            } else {
                if (pixelDepth != 16) throw new IOException("Unsupported TGA true color depth: " + pixelDepth);
                byte[] data = new byte[2];
                float scalar = 8.225806f;
                for (i2 = 0; i2 <= height - 1; ++i2) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i2) * width * dl;
                    }
                    for (j = 0; j < width; ++j) {
                        int count2 = dis.readByte();
                        if ((count2 & 0x80) != 0) {
                            j += (count2 &= 0x7F);
                            data[1] = dis.readByte();
                            data[0] = dis.readByte();
                            blue = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 1, 5) * scalar);
                            green = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 6, 5) * scalar);
                            red = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 11, 5) * scalar);
                            while (count2-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                                rawData[rawDataIndex++] = -1;
                            }
                            continue;
                        }
                        j += count2;
                        while (count2-- >= 0) {
                            data[1] = dis.readByte();
                            data[0] = dis.readByte();
                            blue = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 1, 5) * scalar);
                            green = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 6, 5) * scalar);
                            red = (byte)((float)AndroidTGALoader.getBitsAsByte(data, 11, 5) * scalar);
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                            rawData[rawDataIndex++] = -1;
                        }
                    }
                }
                format = Image.Format.RGB8;
            }
        } else {
            int j5;
            int i4;
            if (imageType != 1) throw new IOException("Grayscale TGA not supported");
            int bytesPerIndex = pixelDepth / 8;
            if (bytesPerIndex == 1) {
                for (i4 = 0; i4 <= height - 1; ++i4) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i4) * width * dl;
                    }
                    for (j5 = 0; j5 < width; ++j5) {
                        int index = dis.readUnsignedByte();
                        if (index >= cMapEntries.length || index < 0) {
                            throw new IOException("TGA: Invalid color map entry referenced: " + index);
                        }
                        ColorMapEntry entry = cMapEntries[index];
                        rawData[rawDataIndex++] = entry.red;
                        rawData[rawDataIndex++] = entry.green;
                        rawData[rawDataIndex++] = entry.blue;
                        rawData[rawDataIndex++] = dl == 4 ? entry.alpha : (byte)-1;
                    }
                }
            } else {
                if (bytesPerIndex != 2) throw new IOException("TGA: unknown colormap indexing size used: " + bytesPerIndex);
                for (i4 = 0; i4 <= height - 1; ++i4) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i4) * width * dl;
                    }
                    for (j5 = 0; j5 < width; ++j5) {
                        short index = AndroidTGALoader.flipEndian(dis.readShort());
                        if (index >= cMapEntries.length || index < 0) {
                            throw new IOException("TGA: Invalid color map entry referenced: " + index);
                        }
                        ColorMapEntry entry = cMapEntries[index];
                        rawData[rawDataIndex++] = entry.red;
                        rawData[rawDataIndex++] = entry.green;
                        rawData[rawDataIndex++] = entry.blue;
                        rawData[rawDataIndex++] = dl == 4 ? entry.alpha : (byte)-1;
                    }
                }
            }
            format = dl == 4 ? Image.Format.RGBA8 : Image.Format.RGB8;
        }
        in.close();
        ByteBuffer scratch = ByteBuffer.wrap(rawData);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)scratch);
        rawData = null;
        scratch = null;
        if (!FastMath.isPowerOfTwo(width) || !FastMath.isPowerOfTwo(height) || width >= 512 || height >= 512) {
            height = FastMath.nearestPowerOfTwo(height);
            for (width = FastMath.nearestPowerOfTwo(width); width >= 512; width /= 2) {
            }
            while (height >= 512) {
                height /= 2;
            }
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
            bitmap.recycle();
            bitmap = bitmap2;
        }
        Image textureImage = new Image();
        textureImage.setFormat(format);
        textureImage.setWidth(width);
        textureImage.setHeight(height);
        textureImage.setEfficentData(bitmap);
        return textureImage;
    }

    private static byte getBitsAsByte(byte[] data, int offset, int length) {
        int offsetBytes = offset / 8;
        int indexBits = offset % 8;
        int rVal = 0;
        int i = length;
        while (--i >= 0) {
            int test;
            byte b = data[offsetBytes];
            int n = test = indexBits == 7 ? 1 : 2 << 6 - indexBits;
            if ((b & test) != 0) {
                rVal = i == 0 ? ++rVal : (rVal += 2 << i - 1);
            }
            if (++indexBits != 8) continue;
            indexBits = 0;
            ++offsetBytes;
        }
        return (byte)rVal;
    }

    private static short flipEndian(short signedShort) {
        int input = signedShort & 0xFFFF;
        return (short)(input << 8 | (input & 0xFF00) >>> 8);
    }

    static class ColorMapEntry {
        byte red;
        byte green;
        byte blue;
        byte alpha;

        ColorMapEntry() {
        }

        public String toString() {
            return "entry: " + this.red + "," + this.green + "," + this.blue + "," + this.alpha;
        }
    }
}

