/*
 * Decompiled with CFR 0.152.
 */
package jme3test.android;

import com.jme3.app.SimpleApplication;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.light.AmbientLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;

public class TestMovingParticle
extends SimpleApplication {
    private ParticleEmitter emit;
    private float angle = 0.0f;

    public static void main(String[] args) {
        TestMovingParticle app = new TestMovingParticle();
        app.start();
    }

    @Override
    public void simpleInitApp() {
        this.emit = new ParticleEmitter("Emitter", ParticleMesh.Type.Triangle, 300);
        this.emit.setGravity(0.0f, 0.0f, 0.0f);
        this.emit.setVelocityVariation(1.0f);
        this.emit.setLowLife(1.0f);
        this.emit.setHighLife(1.0f);
        this.emit.setInitialVelocity(new Vector3f(0.0f, 0.5f, 0.0f));
        this.emit.setImagesX(15);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Particle.j3md");
        mat.setTexture("Texture", this.assetManager.loadTexture("Effects/Smoke/Smoke.png"));
        this.emit.setMaterial(mat);
        this.rootNode.attachChild(this.emit);
        AmbientLight al = new AmbientLight();
        al.setColor(new ColorRGBA(0.84f, 0.8f, 0.8f, 1.0f));
        this.rootNode.addLight(al);
        this.inputManager.addListener(new ActionListener(){

            @Override
            public void onAction(String name, boolean isPressed, float tpf) {
                if ("setNum".equals(name) && isPressed) {
                    TestMovingParticle.this.emit.setNumParticles(1000);
                }
            }
        }, "setNum");
        this.inputManager.addMapping("setNum", new KeyTrigger(57));
    }

    @Override
    public void simpleUpdate(float tpf) {
        this.angle += tpf;
        this.angle %= (float)Math.PI * 2;
        float x = FastMath.cos(this.angle) * 2.0f;
        float y = FastMath.sin(this.angle) * 2.0f;
        this.emit.setLocalTranslation(x, 0.0f, y);
    }
}

