/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Info;
import com.fluendo.jheora.Playback;
import com.fluendo.utils.MemUtils;

public final class Filter {
    private static final byte[] LoopFilterLimitValuesV1 = new byte[]{30, 25, 20, 20, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] LoopFilterLimits = new byte[64];
    private int[] FiltBoundingValue = new int[512];

    private void SetupBoundingValueArray_Generic(int FLimit) {
        MemUtils.set(this.FiltBoundingValue, 0, 0, 512);
        for (int i = 0; i < FLimit; ++i) {
            this.FiltBoundingValue[256 - i - FLimit] = -FLimit + i;
            this.FiltBoundingValue[256 - i] = -i;
            this.FiltBoundingValue[256 + i] = i;
            this.FiltBoundingValue[256 + i + FLimit] = FLimit - i;
        }
    }

    public void copyFilterTables(Info ci) {
        System.arraycopy(ci.LoopFilterLimitValues, 0, this.LoopFilterLimits, 0, 64);
    }

    public void InitFilterTables() {
        System.arraycopy(LoopFilterLimitValuesV1, 0, this.LoopFilterLimits, 0, 64);
    }

    public void SetupLoopFilter(int FrameQIndex) {
        byte FLimit = this.LoopFilterLimits[FrameQIndex];
        this.SetupBoundingValueArray_Generic(FLimit);
    }

    private static final short clamp255(int val) {
        return (short)(~(val >> 31) & 0xFF & (val | 255 - val >> 31));
    }

    private void FilterHoriz(short[] PixelPtr, int idx, int LineLength, int[] BoundingValuePtr) {
        for (int j = 0; j < 8; ++j) {
            int FiltVal = PixelPtr[0 + idx] - PixelPtr[1 + idx] * 3 + PixelPtr[2 + idx] * 3 - PixelPtr[3 + idx];
            FiltVal = BoundingValuePtr[256 + (FiltVal + 4 >> 3)];
            PixelPtr[1 + idx] = Filter.clamp255(PixelPtr[1 + idx] + FiltVal);
            PixelPtr[2 + idx] = Filter.clamp255(PixelPtr[2 + idx] - FiltVal);
            idx += LineLength;
        }
    }

    private void FilterVert(short[] PixelPtr, int idx, int LineLength, int[] BoundingValuePtr) {
        idx -= 2 * LineLength;
        for (int j = 0; j < 8; ++j) {
            int FiltVal = PixelPtr[idx + 0] - PixelPtr[idx + LineLength] * 3 + PixelPtr[idx + 2 * LineLength] * 3 - PixelPtr[idx + 3 * LineLength];
            FiltVal = BoundingValuePtr[256 + (FiltVal + 4 >> 3)];
            PixelPtr[idx + LineLength] = Filter.clamp255(PixelPtr[idx + LineLength] + FiltVal);
            PixelPtr[idx + 2 * LineLength] = Filter.clamp255(PixelPtr[idx + 2 * LineLength] - FiltVal);
            ++idx;
        }
    }

    public void LoopFilter(Playback pbi) {
        int FragsAcross = pbi.HFragments;
        int FragsDown = pbi.VFragments;
        int QIndex = pbi.frameQIS[0];
        byte FLimit = this.LoopFilterLimits[QIndex];
        if (FLimit == 0) {
            return;
        }
        this.SetupBoundingValueArray_Generic(FLimit);
        for (int j = 0; j < 3; ++j) {
            int index;
            int n;
            int LineFragments;
            int LineLength;
            int FromFragment;
            switch (j) {
                case 0: {
                    FromFragment = 0;
                    FragsAcross = pbi.HFragments;
                    FragsDown = pbi.VFragments;
                    LineLength = pbi.YStride;
                    LineFragments = pbi.HFragments;
                    break;
                }
                case 1: {
                    FromFragment = pbi.YPlaneFragments;
                    FragsAcross = pbi.HFragments >> 1;
                    FragsDown = pbi.VFragments >> 1;
                    LineLength = pbi.UVStride;
                    LineFragments = pbi.HFragments / 2;
                    break;
                }
                default: {
                    FromFragment = pbi.YPlaneFragments + pbi.UVPlaneFragments;
                    FragsAcross = pbi.HFragments >> 1;
                    FragsDown = pbi.VFragments >> 1;
                    LineLength = pbi.UVStride;
                    LineFragments = pbi.HFragments / 2;
                }
            }
            int i = FromFragment;
            if (pbi.display_fragments[i] != 0) {
                if (pbi.display_fragments[i + 1] == 0) {
                    this.FilterHoriz(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i] + 6, LineLength, this.FiltBoundingValue);
                }
                if (pbi.display_fragments[i + LineFragments] == 0) {
                    this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                }
            }
            ++i;
            for (n = 1; n < FragsAcross - 1; ++n) {
                if (pbi.display_fragments[i] != 0) {
                    index = pbi.recon_pixel_index_table[i];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                    if (pbi.display_fragments[i + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i;
            }
            if (pbi.display_fragments[i] != 0) {
                this.FilterHoriz(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i] - 2, LineLength, this.FiltBoundingValue);
                if (pbi.display_fragments[i + LineFragments] == 0) {
                    this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                }
            }
            ++i;
            for (int m = 1; m < FragsDown - 1; ++m) {
                if (pbi.display_fragments[i] != 0) {
                    index = pbi.recon_pixel_index_table[i];
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                    if (pbi.display_fragments[i + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i;
                n = 1;
                while (n < FragsAcross - 1) {
                    if (pbi.display_fragments[i] != 0) {
                        index = pbi.recon_pixel_index_table[i];
                        this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                        this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                        if (pbi.display_fragments[i + 1] == 0) {
                            this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                        }
                        if (pbi.display_fragments[i + LineFragments] == 0) {
                            this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                        }
                    }
                    ++n;
                    ++i;
                }
                if (pbi.display_fragments[i] != 0) {
                    index = pbi.recon_pixel_index_table[i];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i;
            }
            if (pbi.display_fragments[i] != 0) {
                index = pbi.recon_pixel_index_table[i];
                this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                if (pbi.display_fragments[i + 1] == 0) {
                    this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                }
            }
            ++i;
            n = 1;
            while (n < FragsAcross - 1) {
                if (pbi.display_fragments[i] != 0) {
                    index = pbi.recon_pixel_index_table[i];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                }
                ++n;
                ++i;
            }
            if (pbi.display_fragments[i] == 0) continue;
            index = pbi.recon_pixel_index_table[i];
            this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
            this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
        }
    }
}

