/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.fluendo.jkate.Bitmap;
import com.fluendo.jkate.Bitwise;
import com.fluendo.jkate.Color;
import com.fluendo.jkate.Comment;
import com.fluendo.jkate.Curve;
import com.fluendo.jkate.FontMapping;
import com.fluendo.jkate.FontRange;
import com.fluendo.jkate.KateBadPacketException;
import com.fluendo.jkate.KateBitmapType;
import com.fluendo.jkate.KateCurveType;
import com.fluendo.jkate.KateException;
import com.fluendo.jkate.KateMarkupType;
import com.fluendo.jkate.KateMotionMapping;
import com.fluendo.jkate.KateMotionSemantics;
import com.fluendo.jkate.KateSpaceMetric;
import com.fluendo.jkate.KateTextDirectionality;
import com.fluendo.jkate.KateTextEncoding;
import com.fluendo.jkate.KateWrapMode;
import com.fluendo.jkate.Motion;
import com.fluendo.jkate.Palette;
import com.fluendo.jkate.RLE;
import com.fluendo.jkate.Region;
import com.fluendo.jkate.Style;
import com.fluendo.utils.Debug;
import com.jcraft.jogg.Buffer;
import com.jcraft.jogg.Packet;

public class Info {
    public int bitstream_version_major = -1;
    public int bitstream_version_minor = -1;
    public KateTextEncoding text_encoding;
    public KateTextDirectionality text_directionality;
    public int num_headers = 0;
    public int granule_shift;
    public int gps_numerator;
    public int gps_denominator;
    public String language;
    public String category;
    public Region[] regions;
    public Style[] styles;
    public Curve[] curves;
    public Motion[] motions;
    public Palette[] palettes;
    public Bitmap[] bitmaps;
    public FontRange[] font_ranges;
    public FontMapping[] font_mappings;
    public KateMarkupType markup_type;
    public int original_canvas_width;
    public int original_canvas_height;
    private int probe = 0;

    private static int read_canvas_size(Buffer opb) {
        int value = opb.read(8) | opb.read(8) << 8;
        int base = value >> 4;
        int shift = value & 0xF;
        return base << shift;
    }

    private int unpackInfo(Buffer opb) {
        this.bitstream_version_major = (byte)opb.read(8);
        this.bitstream_version_minor = (byte)opb.read(8);
        Debug.info("Kate bitstream v" + this.bitstream_version_major + "." + this.bitstream_version_minor);
        if (this.bitstream_version_major > 0) {
            return -9;
        }
        this.num_headers = opb.read(8);
        if (this.num_headers < 1) {
            return -6;
        }
        int tmp = opb.read(8);
        if (tmp != 0) {
            return -6;
        }
        try {
            this.text_encoding = KateTextEncoding.CreateTextEncoding(tmp);
            this.text_directionality = KateTextDirectionality.CreateTextDirectionality(opb.read(8));
        }
        catch (KateException e) {
            return -6;
        }
        int reserved = opb.read(8);
        if (this.bitstream_version_major == 0 && this.bitstream_version_minor < 3 && reserved != 0) {
            return -6;
        }
        this.granule_shift = opb.read(8);
        this.original_canvas_width = Info.read_canvas_size(opb);
        this.original_canvas_height = Info.read_canvas_size(opb);
        reserved = Bitwise.read32(opb);
        if (this.bitstream_version_major == 0 && this.bitstream_version_minor < 3 && reserved != 0) {
            return -6;
        }
        this.gps_numerator = Bitwise.read32(opb);
        this.gps_denominator = Bitwise.read32(opb);
        if (this.granule_shift >= 64) {
            return -6;
        }
        if (this.gps_numerator == 0 || this.gps_denominator == 0) {
            return -6;
        }
        byte[] buffer16 = new byte[16];
        this.language = "";
        int buffer_characters = 0;
        Bitwise.readbuf(opb, buffer16, 16);
        if (buffer16[15] != 0) {
            return -6;
        }
        for (buffer_characters = 0; buffer_characters < 16 && buffer16[buffer_characters] != 0; ++buffer_characters) {
        }
        this.language = new String(buffer16, 0, buffer_characters);
        this.category = "";
        buffer_characters = 0;
        Bitwise.readbuf(opb, buffer16, 16);
        if (buffer16[15] != 0) {
            return -6;
        }
        for (buffer_characters = 0; buffer_characters < 16 && buffer16[buffer_characters] != 0; ++buffer_characters) {
        }
        this.category = new String(buffer16, 0, buffer_characters);
        if (opb.read(1) != -1) {
            return -6;
        }
        return 0;
    }

    static int checkEOP(Buffer opb) {
        int bits = 7 & 8 - (opb.bits() & 7);
        if (bits > 0 && opb.read(bits) != 0) {
            return -6;
        }
        if (opb.look1() != -1) {
            return -6;
        }
        return 0;
    }

    private int unpackComment(Comment kc, Buffer opb) {
        int len = Bitwise.read32(opb);
        if (len < 0) {
            return -6;
        }
        byte[] tmp = new byte[len];
        Bitwise.readbuf(opb, tmp, len);
        kc.vendor = new String(tmp);
        int comments = Bitwise.read32(opb);
        if (comments < 0) {
            kc.clear();
            return -6;
        }
        kc.user_comments = new String[comments];
        for (int i = 0; i < comments; ++i) {
            len = Bitwise.read32(opb);
            if (len < 0) {
                kc.clear();
                return -6;
            }
            tmp = new byte[len];
            Bitwise.readbuf(opb, tmp, len);
            kc.user_comments[i] = new String(tmp);
        }
        return 0;
    }

    public Region unpackRegion(Buffer opb) throws KateException {
        Region kr = new Region();
        kr.metric = KateSpaceMetric.CreateSpaceMetric(opb.read(8));
        kr.x = Bitwise.read32v(opb);
        kr.y = Bitwise.read32v(opb);
        kr.w = Bitwise.read32v(opb);
        kr.h = Bitwise.read32v(opb);
        kr.style = Bitwise.read32v(opb);
        if ((this.bitstream_version_major << 8 | this.bitstream_version_minor) >= 2) {
            Bitwise.read32v(opb);
            kr.clip = opb.read1() != 0;
        } else {
            kr.clip = false;
        }
        Bitwise.skipWarp(opb);
        return kr;
    }

    private int unpackRegions(Buffer opb) {
        int nregions = Bitwise.read32v(opb);
        if (nregions < 0) {
            return -6;
        }
        this.regions = new Region[nregions];
        for (int n = 0; n < nregions; ++n) {
            try {
                this.regions[n] = this.unpackRegion(opb);
                continue;
            }
            catch (KateException ke) {
                this.regions = null;
                return -6;
            }
        }
        Bitwise.skipWarp(opb);
        return Info.checkEOP(opb);
    }

    private Color unpackColor(Buffer opb) {
        Color color = new Color();
        color.r = (byte)opb.read(8);
        color.g = (byte)opb.read(8);
        color.b = (byte)opb.read(8);
        color.a = (byte)opb.read(8);
        return color;
    }

    public Style unpackStyle(Buffer opb) throws KateException {
        Style ks = new Style();
        double[][] floats = Bitwise.readFloats(opb, 8, 1);
        int idx = 0;
        ks.halign = floats[0][idx++];
        ks.valign = floats[0][idx++];
        ks.font_width = floats[0][idx++];
        ks.font_height = floats[0][idx++];
        ks.left_margin = floats[0][idx++];
        ks.top_margin = floats[0][idx++];
        ks.right_margin = floats[0][idx++];
        ks.bottom_margin = floats[0][idx++];
        ks.text_color = this.unpackColor(opb);
        ks.background_color = this.unpackColor(opb);
        ks.draw_color = this.unpackColor(opb);
        ks.font_metric = KateSpaceMetric.CreateSpaceMetric(opb.read(8));
        ks.margin_metric = KateSpaceMetric.CreateSpaceMetric(opb.read(8));
        ks.bold = opb.read1() != 0;
        ks.italics = opb.read1() != 0;
        ks.underline = opb.read1() != 0;
        boolean bl = ks.strike = opb.read1() != 0;
        if ((this.bitstream_version_major << 8 | this.bitstream_version_minor) >= 2) {
            Bitwise.read32v(opb);
            ks.justify = opb.read1() != 0;
            int len = Bitwise.read32v(opb);
            if (len < 0) {
                throw new KateBadPacketException();
            }
            byte[] s = new byte[len];
            Bitwise.readbuf(opb, s, len);
            ks.font = new String(s);
        } else {
            ks.justify = false;
            ks.font = null;
        }
        if ((this.bitstream_version_major << 8 | this.bitstream_version_minor) >= 4) {
            Bitwise.read32v(opb);
            ks.wrap_mode = KateWrapMode.CreateWrapMode(Bitwise.read32v(opb));
        } else {
            ks.wrap_mode = KateWrapMode.kate_wrap_word;
        }
        Bitwise.skipWarp(opb);
        return ks;
    }

    private int unpackStyles(Buffer opb) {
        int nstyles = Bitwise.read32v(opb);
        if (nstyles < 0) {
            return -6;
        }
        this.styles = new Style[nstyles];
        for (int n = 0; n < nstyles; ++n) {
            try {
                this.styles[n] = this.unpackStyle(opb);
                continue;
            }
            catch (KateException ke) {
                this.styles = null;
                return -6;
            }
        }
        Bitwise.skipWarp(opb);
        return Info.checkEOP(opb);
    }

    private Curve unpackCurve(Buffer opb) throws KateException {
        Curve kc = new Curve();
        kc.type = KateCurveType.CreateCurveType(opb.read(8));
        kc.npts = Bitwise.read32v(opb);
        if (kc.npts < 0) {
            throw new KateBadPacketException();
        }
        Bitwise.skipWarp(opb);
        kc.pts = Bitwise.readFloats(opb, kc.npts, 2);
        return kc;
    }

    private int unpackCurves(Buffer opb) {
        int ncurves = Bitwise.read32v(opb);
        if (ncurves < 0) {
            return -6;
        }
        this.curves = new Curve[ncurves];
        for (int n = 0; n < ncurves; ++n) {
            try {
                this.curves[n] = this.unpackCurve(opb);
                continue;
            }
            catch (KateException ke) {
                this.curves = null;
                return -6;
            }
        }
        Bitwise.skipWarp(opb);
        return Info.checkEOP(opb);
    }

    public Motion unpackMotion(Buffer opb) throws KateException {
        Motion km = new Motion();
        int ncurves = Bitwise.read32v(opb);
        if (ncurves < 0) {
            throw new KateBadPacketException();
        }
        km.curves = new Curve[ncurves];
        for (int n = 0; n < ncurves; ++n) {
            if (opb.read1() != 0) {
                int idx = Bitwise.read32v(opb);
                if (idx < 0 || idx >= this.curves.length) {
                    throw new KateBadPacketException();
                }
                km.curves[n] = this.curves[idx];
                continue;
            }
            km.curves[n] = this.unpackCurve(opb);
        }
        double[][] floats = Bitwise.readFloats(opb, ncurves, 1);
        km.durations = new double[ncurves];
        for (int n = 0; n < ncurves; ++n) {
            km.durations[n] = floats[0][n];
        }
        km.x_mapping = KateMotionMapping.CreateMotionMapping(opb.read(8));
        km.y_mapping = KateMotionMapping.CreateMotionMapping(opb.read(8));
        km.semantics = KateMotionSemantics.CreateMotionSemantics(opb.read(8));
        km.periodic = opb.read1() != 0;
        Bitwise.skipWarp(opb);
        return km;
    }

    private int unpackMotions(Buffer opb) {
        int nmotions = Bitwise.read32v(opb);
        if (nmotions < 0) {
            return -6;
        }
        this.motions = new Motion[nmotions];
        for (int n = 0; n < nmotions; ++n) {
            try {
                this.motions[n] = this.unpackMotion(opb);
                continue;
            }
            catch (KateException ke) {
                this.motions = null;
                return -6;
            }
        }
        Bitwise.skipWarp(opb);
        return Info.checkEOP(opb);
    }

    public Palette unpackPalette(Buffer opb) throws KateException {
        Palette kp = new Palette();
        int ncolors = opb.read(8) + 1;
        kp.colors = new Color[ncolors];
        for (int n = 0; n < ncolors; ++n) {
            kp.colors[n] = this.unpackColor(opb);
        }
        Bitwise.skipWarp(opb);
        return kp;
    }

    private int unpackPalettes(Buffer opb) {
        int npalettes = Bitwise.read32v(opb);
        if (npalettes < 0) {
            return -6;
        }
        this.palettes = new Palette[npalettes];
        for (int n = 0; n < npalettes; ++n) {
            try {
                this.palettes[n] = this.unpackPalette(opb);
                continue;
            }
            catch (KateException ke) {
                this.palettes = null;
                return -6;
            }
        }
        Bitwise.skipWarp(opb);
        return Info.checkEOP(opb);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Bitmap unpackBitmap(Buffer opb) throws KateException {
        Bitmap kb = new Bitmap();
        kb.width = Bitwise.read32v(opb);
        kb.height = Bitwise.read32v(opb);
        kb.bpp = opb.read(8);
        if (kb.width < 0 || kb.height < 0 || kb.bpp < 0 || kb.bpp > 8) {
            throw new KateBadPacketException();
        }
        if (kb.bpp == 0) {
            kb.type = KateBitmapType.CreateBitmapType(opb.read(8));
            kb.palette = -1;
            if (kb.type == KateBitmapType.kate_bitmap_type_paletted) {
                int encoding = opb.read(8);
                switch (encoding) {
                    case 1: {
                        kb.bpp = Bitwise.read32v(opb);
                        kb.palette = Bitwise.read32v(opb);
                        kb.pixels = RLE.decodeRLE(opb, kb.width, kb.height, kb.bpp);
                        break;
                    }
                    default: {
                        Debug.warning("Unsupported bitmap type");
                        throw new KateBadPacketException();
                    }
                }
            } else {
                if (kb.type != KateBitmapType.kate_bitmap_type_png) {
                    Debug.warning("Unsupported bitmap type");
                    throw new KateBadPacketException();
                }
                kb.size = Bitwise.read32(opb);
                kb.pixels = new byte[kb.size];
                Bitwise.readbuf(opb, kb.pixels, kb.size);
            }
        } else {
            kb.type = KateBitmapType.kate_bitmap_type_paletted;
            kb.palette = Bitwise.read32v(opb);
            int npixels = kb.width * kb.height;
            kb.pixels = new byte[npixels];
            for (int n = 0; n < npixels; ++n) {
                kb.pixels[n] = (byte)opb.read(kb.bpp);
            }
        }
        if ((this.bitstream_version_major << 8 | this.bitstream_version_minor) >= 4) {
            Bitwise.read32v(opb);
            kb.x_offset = Bitwise.read32v(opb);
            kb.y_offset = Bitwise.read32v(opb);
        } else {
            kb.x_offset = 0;
            kb.y_offset = 0;
        }
        Bitwise.skipWarp(opb);
        return kb;
    }

    private int unpackBitmaps(Buffer opb) {
        int nbitmaps = Bitwise.read32v(opb);
        if (nbitmaps < 0) {
            return -6;
        }
        this.bitmaps = new Bitmap[nbitmaps];
        for (int n = 0; n < nbitmaps; ++n) {
            try {
                this.bitmaps[n] = this.unpackBitmap(opb);
                continue;
            }
            catch (KateException ke) {
                this.bitmaps = null;
                return -6;
            }
        }
        Bitwise.skipWarp(opb);
        return Info.checkEOP(opb);
    }

    private FontRange unpackFontRange(Buffer opb) {
        FontRange fr = new FontRange();
        fr.first_code_point = Bitwise.read32v(opb);
        fr.last_code_point = Bitwise.read32v(opb);
        fr.first_bitmap = Bitwise.read32v(opb);
        Bitwise.skipWarp(opb);
        return fr;
    }

    private int unpackFontMappings(Buffer opb) {
        int nmappings;
        int nranges = Bitwise.read32v(opb);
        if (nranges < 0) {
            return -6;
        }
        if (nranges > 0) {
            this.font_ranges = new FontRange[nranges];
            for (int n = 0; n < nranges; ++n) {
                this.font_ranges[n] = this.unpackFontRange(opb);
            }
        }
        if ((nmappings = Bitwise.read32v(opb)) < 0) {
            return -6;
        }
        if (nmappings > 0) {
            this.font_mappings = new FontMapping[nmappings];
            for (int n = 0; n < nmappings; ++n) {
                nranges = Bitwise.read32v(opb);
                if (nranges < 0) {
                    return -6;
                }
                if (nranges > 0) {
                    FontRange[] fr = new FontRange[nranges];
                    for (int l = 0; l < nranges; ++l) {
                        if (opb.read1() != 0) {
                            int idx = Bitwise.read32v(opb);
                            if (idx < 0 || idx >= this.font_ranges.length) {
                                return -6;
                            }
                            fr[l] = this.font_ranges[idx];
                            continue;
                        }
                        fr[l] = this.unpackFontRange(opb);
                    }
                    this.font_mappings[n].ranges = fr;
                    continue;
                }
                this.font_mappings[n] = null;
            }
        }
        Bitwise.skipWarp(opb);
        return Info.checkEOP(opb);
    }

    public void clear() {
        this.num_headers = 0;
        this.regions = null;
        this.styles = null;
        this.curves = null;
        this.motions = null;
        this.probe = 0;
    }

    public int decodeHeader(Comment kc, Packet op) {
        long ret;
        Buffer opb = new Buffer();
        opb.readinit(op.packet_base, op.packet, op.bytes);
        byte[] id = new byte[7];
        int typeflag = opb.read(8);
        if ((typeflag & 0x80) == 0) {
            return -6;
        }
        Bitwise.readbuf(opb, id, 7);
        if (!"kate\u0000\u0000\u0000".equals(new String(id))) {
            return -10;
        }
        if (op.packetno < (long)this.num_headers && (long)this.probe != op.packetno) {
            return -6;
        }
        if (opb.read(8) != 0) {
            return -6;
        }
        Debug.debug("decodeHeader: packet type " + typeflag + ", probe " + this.probe);
        switch (this.probe) {
            case 0: {
                if (op.b_o_s == 0) {
                    return -6;
                }
                ret = this.unpackInfo(opb);
                break;
            }
            case 1: {
                ret = this.unpackComment(kc, opb);
                break;
            }
            case 2: {
                ret = this.unpackRegions(opb);
                break;
            }
            case 3: {
                ret = this.unpackStyles(opb);
                break;
            }
            case 4: {
                ret = this.unpackCurves(opb);
                break;
            }
            case 5: {
                ret = this.unpackMotions(opb);
                break;
            }
            case 6: {
                ret = this.unpackPalettes(opb);
                break;
            }
            case 7: {
                ret = this.unpackBitmaps(opb);
                break;
            }
            case 8: {
                ret = this.unpackFontMappings(opb);
                if (ret != 0L) break;
                Debug.debug("Found last known header, returning 1");
                ret = 1L;
                break;
            }
            default: {
                ret = 0L;
            }
        }
        if (ret >= 0L) {
            ++this.probe;
        }
        return (int)ret;
    }
}

