/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.pmd.ShadeInfo;
import jp.sourceforge.mikutoga.pmd.Surface;

public class Material
implements Iterable<Surface> {
    private final I18nText materialName = new I18nText();
    private Color diffuseColor;
    private Color specularColor;
    private float shininess;
    private Color ambientColor;
    private final ShadeInfo shadeInfo = new ShadeInfo();
    private boolean edgeAppearance = true;
    private final List<Surface> surfaceList = new ArrayList<Surface>();

    private static Color forceOpaque(Color color) {
        if (color.getTransparency() == 1) {
            return color;
        }
        float[] rgba = new float[4];
        color.getRGBColorComponents(rgba);
        Color result = new Color(rgba[0], rgba[1], rgba[2], 1.0f);
        return result;
    }

    public I18nText getMaterialName() {
        return this.materialName;
    }

    public void setDiffuseColor(Color color) throws NullPointerException {
        if (color == null) {
            throw new NullPointerException();
        }
        this.diffuseColor = color;
    }

    public Color getDiffuseColor() {
        return this.diffuseColor;
    }

    public void setSpecularColor(Color color) throws NullPointerException {
        if (color == null) {
            throw new NullPointerException();
        }
        this.specularColor = Material.forceOpaque(color);
    }

    public Color getSpecularColor() {
        return this.specularColor;
    }

    public void setAmbientColor(Color color) throws NullPointerException {
        if (color == null) {
            throw new NullPointerException();
        }
        this.ambientColor = Material.forceOpaque(color);
    }

    public Color getAmbientColor() {
        return this.ambientColor;
    }

    public void setShininess(float shininess) {
        this.shininess = shininess;
    }

    public float getShininess() {
        return this.shininess;
    }

    public ShadeInfo getShadeInfo() {
        return this.shadeInfo;
    }

    public void setEdgeAppearance(boolean show) {
        this.edgeAppearance = show;
    }

    public boolean getEdgeAppearance() {
        return this.edgeAppearance;
    }

    public List<Surface> getSurfaceList() {
        return this.surfaceList;
    }

    @Override
    public Iterator<Surface> iterator() {
        return this.surfaceList.iterator();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Material ");
        float[] rgba = new float[4];
        this.diffuseColor.getRGBComponents(rgba);
        result.append("diffuse=[").append(rgba[0]).append(", ").append(rgba[1]).append(", ").append(rgba[2]).append(", ").append(rgba[3]).append(']').append(' ');
        this.specularColor.getRGBComponents(rgba);
        result.append("specular=[").append(rgba[0]).append(", ").append(rgba[1]).append(", ").append(rgba[2]).append(", ").append(rgba[3]).append(']').append(' ');
        this.ambientColor.getRGBComponents(rgba);
        result.append("ambient=[").append(rgba[0]).append(", ").append(rgba[1]).append(", ").append(rgba[2]).append(", ").append(rgba[3]).append(']').append(' ');
        result.append("shininess=").append(this.shininess).append(' ');
        result.append("edge=").append(this.edgeAppearance).append(' ');
        result.append("surfaces=").append(this.surfaceList.size()).append(' ');
        result.append(this.shadeInfo);
        return result.toString();
    }
}

