/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd;

import java.util.ArrayList;
import java.util.Collection;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.corelib.SerialNumbered;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.DynamicsInfo;
import jp.sourceforge.mikutoga.pmd.Pos3d;
import jp.sourceforge.mikutoga.pmd.Rad3d;
import jp.sourceforge.mikutoga.pmd.RigidBehaviorType;
import jp.sourceforge.mikutoga.pmd.RigidGroup;
import jp.sourceforge.mikutoga.pmd.RigidShape;

public class RigidInfo
implements SerialNumbered {
    private final I18nText rigidName = new I18nText();
    private RigidBehaviorType behaviorType = RigidBehaviorType.FOLLOWBONE;
    private final RigidShape rigidShape = new RigidShape();
    private final Pos3d position = new Pos3d();
    private final Rad3d rotation = new Rad3d();
    private BoneInfo linkedBone;
    private final DynamicsInfo dynamicsInfo = new DynamicsInfo();
    private final Collection<RigidGroup> throughGroupColl = new ArrayList<RigidGroup>();
    private RigidGroup rigidGroup;
    private int serialNo = -1;

    public I18nText getRigidName() {
        return this.rigidName;
    }

    public RigidBehaviorType getBehaviorType() {
        return this.behaviorType;
    }

    public void setBehaviorType(RigidBehaviorType type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException();
        }
        this.behaviorType = type;
    }

    public RigidShape getRigidShape() {
        return this.rigidShape;
    }

    public Pos3d getPosition() {
        return this.position;
    }

    public Rad3d getRotation() {
        return this.rotation;
    }

    public BoneInfo getLinkedBone() {
        return this.linkedBone;
    }

    public void setLinkedBone(BoneInfo bone) {
        this.linkedBone = bone;
    }

    public DynamicsInfo getDynamicsInfo() {
        return this.dynamicsInfo;
    }

    public Collection<RigidGroup> getThroughGroupColl() {
        return this.throughGroupColl;
    }

    public RigidGroup getRigidGroup() {
        return this.rigidGroup;
    }

    public void setRigidGroup(RigidGroup group) {
        this.rigidGroup = group;
    }

    @Override
    public void setSerialNumber(int num) {
        this.serialNo = num;
    }

    @Override
    public int getSerialNumber() {
        return this.serialNo;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Rigid(").append(this.rigidName).append(") ");
        result.append("[=>").append(this.linkedBone.getBoneName()).append("bone]");
        result.append(" [").append(this.rigidShape).append("]");
        result.append(" ").append(this.position);
        result.append(" ").append(this.rotation);
        result.append(" [").append(this.dynamicsInfo).append("]");
        result.append("  [").append((Object)this.behaviorType).append("]");
        result.append(" through[");
        boolean dumped = false;
        for (RigidGroup group : this.throughGroupColl) {
            if (dumped) {
                result.append(" ");
            }
            result.append(group.getGroupNumber());
            dumped = true;
        }
        result.append("]");
        return result.toString();
    }
}

