/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdexporter;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import jp.sourceforge.mikutoga.pmd.pmdexporter.IllegalPmdTextException;

public abstract class AbstractExporter {
    private static final Charset CS_WIN31J = Charset.forName("windows-31j");
    private static final String ERRMSG_TOOLONGTEXT = "too long text";
    private static final String ERRMSG_INVUCSSEQ = "invalid unicode sequence";
    private static final String ERRMSG_NONWIN31J = "no character in win31j";
    private static final int BYTES_SHORT = 2;
    private static final int BYTES_INT = 4;
    private static final int BYTES_FLOAT = 4;
    private static final int BUFSZ_BYTE = 512;
    private static final int BUFSZ_CHAR = 512;
    private final OutputStream ostream;
    private final byte[] barray;
    private final ByteBuffer bbuf;
    private final CharBuffer cbuf;
    private final CharsetEncoder encoder;

    protected AbstractExporter(OutputStream stream) throws NullPointerException {
        if (stream == null) {
            throw new NullPointerException();
        }
        this.ostream = stream;
        this.barray = new byte[512];
        this.bbuf = ByteBuffer.wrap(this.barray);
        this.bbuf.order(ByteOrder.LITTLE_ENDIAN);
        this.cbuf = CharBuffer.allocate(512);
        this.encoder = CS_WIN31J.newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPORT);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.encoder.reset();
    }

    protected void flush() throws IOException {
        this.ostream.flush();
    }

    protected void dumpByte(byte bVal) throws IOException {
        this.ostream.write(bVal);
    }

    protected void dumpByte(int iVal) throws IOException {
        this.dumpByte((byte)iVal);
    }

    protected void dumpShort(short sVal) throws IOException {
        this.bbuf.clear();
        this.bbuf.putShort(sVal);
        this.ostream.write(this.barray, 0, 2);
    }

    protected void dumpShort(int iVal) throws IOException {
        this.dumpShort((short)iVal);
    }

    protected void dumpInt(int iVal) throws IOException {
        this.bbuf.clear();
        this.bbuf.putInt(iVal);
        this.ostream.write(this.barray, 0, 4);
    }

    protected void dumpFloat(float fVal) throws IOException {
        this.bbuf.clear();
        this.bbuf.putFloat(fVal);
        this.ostream.write(this.barray, 0, 4);
    }

    protected int dumpCharSequence(CharSequence seq) throws IOException, IllegalPmdTextException {
        this.encodeToByteBuffer(seq);
        this.bbuf.flip();
        int length = this.dumpByteBuffer();
        return length;
    }

    private void encodeToByteBuffer(CharSequence seq) throws IllegalPmdTextException {
        this.cbuf.clear();
        try {
            this.cbuf.append(seq);
        }
        catch (BufferOverflowException e) {
            throw new IllegalPmdTextException(ERRMSG_TOOLONGTEXT);
        }
        this.cbuf.flip();
        this.bbuf.clear();
        CoderResult result = this.encoder.encode(this.cbuf, this.bbuf, true);
        if (!result.isUnderflow()) {
            if (result.isOverflow()) {
                throw new IllegalPmdTextException(ERRMSG_TOOLONGTEXT);
            }
            if (result.isMalformed()) {
                throw new IllegalPmdTextException(ERRMSG_INVUCSSEQ);
            }
            if (result.isUnmappable()) {
                throw new IllegalPmdTextException(ERRMSG_NONWIN31J);
            }
            assert (false);
            throw new AssertionError();
        }
    }

    private int dumpByteBuffer() throws IOException {
        int offset = this.bbuf.position();
        int limit = this.bbuf.limit();
        int length = limit - offset;
        this.ostream.write(this.barray, offset, length);
        this.bbuf.position(limit);
        return length;
    }
}

