/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdexporter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.Deg3d;
import jp.sourceforge.mikutoga.pmd.DynamicsInfo;
import jp.sourceforge.mikutoga.pmd.JointInfo;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.Rad3d;
import jp.sourceforge.mikutoga.pmd.RigidGroup;
import jp.sourceforge.mikutoga.pmd.RigidInfo;
import jp.sourceforge.mikutoga.pmd.RigidShape;
import jp.sourceforge.mikutoga.pmd.RigidShapeType;
import jp.sourceforge.mikutoga.pmd.TripletRange;
import jp.sourceforge.mikutoga.pmd.pmdexporter.IllegalPmdException;
import jp.sourceforge.mikutoga.pmd.pmdexporter.IllegalPmdTextException;
import jp.sourceforge.mikutoga.pmd.pmdexporter.PmdExporterExt2;

public class PmdExporterExt3
extends PmdExporterExt2 {
    private static final short MASK_FULLCOLLISION = -1;

    public PmdExporterExt3(OutputStream stream) throws NullPointerException {
        super(stream);
    }

    @Override
    public void dumpPmdModel(PmdModel model) throws IOException, IllegalPmdException {
        super.dumpPmdModel(model);
        this.dumpRigidList(model);
        this.dumpJointList(model);
    }

    private void dumpRigidList(PmdModel model) throws IOException, IllegalPmdTextException {
        List<RigidInfo> rigidList = model.getRigidList();
        int rigidNum = rigidList.size();
        this.dumpInt(rigidNum);
        for (RigidInfo rigid : rigidList) {
            this.dumpRigid(rigid);
        }
        this.flush();
    }

    private void dumpRigid(RigidInfo rigid) throws IOException, IllegalPmdTextException {
        String rigidName = rigid.getRigidName().getPrimaryText();
        this.dumpText(rigidName, 20);
        BoneInfo linkedBone = rigid.getLinkedBone();
        this.dumpShort(linkedBone.getSerialNumber());
        RigidGroup group = rigid.getRigidGroup();
        this.dumpByte(group.getSerialNumber());
        short mask = -1;
        for (RigidGroup throughGroup : rigid.getThroughGroupColl()) {
            int serialId = throughGroup.getSerialNumber();
            mask = (short)(mask & ~(1 << serialId));
        }
        this.dumpShort(mask);
        this.dumpRigidShape(rigid.getRigidShape());
        this.dumpPos3d(rigid.getPosition());
        this.dumpRad3d(rigid.getRotation());
        this.dumpDynamics(rigid.getDynamicsInfo());
        this.dumpByte(rigid.getBehaviorType().encode());
    }

    private void dumpRigidShape(RigidShape shape) throws IOException {
        RigidShapeType type = shape.getShapeType();
        this.dumpByte(type.encode());
        float width = shape.getWidth();
        float height = shape.getHeight();
        float depth = shape.getDepth();
        this.dumpFloat(width);
        this.dumpFloat(height);
        this.dumpFloat(depth);
    }

    private void dumpDynamics(DynamicsInfo dynamics) throws IOException {
        float mass = dynamics.getMass();
        float dampPos = dynamics.getDampingPosition();
        float dampRot = dynamics.getDampingRotation();
        float restitution = dynamics.getRestitution();
        float friction = dynamics.getFriction();
        this.dumpFloat(mass);
        this.dumpFloat(dampPos);
        this.dumpFloat(dampRot);
        this.dumpFloat(restitution);
        this.dumpFloat(friction);
    }

    private void dumpJointList(PmdModel model) throws IOException, IllegalPmdTextException {
        List<JointInfo> jointList = model.getJointList();
        int jointNum = jointList.size();
        this.dumpInt(jointNum);
        for (JointInfo joint : jointList) {
            this.dumpJoint(joint);
        }
        this.flush();
    }

    private void dumpJoint(JointInfo joint) throws IOException, IllegalPmdTextException {
        String jointName = joint.getJointName().getPrimaryText();
        this.dumpText(jointName, 20);
        RigidInfo rigidA = joint.getRigidA();
        RigidInfo rigidB = joint.getRigidB();
        this.dumpInt(rigidA.getSerialNumber());
        this.dumpInt(rigidB.getSerialNumber());
        this.dumpPos3d(joint.getPosition());
        this.dumpRad3d(joint.getRotation());
        this.dumpTripletRange(joint.getPositionRange());
        this.dumpTripletRange(joint.getRotationRange());
        this.dumpPos3d(joint.getElasticPosition());
        this.dumpDeg3d(joint.getElasticRotation());
    }

    protected void dumpTripletRange(TripletRange range) throws IOException {
        float xFrom = range.getXFrom();
        float yFrom = range.getYFrom();
        float zFrom = range.getZFrom();
        this.dumpFloat(xFrom);
        this.dumpFloat(yFrom);
        this.dumpFloat(zFrom);
        float xTo = range.getXTo();
        float yTo = range.getYTo();
        float zTo = range.getZTo();
        this.dumpFloat(xTo);
        this.dumpFloat(yTo);
        this.dumpFloat(zTo);
    }

    protected void dumpRad3d(Rad3d rad) throws IOException {
        float xVal = rad.getXRad();
        float yVal = rad.getYRad();
        float zVal = rad.getZRad();
        this.dumpFloat(xVal);
        this.dumpFloat(yVal);
        this.dumpFloat(zVal);
    }

    protected void dumpDeg3d(Deg3d deg) throws IOException {
        float xVal = deg.getXDeg();
        float yVal = deg.getYDeg();
        float zVal = deg.getZDeg();
        this.dumpFloat(xVal);
        this.dumpFloat(yVal);
        this.dumpFloat(zVal);
    }
}

