/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdloader;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mikutoga.corelib.ListUtil;
import jp.sourceforge.mikutoga.parser.ParseStage;
import jp.sourceforge.mikutoga.parser.pmd.PmdBoneHandler;
import jp.sourceforge.mikutoga.pmd.BoneGroup;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.BoneType;
import jp.sourceforge.mikutoga.pmd.IKChain;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.Pos3d;

class BoneBuilder
implements PmdBoneHandler {
    private final List<BoneInfo> boneList;
    private Iterator<BoneInfo> boneIt;
    private BoneInfo currentBone = null;
    private final List<IKChain> ikChainList;
    private Iterator<IKChain> ikChainIt;
    private IKChain currentIkChain = null;
    private final List<BoneGroup> boneGroupList;
    private Iterator<BoneGroup> boneGroupIt;
    private BoneGroup currentBoneGroup = null;

    BoneBuilder(PmdModel model) {
        this.boneList = model.getBoneList();
        this.ikChainList = model.getIKChainList();
        this.boneGroupList = model.getBoneGroupList();
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        assert (stage instanceof PmdBoneHandler.PmdBoneStage);
        if (stage == PmdBoneHandler.BONE_LIST) {
            ListUtil.prepareDefConsList(this.boneList, BoneInfo.class, loops);
            ListUtil.assignIndexedSerial(this.boneList);
            this.boneIt = this.boneList.iterator();
            if (this.boneIt.hasNext()) {
                this.currentBone = this.boneIt.next();
            }
        } else if (stage == PmdBoneHandler.IK_LIST) {
            ListUtil.prepareDefConsList(this.ikChainList, IKChain.class, loops);
            this.ikChainIt = this.ikChainList.iterator();
            if (this.ikChainIt.hasNext()) {
                this.currentIkChain = this.ikChainIt.next();
            }
        } else if (stage != PmdBoneHandler.IKCHAIN_LIST) {
            if (stage == PmdBoneHandler.BONEGROUP_LIST) {
                ListUtil.prepareDefConsList(this.boneGroupList, BoneGroup.class, loops + 1);
                ListUtil.assignIndexedSerial(this.boneGroupList);
                this.boneGroupIt = this.boneGroupList.iterator();
                assert (this.boneGroupIt.hasNext());
                this.boneGroupIt.next();
                if (this.boneGroupIt.hasNext()) {
                    this.currentBoneGroup = this.boneGroupIt.next();
                }
            } else if (stage != PmdBoneHandler.GROUPEDBONE_LIST) {
                assert (false);
                throw new AssertionError();
            }
        }
    }

    @Override
    public void loopNext(ParseStage stage) {
        assert (stage instanceof PmdBoneHandler.PmdBoneStage);
        if (stage == PmdBoneHandler.BONE_LIST) {
            if (this.boneIt.hasNext()) {
                this.currentBone = this.boneIt.next();
            }
        } else if (stage == PmdBoneHandler.IK_LIST) {
            if (this.ikChainIt.hasNext()) {
                this.currentIkChain = this.ikChainIt.next();
            }
        } else if (stage != PmdBoneHandler.IKCHAIN_LIST) {
            if (stage == PmdBoneHandler.BONEGROUP_LIST) {
                if (this.boneGroupIt.hasNext()) {
                    this.currentBoneGroup = this.boneGroupIt.next();
                }
            } else if (stage != PmdBoneHandler.GROUPEDBONE_LIST) {
                assert (false);
                throw new AssertionError();
            }
        }
    }

    @Override
    public void loopEnd(ParseStage stage) {
        assert (stage instanceof PmdBoneHandler.PmdBoneStage);
        if (stage != PmdBoneHandler.BONE_LIST && stage != PmdBoneHandler.IK_LIST && stage != PmdBoneHandler.IKCHAIN_LIST && stage != PmdBoneHandler.BONEGROUP_LIST) {
            if (stage == PmdBoneHandler.GROUPEDBONE_LIST) {
                this.pickOrphanBone();
            } else {
                assert (false);
                throw new AssertionError();
            }
        }
    }

    private void pickOrphanBone() {
        LinkedList<BoneInfo> orpahnList = new LinkedList<BoneInfo>();
        orpahnList.addAll(this.boneList);
        for (BoneGroup group : this.boneGroupList) {
            orpahnList.removeAll(group.getBoneList());
        }
        BoneGroup defaultGroup = this.boneGroupList.get(0);
        defaultGroup.getBoneList().addAll(orpahnList);
    }

    @Override
    public void pmdBoneInfo(String boneName, byte boneKind) {
        this.currentBone.getBoneName().setPrimaryText(boneName);
        BoneType type = BoneType.decode(boneKind);
        this.currentBone.setBoneType(type);
    }

    @Override
    public void pmdBoneLink(int parentId, int tailId, int ikId) {
        BoneInfo prevBone = null;
        if (0 <= parentId && parentId < 65535) {
            prevBone = this.boneList.get(parentId);
        }
        BoneInfo nextBone = null;
        if (tailId != 0) {
            nextBone = this.boneList.get(tailId);
        }
        BoneInfo ikBone = null;
        if (this.currentBone.getBoneType() == BoneType.LINKEDROT) {
            ikBone = null;
            int ratio = ikId;
            this.currentBone.setRotationRatio(ratio);
        } else if (0 < ikId && ikId < 65535) {
            ikBone = this.boneList.get(ikId);
        }
        this.currentBone.setPrevBone(prevBone);
        this.currentBone.setNextBone(nextBone);
        this.currentBone.setIKBone(ikBone);
    }

    @Override
    public void pmdBonePosition(float xPos, float yPos, float zPos) {
        Pos3d position = this.currentBone.getPosition();
        position.setXPos(xPos);
        position.setYPos(yPos);
        position.setZPos(zPos);
    }

    @Override
    public void pmdIKInfo(int boneId, int targetId, int depth, float weight) {
        BoneInfo bone = this.boneList.get(boneId);
        this.currentIkChain.setIkBone(bone);
        BoneInfo target = this.boneList.get(targetId);
        this.currentIkChain.getChainedBoneList().add(0, target);
        this.currentIkChain.setIKDepth(depth);
        this.currentIkChain.setIKWeight(weight);
    }

    @Override
    public void pmdIKChainInfo(int childId) {
        BoneInfo chain = this.boneList.get(childId);
        this.currentIkChain.getChainedBoneList().add(chain);
    }

    @Override
    public void pmdBoneGroupInfo(String groupName) {
        this.currentBoneGroup.getGroupName().setPrimaryText(groupName);
    }

    @Override
    public void pmdGroupedBoneInfo(int boneId, int groupId) {
        BoneInfo bone = this.boneList.get(boneId);
        BoneGroup group = this.boneGroupList.get(groupId);
        group.getBoneList().add(bone);
    }
}

