/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdloader;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.mikutoga.corelib.ListUtil;
import jp.sourceforge.mikutoga.parser.ParseStage;
import jp.sourceforge.mikutoga.parser.pmd.PmdMaterialHandler;
import jp.sourceforge.mikutoga.pmd.Material;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.ShadeInfo;
import jp.sourceforge.mikutoga.pmd.Surface;
import jp.sourceforge.mikutoga.pmd.ToonMap;

class MaterialBuilder
implements PmdMaterialHandler {
    private final List<Material> materialList;
    private Iterator<Material> materialIt;
    private Material currentMaterial = null;
    private final List<Surface> surfacelList;
    private Iterator<Surface> surfaceIt;
    private final ToonMap toonMap;

    MaterialBuilder(PmdModel model) {
        this.materialList = model.getMaterialList();
        this.surfacelList = model.getSurfaceList();
        this.toonMap = model.getToonMap();
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        assert (stage == PmdMaterialHandler.MATERIAL_LIST);
        ListUtil.prepareDefConsList(this.materialList, Material.class, loops);
        this.materialIt = this.materialList.iterator();
        if (this.materialIt.hasNext()) {
            this.currentMaterial = this.materialIt.next();
        }
        this.surfaceIt = this.surfacelList.iterator();
    }

    @Override
    public void loopNext(ParseStage stage) {
        assert (stage == PmdMaterialHandler.MATERIAL_LIST);
        if (this.materialIt.hasNext()) {
            this.currentMaterial = this.materialIt.next();
        }
    }

    @Override
    public void loopEnd(ParseStage stage) {
        assert (stage == PmdMaterialHandler.MATERIAL_LIST);
    }

    @Override
    public void pmdMaterialDiffuse(float red, float green, float blue, float alpha) {
        Color diffuse = new Color(red, green, blue, alpha);
        this.currentMaterial.setDiffuseColor(diffuse);
    }

    @Override
    public void pmdMaterialAmbient(float red, float green, float blue) {
        Color ambient = new Color(red, green, blue);
        this.currentMaterial.setAmbientColor(ambient);
    }

    @Override
    public void pmdMaterialSpecular(float red, float green, float blue, float shininess) {
        Color specular = new Color(red, green, blue);
        this.currentMaterial.setSpecularColor(specular);
        this.currentMaterial.setShininess(shininess);
    }

    @Override
    public void pmdMaterialInfo(boolean hasEdge, int vertexNum) {
        this.currentMaterial.setEdgeAppearance(hasEdge);
        List<Surface> list = this.currentMaterial.getSurfaceList();
        int surfaceNum = vertexNum / 3;
        for (int ct = 1; ct <= surfaceNum; ++ct) {
            Surface surface = this.surfaceIt.next();
            list.add(surface);
        }
    }

    @Override
    public void pmdMaterialShading(int toonIdx, String textureFile, String sphereFile) {
        ShadeInfo info = this.currentMaterial.getShadeInfo();
        ToonMap map = this.toonMap;
        info.setToonMap(map);
        info.setToonIndex(toonIdx);
        info.setTextureFileName(textureFile);
        info.setSpheremapFileName(sphereFile);
    }
}

