/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdloader;

import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import jp.sourceforge.mikutoga.corelib.ListUtil;
import jp.sourceforge.mikutoga.parser.ParseStage;
import jp.sourceforge.mikutoga.parser.pmd.PmdShapeHandler;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.Pos2d;
import jp.sourceforge.mikutoga.pmd.Pos3d;
import jp.sourceforge.mikutoga.pmd.Surface;
import jp.sourceforge.mikutoga.pmd.Vec3d;
import jp.sourceforge.mikutoga.pmd.Vertex;

class ShapeBuilder
implements PmdShapeHandler {
    private final List<Vertex> vertexList;
    private final List<BoneInfo> boneList;
    private final List<Surface> surfaceList;
    private Iterator<Vertex> vertexIt;
    private Vertex currentVertex = null;
    private Iterator<Surface> surfaceIt;
    private Surface currentSurface = null;

    ShapeBuilder(PmdModel model) {
        this.vertexList = model.getVertexList();
        this.boneList = model.getBoneList();
        this.surfaceList = model.getSurfaceList();
        assert (this.vertexList instanceof RandomAccess);
        assert (this.surfaceList instanceof RandomAccess);
        assert (this.boneList instanceof RandomAccess);
    }

    private BoneInfo prepareBone(int id) {
        ListUtil.extendCollection(this.boneList, id + 1);
        BoneInfo bone = this.boneList.get(id);
        if (bone == null) {
            bone = new BoneInfo();
            bone.setSerialNumber(id);
            this.boneList.set(id, bone);
        }
        return bone;
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        if (stage == PmdShapeHandler.VERTEX_LIST) {
            ListUtil.prepareDefConsList(this.vertexList, Vertex.class, loops);
            ListUtil.assignIndexedSerial(this.vertexList);
            this.vertexIt = this.vertexList.iterator();
            if (this.vertexIt.hasNext()) {
                this.currentVertex = this.vertexIt.next();
            }
        } else if (stage == PmdShapeHandler.SURFACE_LIST) {
            ListUtil.prepareDefConsList(this.surfaceList, Surface.class, loops);
            ListUtil.assignIndexedSerial(this.surfaceList);
            this.surfaceIt = this.surfaceList.iterator();
            if (this.surfaceIt.hasNext()) {
                this.currentSurface = this.surfaceIt.next();
            }
        } else {
            assert (false);
            throw new AssertionError();
        }
    }

    @Override
    public void loopNext(ParseStage stage) {
        if (stage == PmdShapeHandler.VERTEX_LIST) {
            if (this.vertexIt.hasNext()) {
                this.currentVertex = this.vertexIt.next();
            }
        } else if (stage == PmdShapeHandler.SURFACE_LIST) {
            if (this.surfaceIt.hasNext()) {
                this.currentSurface = this.surfaceIt.next();
            }
        } else {
            assert (false);
            throw new AssertionError();
        }
    }

    @Override
    public void loopEnd(ParseStage stage) {
    }

    @Override
    public void pmdVertexPosition(float xPos, float yPos, float zPos) {
        Pos3d position = this.currentVertex.getPosition();
        position.setXPos(xPos);
        position.setYPos(yPos);
        position.setZPos(zPos);
    }

    @Override
    public void pmdVertexNormal(float xVec, float yVec, float zVec) {
        Vec3d normal = this.currentVertex.getNormal();
        normal.setXVal(xVec);
        normal.setYVal(yVec);
        normal.setZVal(zVec);
    }

    @Override
    public void pmdVertexUV(float uVal, float vVal) {
        Pos2d uv = this.currentVertex.getUVPosition();
        uv.setXPos(uVal);
        uv.setYPos(vVal);
    }

    @Override
    public void pmdVertexWeight(int boneId1, int boneId2, int weightForB1) {
        BoneInfo bone1 = this.prepareBone(boneId1);
        BoneInfo bone2 = this.prepareBone(boneId2);
        this.currentVertex.setBonePair(bone1, bone2);
        this.currentVertex.setWeightA(weightForB1);
    }

    @Override
    public void pmdVertexEdge(boolean hideEdge) {
        this.currentVertex.setEdgeAppearance(!hideEdge);
    }

    @Override
    public void pmdSurfaceTriangle(int vertexId1, int vertexId2, int vertexId3) {
        Vertex vtx1 = this.vertexList.get(vertexId1);
        Vertex vtx2 = this.vertexList.get(vertexId2);
        Vertex vtx3 = this.vertexList.get(vertexId3);
        this.currentSurface.setTriangle(vtx1, vtx2, vtx3);
    }
}

