/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd2xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.pmdexporter.IllegalPmdException;
import jp.sourceforge.mikutoga.pmd.pmdexporter.PmdExporter;
import jp.sourceforge.mikutoga.pmd.pmdloader.PmdLoader;
import jp.sourceforge.mikutoga.pmd.xml.PmdXmlExporter;
import jp.sourceforge.mikutoga.pmd.xml.PmdXmlResources;
import jp.sourceforge.mikutoga.pmd.xml.Xml2PmdLoader;
import jp.sourceforge.mikutoga.pmd2xml.XmlHandler;
import jp.sourceforge.mikutoga.xml.TogaXmlException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Pmd2Xml {
    private static final Class THISCLASS = Pmd2Xml.class;
    private static final String APPNAME;
    private static final String APPVER;
    private static final String APPLICENSE;

    private Pmd2Xml() {
        assert (this.getClass().equals(THISCLASS));
    }

    public static void main(String[] args) {
        File oFile;
        File iFile;
        Pmd2Xml.checkJRE();
        String inputFile = null;
        String outputFile = null;
        boolean pmd2xml = false;
        boolean xml2pmd = false;
        boolean force = false;
        int argsLen = args.length;
        for (int argIdx = 0; argIdx < argsLen; ++argIdx) {
            String arg = args[argIdx];
            if (arg.equals("-h")) {
                Pmd2Xml.putHelp();
                continue;
            }
            if (arg.equals("-pmd2xml")) {
                pmd2xml = true;
                xml2pmd = false;
                continue;
            }
            if (arg.equals("-xml2pmd")) {
                pmd2xml = false;
                xml2pmd = true;
                continue;
            }
            if (arg.equals("-i")) {
                if (++argIdx >= argsLen) {
                    System.err.println("ERROR:");
                    System.err.println("You need -i argument.");
                    System.err.println("(-h for help)");
                    System.exit(5);
                }
                inputFile = args[argIdx];
                continue;
            }
            if (arg.equals("-o")) {
                if (++argIdx >= argsLen) {
                    System.err.println("ERROR:");
                    System.err.println("You need -o argument.");
                    System.err.println("(-h for help)");
                    System.exit(5);
                }
                outputFile = args[argIdx];
                continue;
            }
            if (arg.equals("-f")) {
                force = true;
                continue;
            }
            System.err.println("ERROR:");
            System.err.println("Unknown option:" + arg);
            System.err.println("(-h for help)");
            System.exit(5);
        }
        if (!pmd2xml && !xml2pmd) {
            System.err.println("ERROR:");
            System.err.println("You must specify -pmd2xml or -xml2pmd.");
            System.err.println("(-h for help)");
            System.exit(5);
        }
        if (inputFile == null) {
            System.err.println("ERROR:");
            System.err.println("You must specify input file with -i.");
            System.err.println("(-h for help)");
            System.exit(5);
        }
        if (outputFile == null) {
            System.err.println("ERROR:");
            System.err.println("You must specify output file with -o.");
            System.err.println("(-h for help)");
            System.exit(5);
        }
        if (!(iFile = new File(inputFile)).exists() || !iFile.isFile()) {
            System.err.println("ERROR:");
            System.err.println("Can't find input file:" + iFile.getAbsolutePath());
            System.err.println("(-h for help)");
            System.exit(1);
        }
        if (!force) {
            oFile = new File(outputFile);
            if (oFile.exists()) {
                System.err.println("ERROR:");
                System.err.println(oFile.getAbsolutePath() + " already exists.");
                System.err.println("If you want to overwrite, use -f.");
                System.err.println("(-h for help)");
                System.exit(1);
            }
        } else {
            oFile = new File(outputFile);
            if (oFile.exists() && !oFile.isFile()) {
                System.err.println("ERROR:");
                System.err.println(oFile.getAbsolutePath() + " is not file.");
                System.err.println("(-h for help)");
                System.exit(1);
            }
        }
        try {
            if (pmd2xml) {
                Pmd2Xml.pmd2xml(inputFile, outputFile);
            } else {
                Pmd2Xml.xml2pmd(inputFile, outputFile);
            }
        }
        catch (IOException e) {
            Pmd2Xml.ioError(e);
        }
        catch (ParserConfigurationException e) {
            Pmd2Xml.internalError(e);
        }
        catch (IllegalPmdException e) {
            Pmd2Xml.internalError(e);
        }
        catch (MmdFormatException e) {
            Pmd2Xml.pmdError(e);
        }
        catch (TogaXmlException e) {
            Pmd2Xml.xmlError(e);
        }
        catch (SAXException e) {
            Pmd2Xml.xmlError(e);
        }
        System.exit(0);
    }

    private static void ioError(Throwable ex) {
        System.err.println(ex);
        System.exit(1);
    }

    private static void xmlError(Throwable ex) {
        System.err.println(ex);
        System.exit(2);
    }

    private static void pmdError(Throwable ex) {
        System.err.println(ex);
        ex.printStackTrace(System.err);
        System.exit(3);
    }

    private static void internalError(Throwable ex) {
        System.err.println(ex);
        ex.printStackTrace(System.err);
        System.exit(4);
    }

    private static void checkJRE() {
        Package jrePackage = Object.class.getPackage();
        if (!jrePackage.isCompatibleWith("1.6")) {
            System.err.println("You need JRE 1.6 or later.");
            System.exit(4);
        }
    }

    private static void putHelp() {
        System.err.println(APPNAME + ' ' + APPVER);
        System.err.println("  License : " + APPLICENSE);
        System.err.println("  http://mikutoga.sourceforge.jp/");
        System.err.println();
        System.err.println("-h       : put help massage");
        System.err.println("-pmd2xml : convert *.pmd to *.xml");
        System.err.println("-xml2pmd : convert *.xml to *.pmd");
        System.err.println("-i file  : specify input file");
        System.err.println("-o file  : specify output file");
        System.err.println("-f       : force overwriting");
        System.exit(0);
    }

    private static void pmd2xml(String inputFile, String outputFile) throws IOException, MmdFormatException, IllegalPmdException {
        File iFile = new File(inputFile);
        InputStream is = new FileInputStream(iFile);
        is = new BufferedInputStream(is);
        PmdModel model = Pmd2Xml.pmdRead(is);
        is.close();
        File oFile = new File(outputFile);
        Pmd2Xml.trunc(oFile);
        OutputStream ostream = new FileOutputStream(oFile, false);
        ostream = new BufferedOutputStream(ostream);
        Pmd2Xml.xmlOut(model, ostream);
        ostream.close();
    }

    private static void xml2pmd(String inputFile, String outputFile) throws IOException, ParserConfigurationException, SAXException, TogaXmlException, IllegalPmdException {
        File iFile = new File(inputFile);
        InputStream is = new FileInputStream(iFile);
        is = new BufferedInputStream(is);
        InputSource source = new InputSource(is);
        PmdModel model = Pmd2Xml.xmlRead(source);
        is.close();
        File oFile = new File(outputFile);
        Pmd2Xml.trunc(oFile);
        OutputStream ostream = new FileOutputStream(oFile, false);
        ostream = new BufferedOutputStream(ostream);
        Pmd2Xml.pmdOut(model, ostream);
        ostream.close();
    }

    private static void trunc(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        FileOutputStream foStream = new FileOutputStream(file);
        FileChannel channnel = foStream.getChannel();
        channnel.truncate(0L);
        channnel.close();
        foStream.close();
    }

    private static PmdModel pmdRead(InputStream is) throws IOException, MmdFormatException {
        MmdSource source = new MmdSource(is);
        PmdLoader loader = new PmdLoader(source);
        PmdModel model = loader.load();
        return model;
    }

    private static PmdModel xmlRead(InputSource source) throws IOException, ParserConfigurationException, SAXException, TogaXmlException {
        DocumentBuilder builder = PmdXmlResources.newBuilder(XmlHandler.HANDLER);
        Xml2PmdLoader loader = new Xml2PmdLoader(builder);
        PmdModel model = loader.parse(source);
        return model;
    }

    private static void pmdOut(PmdModel model, OutputStream ostream) throws IOException, IllegalPmdException {
        PmdExporter exporter = new PmdExporter(ostream);
        exporter.dumpPmdModel(model);
        ostream.close();
    }

    private static void xmlOut(PmdModel model, OutputStream ostream) throws IOException, IllegalPmdException {
        PmdXmlExporter exporter = new PmdXmlExporter(ostream);
        exporter.setNewLine("\r\n");
        exporter.setGenerator(APPNAME + ' ' + APPVER);
        exporter.putPmdModel(model);
        exporter.close();
    }

    static {
        InputStream ver = THISCLASS.getResourceAsStream("resources/version.properties");
        Properties verProps = new Properties();
        try {
            verProps.load(ver);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        APPNAME = verProps.getProperty("app.name");
        APPVER = verProps.getProperty("app.version");
        APPLICENSE = verProps.getProperty("app.license");
        Pmd2Xml pmd2Xml = new Pmd2Xml();
    }
}

