/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.xml;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;

public class BasicXmlExporter {
    private static final Charset CS_UTF8 = Charset.forName("UTF-8");
    private static final String LF = "\n";
    private static final String DEFAULT_INDENT_UNIT = "  ";
    private static final char[] HEXCHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Appendable appendable;
    private String newline = "\n";
    private String indentUnit = "  ";
    private int indentNest = 0;
    private boolean basicLatinOnlyOut = true;

    public BasicXmlExporter(OutputStream stream) {
        this(stream, CS_UTF8);
    }

    public BasicXmlExporter(OutputStream stream, Charset charSet) {
        this(new BufferedWriter(new OutputStreamWriter(stream, charSet)));
    }

    public BasicXmlExporter(Appendable appendable) {
        this.appendable = appendable;
    }

    public static boolean isBasicLatin(char ch) {
        return ch <= '\u007f';
    }

    public void setNewLine(String newLine) throws NullPointerException {
        if (newLine == null) {
            throw new NullPointerException();
        }
        this.newline = newLine;
    }

    public void setBasicLatinOnlyOut(boolean bool) {
        this.basicLatinOnlyOut = bool;
    }

    public boolean isBasicLatinOnlyOut() {
        return this.basicLatinOnlyOut;
    }

    public void setNewLine(CharSequence seq) {
        this.newline = seq == null ? "" : ((Object)seq).toString();
    }

    public void setIndentUnit(CharSequence seq) {
        this.indentUnit = seq == null ? "" : ((Object)seq).toString();
    }

    public void flush() throws IOException {
        if (this.appendable instanceof Flushable) {
            ((Flushable)((Object)this.appendable)).flush();
        }
    }

    public void close() throws IOException {
        if (this.appendable instanceof Closeable) {
            ((Closeable)((Object)this.appendable)).close();
        }
    }

    public BasicXmlExporter put(char ch) throws IOException {
        this.appendable.append(ch);
        return this;
    }

    public BasicXmlExporter put(CharSequence seq) throws IOException {
        this.appendable.append(seq);
        return this;
    }

    public BasicXmlExporter put(int iVal) throws IOException {
        String value = DatatypeConverter.printInt((int)iVal);
        this.appendable.append(value);
        return this;
    }

    public BasicXmlExporter put(float fVal) throws IOException {
        String value = DatatypeConverter.printFloat((float)fVal);
        this.appendable.append(value);
        return this;
    }

    public BasicXmlExporter ln() throws IOException {
        this.appendable.append(this.newline);
        return this;
    }

    public BasicXmlExporter ln(int count) throws IOException {
        for (int ct = 1; ct <= count; ++ct) {
            this.appendable.append(this.newline);
        }
        return this;
    }

    public BasicXmlExporter ind() throws IOException {
        for (int ct = 1; ct <= this.indentNest; ++ct) {
            this.put(this.indentUnit);
        }
        return this;
    }

    public void pushNest() {
        ++this.indentNest;
    }

    public void popNest() {
        --this.indentNest;
        if (this.indentNest < 0) {
            this.indentNest = 0;
        }
    }

    public BasicXmlExporter putCharRef2Hex(char ch) throws IOException {
        if (ch > '\u00ff') {
            return this.putCharRef4Hex(ch);
        }
        char hex3 = HEXCHAR_TABLE[ch >> 4 & 0xF];
        char hex4 = HEXCHAR_TABLE[ch & 0xF];
        this.appendable.append("&#x");
        this.appendable.append(hex3);
        this.appendable.append(hex4);
        this.appendable.append(';');
        return this;
    }

    public BasicXmlExporter putCharRef4Hex(char ch) throws IOException {
        char hex1 = HEXCHAR_TABLE[ch >> 12 & 0xF];
        char hex2 = HEXCHAR_TABLE[ch >> 8 & 0xF];
        char hex3 = HEXCHAR_TABLE[ch >> 4 & 0xF];
        char hex4 = HEXCHAR_TABLE[ch & 0xF];
        this.appendable.append("&#x");
        this.appendable.append(hex1);
        this.appendable.append(hex2);
        this.appendable.append(hex3);
        this.appendable.append(hex4);
        this.appendable.append(';');
        return this;
    }

    public BasicXmlExporter putContent(CharSequence content) throws IOException {
        int length = content.length();
        block8: for (int pos = 0; pos < length; ++pos) {
            char ch = content.charAt(pos);
            if (Character.isISOControl(ch)) {
                this.putCharRef2Hex(ch);
                continue;
            }
            if (!BasicXmlExporter.isBasicLatin(ch) && this.isBasicLatinOnlyOut()) {
                this.putCharRef4Hex(ch);
                continue;
            }
            switch (ch) {
                case '&': {
                    this.appendable.append("&amp;");
                    continue block8;
                }
                case '<': {
                    this.appendable.append("&lt;");
                    continue block8;
                }
                case '>': {
                    this.appendable.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    this.appendable.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    this.appendable.append("&apos;");
                    continue block8;
                }
                case '\u00a5': {
                    this.appendable.append('\\');
                    continue block8;
                }
                default: {
                    this.appendable.append(ch);
                }
            }
        }
        return this;
    }

    public BasicXmlExporter putAttr(CharSequence attrName, CharSequence content) throws IOException {
        this.put(attrName).put('=').put('\"').putContent(content).put('\"');
        return this;
    }

    public BasicXmlExporter putIntAttr(CharSequence attrName, int iVal) throws IOException {
        this.put(attrName).put('=').put('\"').put(iVal).put('\"');
        return this;
    }

    public BasicXmlExporter putFloatAttr(CharSequence attrName, float fVal) throws IOException {
        this.put(attrName).put('=').put('\"').put(fVal).put('\"');
        return this;
    }

    public BasicXmlExporter putCommentContent(CharSequence comment) throws IOException {
        int length = comment.length();
        int prev = 0;
        for (int pos = 0; pos < length; ++pos) {
            char ch = comment.charAt(pos);
            if (ch == '\n') {
                this.ln();
                prev = ch;
                continue;
            }
            if (prev == 45 && ch == '-') {
                this.put(' ');
            }
            this.put(ch);
            prev = ch;
        }
        return this;
    }

    public BasicXmlExporter putLineComment(CharSequence comment) throws IOException {
        this.put("<!--").put(' ');
        this.putCommentContent(comment);
        this.put(' ').put("-->");
        return this;
    }

    public BasicXmlExporter putBlockComment(CharSequence comment) throws IOException {
        char lastCh;
        this.put("<!--").ln();
        this.putCommentContent(comment);
        int commentLength = comment.length();
        if (commentLength > 0 && (lastCh = comment.charAt(commentLength - 1)) != '\n') {
            this.ln();
        }
        this.put("-->").ln();
        return this;
    }

    static {
        assert (HEXCHAR_TABLE.length == 16);
    }
}

