/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlResourceResolver
implements LSResourceResolver,
EntityResolver {
    public static final String SCHEMA_XML = "http://www.w3.org/2001/xml.xsd";
    public static final String NS_XSD = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String LOCAL_SCHEMA_XML = "resources/xml-2009-01.xsd";
    private static final URI EMPTY_URI = URI.create("");
    private static final Class THISCLASS = XmlResourceResolver.class;
    private final Map<URI, URI> uriMap = new HashMap<URI, URI>();

    public XmlResourceResolver() {
        URI redirectURI;
        assert (this.getClass().equals(THISCLASS));
        URI originalURI = URI.create(SCHEMA_XML);
        URL redirectURL = THISCLASS.getResource(LOCAL_SCHEMA_XML);
        try {
            redirectURI = redirectURL.toURI();
        }
        catch (URISyntaxException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        this.uriMap.put(originalURI, redirectURI);
    }

    protected static URI buildBaseRelativeURI(String base, String relative) throws URISyntaxException, IllegalArgumentException {
        URI resultURI;
        URI baseURI = null;
        if (base != null && !(baseURI = new URI(base)).isAbsolute()) {
            throw new IllegalArgumentException();
        }
        URI relativeURI = EMPTY_URI;
        if (relative != null) {
            relativeURI = new URI(relative);
        }
        if (!(resultURI = baseURI == null || relativeURI.isAbsolute() ? relativeURI : baseURI.resolve(relativeURI)).isAbsolute()) {
            throw new IllegalArgumentException();
        }
        resultURI = resultURI.normalize();
        return resultURI;
    }

    public static LSInput createLSInput() {
        LSInputImpl input = new LSInputImpl();
        return input;
    }

    public void putURIMap(URI original, URI redirect) {
        this.uriMap.put(original.normalize(), redirect.normalize());
    }

    public InputStream getXMLResourceAsStream(URI originalURI) throws IOException {
        URI resourceURI = this.uriMap.get(originalURI.normalize());
        URL resourceURL = resourceURI.toURL();
        InputStream is = resourceURL.openStream();
        return is;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputStream is;
        URI originalURI;
        if (systemId == null) {
            return null;
        }
        try {
            originalURI = XmlResourceResolver.buildBaseRelativeURI(baseURI, systemId);
        }
        catch (URISyntaxException e) {
            return null;
        }
        try {
            is = this.getXMLResourceAsStream(originalURI);
        }
        catch (IOException e) {
            return null;
        }
        LSInput input = XmlResourceResolver.createLSInput();
        input.setBaseURI(baseURI);
        input.setPublicId(publicId);
        input.setSystemId(systemId);
        input.setByteStream(is);
        return input;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URI originalUri;
        if (systemId == null) {
            return null;
        }
        try {
            originalUri = new URI(systemId);
        }
        catch (URISyntaxException e) {
            return null;
        }
        InputStream is = this.getXMLResourceAsStream(originalUri);
        InputSource source = new InputSource(is);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    private static final class LSInputImpl
    implements LSInput {
        private String baseURI = null;
        private InputStream byteStream = null;
        private boolean certifiedText = false;
        private Reader characterStream = null;
        private String encoding = null;
        private String publicId = null;
        private String stringData = null;
        private String systemId = null;

        private LSInputImpl() {
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
            this.baseURI = baseURI;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.byteStream = byteStream;
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            this.certifiedText = certifiedText;
        }

        @Override
        public Reader getCharacterStream() {
            return this.characterStream;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.characterStream = characterStream;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }
}

