/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.corelib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class I18nText
implements CharSequence {
    public static final Locale LOCALE_PRIMARY = Locale.JAPANESE;
    public static final String CODE639_PRIMARY = LOCALE_PRIMARY.getLanguage();
    public static final Locale LOCALE_GLOBAL = Locale.ENGLISH;
    public static final String CODE639_GLOBAL = LOCALE_GLOBAL.getLanguage();
    private final Map<String, String> nameMap = new HashMap<String, String>();

    public void setPrimaryText(CharSequence seq) {
        this.setText(CODE639_PRIMARY, seq);
    }

    public void setGlobalText(CharSequence seq) {
        this.setText(CODE639_GLOBAL, seq);
    }

    public void setText(Locale locale, CharSequence seq) throws NullPointerException {
        String code639 = locale.getLanguage();
        this.setText(code639, seq);
    }

    public void setText(String code639, CharSequence seq) throws NullPointerException {
        if (code639 == null) {
            throw new NullPointerException();
        }
        if (seq != null) {
            String text = ((Object)seq).toString();
            this.nameMap.put(code639, text);
        } else {
            this.nameMap.remove(code639);
        }
    }

    public String getText(String code639) throws NullPointerException {
        if (code639 == null) {
            throw new NullPointerException();
        }
        String result = this.nameMap.get(code639);
        return result;
    }

    public String getText(Locale locale) throws NullPointerException {
        String code639 = locale.getLanguage();
        String result = this.getText(code639);
        return result;
    }

    public String getPrimaryText() {
        String result = this.getText(CODE639_PRIMARY);
        return result;
    }

    public String getGlobalText() {
        String result = this.getText(CODE639_GLOBAL);
        return result;
    }

    public String getText() {
        String result = this.getPrimaryText();
        if (result == null) {
            result = this.getGlobalText();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String getLocalizedText() {
        Locale locale = Locale.getDefault();
        String langCode = locale.getLanguage();
        String result = this.nameMap.get(langCode);
        if (result == null) {
            result = this.nameMap.get(CODE639_GLOBAL);
        }
        if (result == null) {
            result = this.nameMap.get(CODE639_PRIMARY);
        }
        if (result == null) {
            String lang;
            Set<String> langSet = this.nameMap.keySet();
            Iterator<String> it = langSet.iterator();
            while (it.hasNext() && (result = this.nameMap.get(lang = it.next())) == null) {
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void removeAllText() {
        this.nameMap.clear();
    }

    public List<String> lang639CodeList() {
        Set<String> set = this.nameMap.keySet();
        ArrayList<String> result = new ArrayList<String>(set.size());
        for (String lang : set) {
            if (!lang.equals(CODE639_PRIMARY)) continue;
            result.add(lang);
        }
        for (String lang : set) {
            if (!lang.equals(CODE639_GLOBAL)) continue;
            result.add(lang);
        }
        for (String lang : set) {
            if (lang.equals(CODE639_PRIMARY) || lang.equals(CODE639_GLOBAL)) continue;
            result.add(lang);
        }
        return result;
    }

    public boolean hasPrimaryText() {
        boolean result = this.nameMap.containsKey(CODE639_PRIMARY);
        return result;
    }

    public boolean hasGlobalText() {
        boolean result = this.nameMap.containsKey(CODE639_GLOBAL);
        return result;
    }

    @Override
    public char charAt(int index) {
        String text = this.getText();
        char result = text.charAt(index);
        return result;
    }

    @Override
    public int length() {
        String text = this.getText();
        int result = text.length();
        return result;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        String text = this.getText();
        CharSequence result = text.subSequence(start, end);
        return result;
    }

    @Override
    public String toString() {
        return this.getText();
    }

    static {
        assert (CODE639_PRIMARY.equals("ja"));
        assert (CODE639_GLOBAL.equals("en"));
    }
}

