/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import jp.sourceforge.mikutoga.parser.MmdEofException;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;

public class CommonParser {
    public static final int TEXTBUF_SZ = 512;
    protected static final Charset CS_WIN31J = Charset.forName("windows-31j");
    private static final byte TERMINATOR = 0;
    private static final char UCSYEN = '\u00a5';
    private static final char SJISYEN = '\\';
    private final MmdSource source;
    private final CharsetDecoder decoder;
    private final byte[] textArray;
    private final ByteBuffer textBuffer;
    private final CharBuffer charBuffer;

    public CommonParser(MmdSource source) {
        this.source = source;
        this.decoder = CS_WIN31J.newDecoder();
        this.textArray = new byte[512];
        this.textBuffer = ByteBuffer.wrap(this.textArray);
        int maxChars = (int)(512.0f * this.decoder.maxCharsPerByte()) + 1;
        this.charBuffer = CharBuffer.allocate(maxChars);
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.textBuffer.clear();
        this.charBuffer.clear();
    }

    protected boolean hasMore() throws IOException {
        boolean result = this.source.hasMore();
        return result;
    }

    protected void skip(long skipLength) throws IOException, MmdEofException {
        long result = this.source.skip(skipLength);
        if (result != skipLength) {
            throw new MmdEofException(this.source.getPosition());
        }
    }

    protected void skip(int skipLength) throws IOException, MmdEofException {
        this.skip((long)skipLength);
    }

    protected byte parseByte() throws IOException, MmdEofException {
        return this.source.parseByte();
    }

    protected int parseUByteAsInteger() throws IOException, MmdEofException {
        return this.source.parseUByteAsInteger();
    }

    protected boolean parseBoolean() throws IOException, MmdEofException {
        return this.source.parseBoolean();
    }

    protected short parseShort() throws IOException, MmdEofException {
        return this.source.parseShort();
    }

    protected int parseUShortAsInteger() throws IOException, MmdEofException {
        return this.source.parseUShortAsInteger();
    }

    protected int parseInteger() throws IOException, MmdEofException {
        return this.source.parseInteger();
    }

    protected float parseFloat() throws IOException, MmdEofException {
        return this.source.parseFloat();
    }

    protected void parseByteArray(byte[] dst, int offset, int length) throws IOException, NullPointerException, IndexOutOfBoundsException, MmdEofException {
        this.source.parseByteArray(dst, offset, length);
    }

    protected void parseByteArray(byte[] dst) throws IOException, NullPointerException, MmdEofException {
        this.source.parseByteArray(dst);
    }

    protected void parseFloatArray(float[] dst, int offset, int length) throws IOException, NullPointerException, IndexOutOfBoundsException, MmdEofException {
        this.source.parseFloatArray(dst, offset, length);
    }

    protected void parseFloatArray(float[] dst) throws IOException, NullPointerException, MmdEofException {
        this.source.parseFloatArray(dst);
    }

    protected String parseZeroTermString(int maxlen) throws IOException, IllegalArgumentException, MmdEofException, MmdFormatException {
        if (this.textArray.length < maxlen || maxlen < 0) {
            throw new IllegalArgumentException();
        }
        this.source.parseByteArray(this.textArray, 0, maxlen);
        int length = -1;
        for (int pos = 0; pos < maxlen; ++pos) {
            byte ch = this.textArray[pos];
            if (ch != 0) continue;
            length = pos;
            break;
        }
        if (length < 0) {
            length = maxlen;
        }
        this.textBuffer.rewind();
        this.textBuffer.limit(length);
        this.charBuffer.clear();
        CoderResult decResult = this.decoder.decode(this.textBuffer, this.charBuffer, true);
        if (!decResult.isUnderflow() || decResult.isError()) {
            throw new MmdFormatException("illegal character encoding", this.source.getPosition());
        }
        this.charBuffer.flip();
        String result = this.charBuffer.toString();
        if (result.indexOf(165) >= 0) {
            result = result.replace('\u00a5', '\\');
        }
        return result;
    }
}

