/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdexporter;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.mikutoga.corelib.SerialNumbered;
import jp.sourceforge.mikutoga.pmd.BoneGroup;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.BoneType;
import jp.sourceforge.mikutoga.pmd.IKChain;
import jp.sourceforge.mikutoga.pmd.Material;
import jp.sourceforge.mikutoga.pmd.MorphPart;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.pmd.MorphVertex;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.Pos2d;
import jp.sourceforge.mikutoga.pmd.Pos3d;
import jp.sourceforge.mikutoga.pmd.ShadeInfo;
import jp.sourceforge.mikutoga.pmd.Surface;
import jp.sourceforge.mikutoga.pmd.Vec3d;
import jp.sourceforge.mikutoga.pmd.Vertex;
import jp.sourceforge.mikutoga.pmd.pmdexporter.AbstractExporter;
import jp.sourceforge.mikutoga.pmd.pmdexporter.IllegalPmdException;
import jp.sourceforge.mikutoga.pmd.pmdexporter.IllegalPmdTextException;

public class PmdExporterBase
extends AbstractExporter {
    public static final int NOPREVBONE_ID = 65535;
    public static final int NONEXTBONE_ID = 0;
    public static final int NOIKBONE_ID = 0;
    private static final String MAGIC = "Pmd";
    private static final byte[] NULLFILLER = new byte[]{0};
    private static final byte[] FDFILLER = new byte[]{0, -3};
    private static final byte[] LFFILLER = new byte[]{10, 0, -3};
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";

    public PmdExporterBase(OutputStream stream) throws NullPointerException {
        super(stream);
    }

    protected static String normalizeBreak(String text) {
        String result = text;
        result = result.replace(CRLF, LF);
        result = result.replace(CR, LF);
        return result;
    }

    protected void dumpText(String text, int maxByteLength) throws IOException, IllegalPmdTextException {
        this.dumpText(text, maxByteLength, FDFILLER);
    }

    protected void dumpText(String text, int maxByteLength, byte[] filler) throws IOException, IllegalPmdTextException {
        String normalized = PmdExporterBase.normalizeBreak(text);
        int blen = this.dumpCharSequence(normalized);
        int remain = maxByteLength - blen;
        if (remain < 0) {
            throw new IllegalPmdTextException("too long text");
        }
        int fillerIdx = 0;
        while (remain > 0) {
            if (fillerIdx >= filler.length) {
                fillerIdx = filler.length - 1;
            }
            this.dumpByte(filler[fillerIdx]);
            ++fillerIdx;
            --remain;
        }
    }

    public void dumpPmdModel(PmdModel model) throws IOException, IllegalPmdException {
        this.dumpBasic(model);
        this.dumpVertexList(model);
        this.dumpSurfaceList(model);
        this.dumpMaterialList(model);
        this.dumpBoneList(model);
        this.dumpIKChainList(model);
        this.dumpMorphList(model);
        this.dumpMorphGroup(model);
        this.dumpBoneGroupList(model);
    }

    private void dumpBasic(PmdModel model) throws IOException, IllegalPmdTextException {
        this.dumpCharSequence(MAGIC);
        float ver = model.getHeaderVersion();
        this.dumpFloat(ver);
        String modelName = model.getModelName().getPrimaryText();
        String description = model.getDescription().getPrimaryText();
        this.dumpText(modelName, 20);
        this.dumpText(description, 256);
        this.flush();
    }

    private void dumpVertexList(PmdModel model) throws IOException {
        List<Vertex> vList = model.getVertexList();
        int vertexNum = vList.size();
        this.dumpInt(vertexNum);
        for (Vertex vertex : vList) {
            this.dumpVertex(vertex);
        }
        this.flush();
    }

    private void dumpVertex(Vertex vertex) throws IOException {
        Pos3d position = vertex.getPosition();
        this.dumpPos3d(position);
        Vec3d normal = vertex.getNormal();
        this.dumpVec3d(normal);
        Pos2d uv = vertex.getUVPosition();
        this.dumpPos2d(uv);
        BoneInfo boneA = vertex.getBoneA();
        BoneInfo boneB = vertex.getBoneB();
        this.dumpSerialIdAsShort(boneA);
        this.dumpSerialIdAsShort(boneB);
        int weight = vertex.getWeightA();
        this.dumpByte((byte)weight);
        boolean hasEdge = vertex.getEdgeAppearance();
        byte edgeFlag = hasEdge ? (byte)0 : 1;
        this.dumpByte(edgeFlag);
    }

    private void dumpSurfaceList(PmdModel model) throws IOException {
        int surfaceNum = 0;
        List<Material> materialList = model.getMaterialList();
        for (Material material : materialList) {
            surfaceNum += material.getSurfaceList().size();
        }
        this.dumpInt(surfaceNum * 3);
        Vertex[] triangle = new Vertex[3];
        for (Material material : materialList) {
            for (Surface surface : material) {
                surface.getTriangle(triangle);
                this.dumpShort(triangle[0].getSerialNumber());
                this.dumpShort(triangle[1].getSerialNumber());
                this.dumpShort(triangle[2].getSerialNumber());
            }
        }
        this.flush();
    }

    private void dumpMaterialList(PmdModel model) throws IOException, IllegalPmdTextException {
        List<Material> materialList = model.getMaterialList();
        int materialNum = materialList.size();
        this.dumpInt(materialNum);
        float[] rgba = new float[4];
        for (Material material : materialList) {
            Color diffuse = material.getDiffuseColor();
            diffuse.getRGBComponents(rgba);
            this.dumpFloat(rgba[0]);
            this.dumpFloat(rgba[1]);
            this.dumpFloat(rgba[2]);
            this.dumpFloat(rgba[3]);
            float shininess = material.getShininess();
            this.dumpFloat(shininess);
            Color specular = material.getSpecularColor();
            specular.getRGBComponents(rgba);
            this.dumpFloat(rgba[0]);
            this.dumpFloat(rgba[1]);
            this.dumpFloat(rgba[2]);
            Color ambient = material.getAmbientColor();
            ambient.getRGBComponents(rgba);
            this.dumpFloat(rgba[0]);
            this.dumpFloat(rgba[1]);
            this.dumpFloat(rgba[2]);
            ShadeInfo shade = material.getShadeInfo();
            int toonIdx = shade.getToonIndex();
            this.dumpByte(toonIdx);
            boolean showEdge = material.getEdgeAppearance();
            byte edgeFlag = showEdge ? (byte)1 : 0;
            this.dumpByte(edgeFlag);
            int surfaceNum = material.getSurfaceList().size();
            this.dumpInt(surfaceNum * 3);
            this.dumpShadeFileInfo(shade);
        }
        this.flush();
    }

    private void dumpShadeFileInfo(ShadeInfo shade) throws IOException, IllegalPmdTextException {
        String textureFile = shade.getTextureFileName();
        String spheremapFile = shade.getSpheremapFileName();
        StringBuilder text = new StringBuilder();
        if (textureFile != null) {
            text.append(textureFile);
        }
        if (spheremapFile != null && spheremapFile.length() > 0) {
            text.append('*').append(spheremapFile);
        }
        byte[] filler = text.length() <= 0 ? NULLFILLER : FDFILLER;
        this.dumpText(text.toString(), 20, filler);
    }

    private void dumpBoneList(PmdModel model) throws IOException, IllegalPmdTextException {
        List<BoneInfo> boneList = model.getBoneList();
        int boneNum = boneList.size();
        this.dumpShort(boneNum);
        for (BoneInfo bone : boneList) {
            this.dumpBone(bone);
        }
        this.flush();
    }

    private void dumpBone(BoneInfo bone) throws IOException, IllegalPmdTextException {
        String boneName = bone.getBoneName().getPrimaryText();
        this.dumpText(boneName, 20);
        BoneInfo prev = bone.getPrevBone();
        if (prev != null) {
            this.dumpSerialIdAsShort(prev);
        } else {
            this.dumpShort(65535);
        }
        BoneInfo next = bone.getNextBone();
        if (next != null) {
            this.dumpSerialIdAsShort(next);
        } else {
            this.dumpShort(0);
        }
        BoneType type = bone.getBoneType();
        this.dumpByte(type.encode());
        if (type == BoneType.LINKEDROT) {
            int ratio = bone.getRotationRatio();
            this.dumpShort(ratio);
        } else {
            BoneInfo ik = bone.getIKBone();
            if (ik != null) {
                this.dumpSerialIdAsShort(ik);
            } else {
                this.dumpShort(0);
            }
        }
        Pos3d position = bone.getPosition();
        this.dumpPos3d(position);
    }

    private void dumpIKChainList(PmdModel model) throws IOException {
        List<IKChain> ikChainList = model.getIKChainList();
        int ikNum = ikChainList.size();
        this.dumpShort(ikNum);
        for (IKChain chain : ikChainList) {
            this.dumpIKChain(chain);
        }
        this.flush();
    }

    private void dumpIKChain(IKChain chain) throws IOException {
        BoneInfo ikBone = chain.getIkBone();
        this.dumpSerialIdAsShort(ikBone);
        List<BoneInfo> boneList = chain.getChainedBoneList();
        BoneInfo bone1st = boneList.get(0);
        this.dumpSerialIdAsShort(bone1st);
        int boneNum = boneList.size();
        this.dumpByte(boneNum - 1);
        int depth = chain.getIKDepth();
        float weight = chain.getIKWeight();
        this.dumpShort(depth);
        this.dumpFloat(weight);
        for (int idx = 1; idx < boneNum; ++idx) {
            BoneInfo bone = boneList.get(idx);
            this.dumpSerialIdAsShort(bone);
        }
    }

    private void dumpMorphList(PmdModel model) throws IOException, IllegalPmdTextException {
        Map<MorphType, List<MorphPart>> morphMap = model.getMorphMap();
        Set<MorphType> typeSet = morphMap.keySet();
        List<MorphVertex> mergedMorphVertexList = model.mergeMorphVertex();
        int totalMorphPart = 0;
        for (MorphType type : typeSet) {
            List<MorphPart> partList = morphMap.get((Object)type);
            if (partList == null) continue;
            totalMorphPart += partList.size();
        }
        if (totalMorphPart <= 0) {
            this.dumpShort(0);
            return;
        }
        this.dumpShort(++totalMorphPart);
        this.dumpText("base", 20);
        int totalVertex = mergedMorphVertexList.size();
        this.dumpInt(totalVertex);
        this.dumpByte(MorphType.BASE.encode());
        for (MorphVertex morphVertex : mergedMorphVertexList) {
            Vertex baseVertex = morphVertex.getBaseVertex();
            this.dumpInt(baseVertex.getSerialNumber());
            this.dumpPos3d(baseVertex.getPosition());
        }
        for (MorphType type : typeSet) {
            List<MorphPart> partList = morphMap.get((Object)type);
            if (partList == null) continue;
            for (MorphPart part : partList) {
                this.dumpText(part.getMorphName().getPrimaryText(), 20);
                List<MorphVertex> morphVertexList = part.getMorphVertexList();
                this.dumpInt(morphVertexList.size());
                this.dumpByte(part.getMorphType().encode());
                for (MorphVertex morphVertex : morphVertexList) {
                    this.dumpInt(morphVertex.getSerialNumber());
                    this.dumpPos3d(morphVertex.getOffset());
                }
            }
        }
        this.flush();
    }

    private void dumpMorphGroup(PmdModel model) throws IOException {
        Map<MorphType, List<MorphPart>> morphMap = model.getMorphMap();
        Set<MorphType> typeSet = morphMap.keySet();
        int totalMorph = 0;
        for (MorphType type : typeSet) {
            List<MorphPart> partList = morphMap.get((Object)type);
            if (partList == null) continue;
            totalMorph += partList.size();
        }
        this.dumpByte(totalMorph);
        LinkedList<MorphType> typeList = new LinkedList<MorphType>();
        for (MorphType type : typeSet) {
            assert (!type.isBase());
            typeList.add(type);
        }
        Collections.reverse(typeList);
        for (MorphType type : typeList) {
            List<MorphPart> partList = morphMap.get((Object)type);
            if (partList == null) continue;
            for (MorphPart part : partList) {
                this.dumpSerialIdAsShort(part);
            }
        }
        this.flush();
    }

    private void dumpBoneGroupList(PmdModel model) throws IOException, IllegalPmdTextException {
        List<BoneGroup> groupList = model.getBoneGroupList();
        int groupNum = groupList.size();
        this.dumpByte(groupNum - 1);
        int dispBoneNum = 0;
        for (BoneGroup group : groupList) {
            if (group.isDefaultBoneGroup()) continue;
            this.dumpText(group.getGroupName().getPrimaryText(), 50, LFFILLER);
            dispBoneNum += group.getBoneList().size();
        }
        this.dumpInt(dispBoneNum);
        for (BoneGroup group : groupList) {
            if (group.isDefaultBoneGroup()) continue;
            for (BoneInfo bone : group) {
                this.dumpSerialIdAsShort(bone);
                int groupId = group.getSerialNumber();
                this.dumpByte(groupId);
            }
        }
        this.flush();
    }

    protected void dumpSerialIdAsShort(SerialNumbered obj) throws IOException {
        int serialId = obj.getSerialNumber();
        this.dumpShort(serialId);
    }

    protected void dumpPos2d(Pos2d position) throws IOException {
        float xPos = position.getXPos();
        float yPos = position.getYPos();
        this.dumpFloat(xPos);
        this.dumpFloat(yPos);
    }

    protected void dumpPos3d(Pos3d position) throws IOException {
        float xPos = position.getXPos();
        float yPos = position.getYPos();
        float zPos = position.getZPos();
        this.dumpFloat(xPos);
        this.dumpFloat(yPos);
        this.dumpFloat(zPos);
    }

    protected void dumpVec3d(Vec3d vector) throws IOException {
        float xVal = vector.getXVal();
        float yVal = vector.getYVal();
        float zVal = vector.getZVal();
        this.dumpFloat(xVal);
        this.dumpFloat(yVal);
        this.dumpFloat(zVal);
    }
}

