/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.pmdexporter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jp.sourceforge.mikutoga.pmd.BoneGroup;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.MorphPart;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.pmdexporter.IllegalPmdException;
import jp.sourceforge.mikutoga.pmd.pmdexporter.IllegalPmdTextException;
import jp.sourceforge.mikutoga.pmd.pmdexporter.PmdExporterBase;

public class PmdExporterExt1
extends PmdExporterBase {
    public PmdExporterExt1(OutputStream stream) throws NullPointerException {
        super(stream);
    }

    @Override
    public void dumpPmdModel(PmdModel model) throws IOException, IllegalPmdException {
        super.dumpPmdModel(model);
        this.dumpGlobalInfo(model);
    }

    private void dumpGlobalInfo(PmdModel model) throws IOException, IllegalPmdTextException {
        boolean hasGlobal = model.hasGlobalText();
        byte globalFlag = hasGlobal ? (byte)1 : 0;
        this.dumpByte(globalFlag);
        if (hasGlobal) {
            this.dumpBasicGlobal(model);
            this.dumpBoneGlobal(model);
            this.dumpMorphGlobal(model);
            this.dumpBoneGroupGlobal(model);
        }
        this.flush();
    }

    private void dumpBasicGlobal(PmdModel model) throws IOException, IllegalPmdTextException {
        String modelName = model.getModelName().getGlobalText();
        if (modelName == null) {
            modelName = "";
        }
        this.dumpText(modelName, 20);
        String description = model.getDescription().getGlobalText();
        if (description == null) {
            description = "";
        }
        this.dumpText(description, 256);
        this.flush();
    }

    private void dumpBoneGlobal(PmdModel model) throws IOException, IllegalPmdTextException {
        for (BoneInfo bone : model.getBoneList()) {
            String boneName = bone.getBoneName().getGlobalText();
            if (boneName == null) {
                boneName = "";
            }
            this.dumpText(boneName, 20);
        }
        this.flush();
    }

    private void dumpMorphGlobal(PmdModel model) throws IOException, IllegalPmdTextException {
        Map<MorphType, List<MorphPart>> morphMap = model.getMorphMap();
        for (MorphType type : MorphType.values()) {
            List<MorphPart> partList;
            if (type.isBase() || (partList = morphMap.get((Object)type)) == null) continue;
            for (MorphPart part : partList) {
                String morphName = part.getMorphName().getGlobalText();
                if (morphName == null) {
                    morphName = "";
                }
                this.dumpText(morphName, 20);
            }
        }
        this.flush();
    }

    private void dumpBoneGroupGlobal(PmdModel model) throws IOException, IllegalPmdTextException {
        for (BoneGroup group : model.getBoneGroupList()) {
            if (group.isDefaultBoneGroup()) continue;
            String groupName = group.getGroupName().getGlobalText();
            if (groupName == null) {
                groupName = "";
            }
            this.dumpText(groupName, 50);
        }
        this.flush();
    }
}

