/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.xml;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.corelib.SerialNumbered;
import jp.sourceforge.mikutoga.pmd.BoneGroup;
import jp.sourceforge.mikutoga.pmd.BoneInfo;
import jp.sourceforge.mikutoga.pmd.BoneType;
import jp.sourceforge.mikutoga.pmd.Deg3d;
import jp.sourceforge.mikutoga.pmd.DynamicsInfo;
import jp.sourceforge.mikutoga.pmd.IKChain;
import jp.sourceforge.mikutoga.pmd.JointInfo;
import jp.sourceforge.mikutoga.pmd.Material;
import jp.sourceforge.mikutoga.pmd.MorphPart;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.pmd.MorphVertex;
import jp.sourceforge.mikutoga.pmd.PmdModel;
import jp.sourceforge.mikutoga.pmd.Pos2d;
import jp.sourceforge.mikutoga.pmd.Pos3d;
import jp.sourceforge.mikutoga.pmd.Rad3d;
import jp.sourceforge.mikutoga.pmd.RigidGroup;
import jp.sourceforge.mikutoga.pmd.RigidInfo;
import jp.sourceforge.mikutoga.pmd.RigidShape;
import jp.sourceforge.mikutoga.pmd.RigidShapeType;
import jp.sourceforge.mikutoga.pmd.ShadeInfo;
import jp.sourceforge.mikutoga.pmd.Surface;
import jp.sourceforge.mikutoga.pmd.ToonMap;
import jp.sourceforge.mikutoga.pmd.TripletRange;
import jp.sourceforge.mikutoga.pmd.Vec3d;
import jp.sourceforge.mikutoga.pmd.Vertex;
import jp.sourceforge.mikutoga.xml.BasicXmlExporter;

public class PmdXmlExporter
extends BasicXmlExporter {
    private static final String TOP_COMMENT = "  MikuMikuDance\n    model-data(*.pmd) on XML";
    private static final String SCHEMA_LOCATION = "http://mikutoga.sourceforge.jp/xml/ns/pmdxml/101009 http://mikutoga.sourceforge.jp/xml/xsd/pmdxml-101009.xsd";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    private static final String PFX_SURFACEGROUP = "sg";
    private static final String PFX_TOONFILE = "tf";
    private static final String PFX_VERTEX = "vtx";
    private static final String PFX_BONE = "bn";
    private static final String PFX_RIGID = "rd";
    private static final String PFX_RIGIDGROUP = "rg";
    private static final String BONETYPE_COMMENT = "Bone types:\n[0 : ROTATE      : Rotate       : \u56de\u8ee2           :]\n[1 : ROTMOV      : Rotate/Move  : \u56de\u8ee2/\u79fb\u52d5      :]\n[2 : IK          : IK           : IK             :]\n[3 : UNKNOWN     : Unknown      : \u4e0d\u660e           :]\n[4 : UNDERIK     : Under IK     : IK\u5f71\u97ff\u4e0b(\u56de\u8ee2) :]\n[5 : UNDERROT    : Under rotate : \u56de\u8ee2\u5f71\u97ff\u4e0b     :]\n[6 : IKCONNECTED : IK connected : IK\u63a5\u7d9a\u5148       :]\n[7 : HIDDEN      : Hidden       : \u975e\u8868\u793a         :]\n[8 : TWIST       : Twist        : \u6369\u308a           :]\n[9 : LINKEDROT   : Linked Rotate: \u56de\u8ee2\u9023\u52d5       :]\n";
    private static final String MORPHTYPE_COMMENT = "Morph types:\n[1 : EYEBROW : \u307e\u3086   ]\n[2 : EYE     : \u76ee     ]\n[3 : LIP     : \u30ea\u30c3\u30d7 ]\n[4 : EXTRA   : \u305d\u306e\u4ed6 ]\n";
    private static final String RIGIDBEHAVIOR_COMMENT = "Rigid behavior types:\n[0 : FOLLOWBONE    : \u30dc\u30fc\u30f3\u8ffd\u5f93       ]\n[1 : ONLYDYNAMICS  : \u7269\u7406\u6f14\u7b97         ]\n[2 : BONEDDYNAMICS : \u30dc\u30fc\u30f3\u4f4d\u7f6e\u5408\u308f\u305b ]\n";
    private String generator = "";

    public PmdXmlExporter(OutputStream stream) {
        super(stream);
    }

    public void setGenerator(String generatorArg) throws NullPointerException {
        if (generatorArg == null) {
            throw new NullPointerException();
        }
        this.generator = generatorArg;
    }

    public static boolean hasOnlyBasicLatin(CharSequence seq) {
        if (seq == null) {
            return true;
        }
        int length = seq.length();
        for (int pos = 0; pos < length; ++pos) {
            char ch = seq.charAt(pos);
            if (ch <= '\u007f') continue;
            return false;
        }
        return true;
    }

    @Override
    public PmdXmlExporter ind() throws IOException {
        super.ind();
        return this;
    }

    protected PmdXmlExporter putUnescapedComment(CharSequence seq) throws IOException {
        if (!this.isBasicLatinOnlyOut()) {
            return this;
        }
        if (PmdXmlExporter.hasOnlyBasicLatin(seq)) {
            return this;
        }
        this.put(' ').putLineComment(seq);
        return this;
    }

    protected PmdXmlExporter putI18nName(I18nText text) throws IOException {
        for (String lang639 : text.lang639CodeList()) {
            if (lang639.equals(I18nText.CODE639_PRIMARY)) continue;
            String name = text.getText(lang639);
            this.ind().put("<i18nName ");
            this.putAttr("lang", lang639).put(' ');
            this.putAttr("name", name);
            this.put(" />");
            this.putUnescapedComment(name);
            this.ln();
        }
        return this;
    }

    protected PmdXmlExporter putNumberedIdAttr(CharSequence attrName, CharSequence prefix, int num) throws IOException {
        this.put(attrName).put("=\"");
        this.put(prefix).put(num);
        this.put('\"');
        return this;
    }

    protected PmdXmlExporter putNumberedIdAttr(CharSequence attrName, CharSequence prefix, SerialNumbered numbered) throws IOException {
        this.putNumberedIdAttr(attrName, prefix, numbered.getSerialNumber());
        return this;
    }

    protected PmdXmlExporter putPosition(Pos3d position) throws IOException {
        this.put("<position ");
        this.putFloatAttr("x", position.getXPos()).put(' ');
        this.putFloatAttr("y", position.getYPos()).put(' ');
        this.putFloatAttr("z", position.getZPos()).put(' ');
        this.put("/>");
        return this;
    }

    protected PmdXmlExporter putRadRotation(Rad3d rotation) throws IOException {
        this.put("<radRotation ");
        this.putFloatAttr("xRad", rotation.getXRad()).put(' ');
        this.putFloatAttr("yRad", rotation.getYRad()).put(' ');
        this.putFloatAttr("zRad", rotation.getZRad()).put(' ');
        this.put("/>");
        return this;
    }

    protected PmdXmlExporter putLocalNameComment(I18nText name) throws IOException {
        String localName = name.getText();
        this.ind().putLineComment(localName);
        return this;
    }

    protected PmdXmlExporter putPrimaryNameAttr(CharSequence attrName, I18nText name) throws IOException {
        String primaryName = name.getPrimaryText();
        this.putAttr(attrName, primaryName);
        return this;
    }

    public void putPmdModel(PmdModel model) throws IOException {
        this.ind().put("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>").ln(2);
        this.ind().putBlockComment(TOP_COMMENT).ln(2);
        I18nText modelName = model.getModelName();
        this.ind().putLocalNameComment(modelName).ln();
        this.ind().put("<pmdModel").ln();
        this.pushNest();
        this.ind().putAttr("xmlns", "http://mikutoga.sourceforge.jp/xml/ns/pmdxml/101009").ln();
        this.ind().putAttr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").ln();
        this.ind().putAttr("xsi:schemaLocation", SCHEMA_LOCATION).ln();
        this.ind().putAttr("schemaVersion", "101009").ln(2);
        this.ind().putPrimaryNameAttr("name", modelName).ln();
        this.popNest();
        this.put(">").ln(2);
        this.putModelInfo(model).flush();
        this.putMetaInfo(model).flush();
        this.putMaterialList(model).flush();
        this.putToonMap(model).flush();
        this.putBoneList(model).flush();
        this.putBoneGroupList(model).flush();
        this.putIKChainList(model).flush();
        this.putMorphList(model).flush();
        this.putRigidList(model).flush();
        this.putRigidGroupList(model).flush();
        this.putJointList(model).flush();
        this.putSurfaceGroupList(model).flush();
        this.putVertexList(model).flush();
        this.ind().put("</pmdModel>").ln(2);
        this.ind().put("<!-- EOF -->").ln();
    }

    private PmdXmlExporter putModelInfo(PmdModel model) throws IOException {
        I18nText modelName = model.getModelName();
        this.putI18nName(modelName);
        this.ln();
        I18nText description = model.getDescription();
        for (String lang639 : description.lang639CodeList()) {
            String descText = description.getText(lang639);
            this.putDescription(lang639, descText);
            this.ln();
        }
        return this;
    }

    private PmdXmlExporter putDescription(CharSequence lang639, CharSequence content) throws IOException {
        String text = ((Object)content).toString();
        text = text.replace(CRLF, LF);
        text = text.replace(CR, LF);
        this.ind().put("<description");
        if (!I18nText.CODE639_PRIMARY.equals(lang639)) {
            this.put(" ");
            this.putAttr("lang", lang639);
        }
        this.put(">").ln();
        this.putBRedContent(text);
        this.ln();
        this.ind().put("</description>").ln();
        if (!PmdXmlExporter.hasOnlyBasicLatin(text) && this.isBasicLatinOnlyOut()) {
            this.putBlockComment(text);
        }
        return this;
    }

    protected BasicXmlExporter putBRedContent(CharSequence content) throws IOException {
        int length = content.length();
        block7: for (int pos = 0; pos < length; ++pos) {
            char ch = content.charAt(pos);
            if (ch == '\n') {
                this.put("<br/>").ln();
                continue;
            }
            if (Character.isISOControl(ch)) {
                this.putCharRef2Hex(ch);
                continue;
            }
            if (!PmdXmlExporter.isBasicLatin(ch) && this.isBasicLatinOnlyOut()) {
                this.putCharRef4Hex(ch);
                continue;
            }
            switch (ch) {
                case '&': {
                    this.put("&amp;");
                    continue block7;
                }
                case '<': {
                    this.put("&lt;");
                    continue block7;
                }
                case '>': {
                    this.put("&gt;");
                    continue block7;
                }
                case '\"': {
                    this.put("&quot;");
                    continue block7;
                }
                case '\'': {
                    this.put("&apos;");
                    continue block7;
                }
                default: {
                    this.put(ch);
                }
            }
        }
        return this;
    }

    private PmdXmlExporter putMetaInfo(PmdModel model) throws IOException {
        this.ind().put("<license>").ln();
        this.ind().put("</license>").ln(2);
        this.ind().put("<credits>").ln();
        this.ind().put("</credits>").ln(2);
        this.ind().put("<meta ");
        this.putAttr("name", "generator").put(' ').putAttr("content", this.generator);
        this.put(" />").ln();
        this.ind().put("<meta ");
        this.putAttr("name", "siteURL").put(' ').putAttr("content", "");
        this.put(" />").ln();
        this.ind().put("<meta ");
        this.putAttr("name", "imageURL").put(' ').putAttr("content", "");
        this.put(" />").ln(2);
        return this;
    }

    private PmdXmlExporter putMaterialList(PmdModel model) throws IOException {
        this.ind().put("<materialList>").ln(2);
        this.pushNest();
        int ct = 0;
        for (Material material : model.getMaterialList()) {
            this.putMaterial(material, ct++);
        }
        this.popNest();
        this.ind().put("</materialList>").ln(2);
        return this;
    }

    private PmdXmlExporter putMaterial(Material material, int no) throws IOException {
        String bool = material.getEdgeAppearance() ? "true" : "false";
        I18nText name = material.getMaterialName();
        String primary = name.getPrimaryText();
        String local = name.getText();
        if (local != null && local.length() > 0) {
            this.ind().putLineComment(local).ln();
        }
        this.ind().put("<material ");
        if (primary != null && primary.length() > 0) {
            this.putAttr("name", primary).put(' ');
        }
        this.putAttr("showEdge", bool);
        this.put(" ");
        this.putNumberedIdAttr((CharSequence)"surfaceGroupIdRef", (CharSequence)PFX_SURFACEGROUP, no);
        this.put('>').ln();
        this.pushNest();
        this.putI18nName(name);
        float[] rgba = new float[4];
        Color diffuse = material.getDiffuseColor();
        diffuse.getRGBComponents(rgba);
        this.ind().put("<diffuse ");
        this.putFloatAttr("r", rgba[0]).put(' ');
        this.putFloatAttr("g", rgba[1]).put(' ');
        this.putFloatAttr("b", rgba[2]).put(' ');
        this.putFloatAttr("alpha", rgba[3]).put(' ');
        this.put("/>").ln();
        Color specular = material.getSpecularColor();
        specular.getRGBComponents(rgba);
        float shininess = material.getShininess();
        this.ind().put("<specular ");
        this.putFloatAttr("r", rgba[0]).put(' ');
        this.putFloatAttr("g", rgba[1]).put(' ');
        this.putFloatAttr("b", rgba[2]).put(' ');
        this.putFloatAttr("shininess", shininess).put(' ');
        this.put("/>").ln();
        Color ambient = material.getAmbientColor();
        ambient.getRGBComponents(rgba);
        this.ind().put("<ambient ");
        this.putFloatAttr("r", rgba[0]).put(' ');
        this.putFloatAttr("g", rgba[1]).put(' ');
        this.putFloatAttr("b", rgba[2]).put(' ');
        this.put("/>").ln();
        ShadeInfo shade = material.getShadeInfo();
        String textureFileName = shade.getTextureFileName();
        String spheremapFileName = shade.getSpheremapFileName();
        if (shade.isValidToonIndex()) {
            this.ind().put("<toon ");
            int toonIdx = shade.getToonIndex();
            this.putNumberedIdAttr((CharSequence)"toonFileIdRef", (CharSequence)PFX_TOONFILE, toonIdx);
            this.put(" />");
            String toonFileName = shade.getToonFileName();
            if (toonFileName != null && toonFileName.length() > 0) {
                this.put(' ').putLineComment(toonFileName);
            }
            this.ln();
        }
        if (textureFileName != null && textureFileName.length() > 0) {
            this.ind().put("<textureFile ");
            this.putAttr("winFileName", textureFileName);
            this.put(" />").ln();
        }
        if (spheremapFileName != null && spheremapFileName.length() > 0) {
            this.ind().put("<spheremapFile ");
            this.putAttr("winFileName", spheremapFileName);
            this.put(" />").ln();
        }
        this.popNest();
        this.ind().put("</material>").ln(2);
        return this;
    }

    private PmdXmlExporter putToonMap(PmdModel model) throws IOException {
        this.ind().put("<toonMap>").ln();
        this.pushNest();
        ToonMap map = model.getToonMap();
        for (int index = 0; index <= 9; ++index) {
            this.ind().putToon(map, index).ln();
        }
        this.popNest();
        this.ind().put("</toonMap>").ln(2);
        return this;
    }

    private PmdXmlExporter putToon(ToonMap map, int index) throws IOException {
        this.put("<toonDef ");
        this.putNumberedIdAttr((CharSequence)"toonFileId", (CharSequence)PFX_TOONFILE, index).put(' ');
        this.putIntAttr("index", index).put(' ');
        String toonFile = map.getIndexedToon(index);
        this.putAttr("winFileName", toonFile);
        this.put(" />");
        this.putUnescapedComment(toonFile);
        return this;
    }

    private PmdXmlExporter putSurfaceGroupList(PmdModel model) throws IOException {
        this.ind().put("<surfaceGroupList>").ln(2);
        this.pushNest();
        int ct = 0;
        for (Material material : model.getMaterialList()) {
            List<Surface> surfaceList = material.getSurfaceList();
            this.putSurfaceList(surfaceList, ct++);
        }
        this.popNest();
        this.ind().put("</surfaceGroupList>").ln(2);
        return this;
    }

    private PmdXmlExporter putSurfaceList(List<Surface> surfaceList, int index) throws IOException {
        this.ind().put("<surfaceGroup ");
        this.putNumberedIdAttr((CharSequence)"surfaceGroupId", (CharSequence)PFX_SURFACEGROUP, index);
        this.put(">").ln();
        this.pushNest();
        for (Surface surface : surfaceList) {
            this.putSurface(surface);
        }
        this.popNest();
        this.ind().put("</surfaceGroup>").ln(2);
        return this;
    }

    private PmdXmlExporter putSurface(Surface surface) throws IOException {
        this.ind().put("<surface ");
        Vertex vertex1 = surface.getVertex1();
        Vertex vertex2 = surface.getVertex2();
        Vertex vertex3 = surface.getVertex3();
        this.putNumberedIdAttr((CharSequence)"vtxIdRef1", (CharSequence)PFX_VERTEX, vertex1).put(' ');
        this.putNumberedIdAttr((CharSequence)"vtxIdRef2", (CharSequence)PFX_VERTEX, vertex2).put(' ');
        this.putNumberedIdAttr((CharSequence)"vtxIdRef3", (CharSequence)PFX_VERTEX, vertex3).put(' ');
        this.put("/>").ln();
        return this;
    }

    private PmdXmlExporter putVertexList(PmdModel model) throws IOException {
        this.ind().put("<vertexList>").ln(2);
        this.pushNest();
        for (Vertex vertex : model.getVertexList()) {
            this.putVertex(vertex);
        }
        this.popNest();
        this.ind().put("</vertexList>").ln(2);
        return this;
    }

    private PmdXmlExporter putVertex(Vertex vertex) throws IOException {
        String bool = vertex.getEdgeAppearance() ? "true" : "false";
        this.ind().put("<vertex ");
        this.putNumberedIdAttr((CharSequence)"vtxId", (CharSequence)PFX_VERTEX, vertex).put(' ');
        this.putAttr("showEdge", bool);
        this.put(">").ln();
        this.pushNest();
        Pos3d position = vertex.getPosition();
        this.ind().putPosition(position).ln();
        Vec3d normal = vertex.getNormal();
        this.ind().put("<normal ");
        this.putFloatAttr("x", normal.getXVal()).put(' ');
        this.putFloatAttr("y", normal.getYVal()).put(' ');
        this.putFloatAttr("z", normal.getZVal()).put(' ');
        this.put("/>").ln();
        Pos2d uvPos = vertex.getUVPosition();
        this.ind().put("<uvMap ");
        this.putFloatAttr("u", uvPos.getXPos()).put(' ');
        this.putFloatAttr("v", uvPos.getYPos()).put(' ');
        this.put("/>").ln();
        BoneInfo boneA = vertex.getBoneA();
        BoneInfo boneB = vertex.getBoneB();
        int weight = vertex.getWeightA();
        this.ind().put("<skinning ");
        this.putNumberedIdAttr((CharSequence)"boneIdRef1", (CharSequence)PFX_BONE, boneA).put(' ');
        this.putNumberedIdAttr((CharSequence)"boneIdRef2", (CharSequence)PFX_BONE, boneB).put(' ');
        this.putIntAttr("weightBalance", weight).put(' ');
        this.put("/>").ln();
        this.popNest();
        this.ind().put("</vertex>").ln(2);
        return this;
    }

    private PmdXmlExporter putBoneList(PmdModel model) throws IOException {
        this.ind().put("<boneList>").ln(2);
        this.pushNest();
        this.putBlockComment(BONETYPE_COMMENT).ln();
        for (BoneInfo bone : model.getBoneList()) {
            this.putBone(bone);
        }
        this.popNest();
        this.ind().put("</boneList>").ln(2);
        return this;
    }

    private PmdXmlExporter putBone(BoneInfo bone) throws IOException {
        I18nText i18nName = bone.getBoneName();
        BoneType type = bone.getBoneType();
        this.putLocalNameComment(i18nName).putLineComment(type.getGuiName()).ln();
        this.ind().put("<bone ");
        this.putPrimaryNameAttr("name", i18nName).put(' ');
        this.putNumberedIdAttr((CharSequence)"boneId", (CharSequence)PFX_BONE, bone).put(' ');
        this.putAttr("type", type.name());
        this.put(">").ln();
        this.pushNest();
        this.putI18nName(i18nName);
        Pos3d position = bone.getPosition();
        this.ind().putPosition(position).ln();
        BoneInfo ikBone = bone.getIKBone();
        if (bone.getBoneType() == BoneType.LINKEDROT) {
            this.ind().put("<rotationRatio ");
            this.putIntAttr("ratio", bone.getRotationRatio());
            this.put(" />").ln();
        } else if (ikBone != null) {
            this.ind().put("<ikBone ");
            this.putNumberedIdAttr((CharSequence)"boneIdRef", (CharSequence)PFX_BONE, ikBone);
            this.put(" /> ");
            String ikBoneName = "Ref:" + ikBone.getBoneName().getText();
            this.putLineComment(ikBoneName);
            this.ln();
        }
        StringBuilder chainComment = new StringBuilder();
        this.ind().put("<boneChain");
        BoneInfo prev = bone.getPrevBone();
        BoneInfo next = bone.getNextBone();
        if (prev != null) {
            this.put(' ');
            this.putNumberedIdAttr((CharSequence)"prevBoneIdRef", (CharSequence)PFX_BONE, prev);
            chainComment.append('[').append(prev.getBoneName().getPrimaryText()).append(']').append("=> #");
        }
        if (next != null) {
            this.put(' ');
            this.putNumberedIdAttr((CharSequence)"nextBoneIdRef", (CharSequence)PFX_BONE, next);
            if (chainComment.length() <= 0) {
                chainComment.append("#");
            }
            chainComment.append(" =>").append('[').append(next.getBoneName().getPrimaryText()).append(']');
        }
        this.put(" />").ln();
        this.ind().putLineComment(chainComment).ln();
        this.popNest();
        this.ind().put("</bone>").ln(2);
        return this;
    }

    private PmdXmlExporter putBoneGroupList(PmdModel model) throws IOException {
        this.ind().put("<boneGroupList>").ln(2);
        this.pushNest();
        for (BoneGroup group : model.getBoneGroupList()) {
            if (group.isDefaultBoneGroup()) continue;
            this.putBoneGroup(group);
        }
        this.popNest();
        this.ind().put("</boneGroupList>").ln(2);
        return this;
    }

    private PmdXmlExporter putBoneGroup(BoneGroup group) throws IOException {
        I18nText i18nName = group.getGroupName();
        this.putLocalNameComment(i18nName).ln();
        this.ind().put("<boneGroup ");
        this.putPrimaryNameAttr("name", i18nName);
        this.put(">").ln();
        this.pushNest();
        this.putI18nName(i18nName);
        for (BoneInfo bone : group) {
            this.ind().put("<boneGroupMember ");
            this.putNumberedIdAttr((CharSequence)"boneIdRef", (CharSequence)PFX_BONE, bone);
            this.put(" /> ");
            String boneName = "Ref:" + bone.getBoneName().getText();
            this.putLineComment(boneName).ln();
        }
        this.popNest();
        this.ind().put("</boneGroup>").ln(2);
        return this;
    }

    private PmdXmlExporter putIKChainList(PmdModel model) throws IOException {
        this.ind().put("<ikChainList>").ln(2);
        this.pushNest();
        for (IKChain chain : model.getIKChainList()) {
            this.putIKChain(chain);
        }
        this.popNest();
        this.ind().put("</ikChainList>").ln(2);
        return this;
    }

    private PmdXmlExporter putIKChain(IKChain chain) throws IOException {
        int depth = chain.getIKDepth();
        float weight = chain.getIKWeight();
        BoneInfo ikBone = chain.getIkBone();
        this.ind().putLineComment("Ref:" + ikBone.getBoneName().getText()).ln();
        this.ind().put("<ikChain ");
        this.putNumberedIdAttr((CharSequence)"ikBoneIdRef", (CharSequence)PFX_BONE, ikBone).put(' ');
        this.putIntAttr("recursiveDepth", depth).put(' ');
        this.putFloatAttr("weight", weight);
        this.put("> ").ln();
        this.pushNest();
        for (BoneInfo bone : chain) {
            this.ind().put("<chainOrder ");
            this.putNumberedIdAttr((CharSequence)"boneIdRef", (CharSequence)PFX_BONE, bone);
            this.put(" /> ");
            this.putLineComment("Ref:" + bone.getBoneName().getText());
            this.ln();
        }
        this.popNest();
        this.ind().put("</ikChain>").ln(2);
        return this;
    }

    private PmdXmlExporter putMorphList(PmdModel model) throws IOException {
        this.ind().put("<morphList>").ln(2);
        this.pushNest();
        this.putBlockComment(MORPHTYPE_COMMENT).ln();
        Map<MorphType, List<MorphPart>> morphMap = model.getMorphMap();
        for (MorphType type : MorphType.values()) {
            List<MorphPart> partList;
            if (type == MorphType.BASE || (partList = morphMap.get((Object)type)) == null) continue;
            for (MorphPart part : partList) {
                this.putMorphPart(part);
            }
        }
        this.popNest();
        this.ind().put("</morphList>").ln(2);
        return this;
    }

    private PmdXmlExporter putMorphPart(MorphPart part) throws IOException {
        I18nText i18nName = part.getMorphName();
        String primary = i18nName.getPrimaryText();
        this.ind().put("<morph ");
        this.putAttr("name", primary).put(' ');
        this.putAttr("type", part.getMorphType().name());
        this.put(">");
        this.putUnescapedComment(primary);
        this.ln();
        this.pushNest();
        this.putI18nName(i18nName);
        for (MorphVertex mvertex : part) {
            Pos3d offset = mvertex.getOffset();
            Vertex base = mvertex.getBaseVertex();
            this.ind().put("<morphVertex ");
            this.putNumberedIdAttr((CharSequence)"vtxIdRef", (CharSequence)PFX_VERTEX, base).put(' ');
            this.putFloatAttr("xOff", offset.getXPos()).put(' ');
            this.putFloatAttr("yOff", offset.getYPos()).put(' ');
            this.putFloatAttr("zOff", offset.getZPos()).put(' ');
            this.put("/>");
            this.ln();
        }
        this.popNest();
        this.ind().put("</morph>").ln(2);
        return this;
    }

    private PmdXmlExporter putRigidList(PmdModel model) throws IOException {
        this.ind().put("<rigidList>").ln(2);
        this.pushNest();
        this.putBlockComment(RIGIDBEHAVIOR_COMMENT).ln();
        for (RigidInfo rigid : model.getRigidList()) {
            this.putRigid(rigid);
        }
        this.popNest();
        this.ind().put("</rigidList>").ln(2);
        return this;
    }

    private PmdXmlExporter putRigid(RigidInfo rigid) throws IOException {
        BoneInfo linkedBone = rigid.getLinkedBone();
        I18nText i18nName = rigid.getRigidName();
        String primary = i18nName.getPrimaryText();
        this.putLocalNameComment(i18nName).ln();
        this.ind().put("<rigid ");
        this.putAttr("name", primary).put(' ');
        this.putNumberedIdAttr((CharSequence)"rigidId", (CharSequence)PFX_RIGID, rigid).put(' ');
        this.putAttr("behavior", rigid.getBehaviorType().name());
        this.put(">").ln();
        this.pushNest();
        this.putI18nName(i18nName);
        if (linkedBone != null) {
            this.ind().put("<linkedBone ");
            this.putNumberedIdAttr((CharSequence)"boneIdRef", (CharSequence)PFX_BONE, linkedBone);
            this.put(" /> ");
            this.putLineComment("Ref:" + linkedBone.getBoneName().getText());
            this.ln(2);
        }
        RigidShape shape = rigid.getRigidShape();
        this.putRigidShape(shape);
        Pos3d position = rigid.getPosition();
        this.ind().putPosition(position).ln();
        Rad3d rotation = rigid.getRotation();
        this.ind().putRadRotation(rotation).ln();
        DynamicsInfo dynamics = rigid.getDynamicsInfo();
        this.putDynamics(dynamics).ln();
        for (RigidGroup group : rigid.getThroughGroupColl()) {
            this.ind().put("<throughRigidGroup ");
            this.putNumberedIdAttr((CharSequence)"rigidGroupIdRef", (CharSequence)PFX_RIGIDGROUP, group.getSerialNumber() + 1).put(' ');
            this.put(" />").ln();
        }
        this.popNest();
        this.ind().put("</rigid>").ln(2);
        return this;
    }

    private PmdXmlExporter putRigidShape(RigidShape shape) throws IOException {
        RigidShapeType type = shape.getShapeType();
        switch (type) {
            case BOX: {
                this.ind().put("<rigidShapeBox ");
                this.putFloatAttr("width", shape.getWidth()).put(' ');
                this.putFloatAttr("height", shape.getHeight()).put(' ');
                this.putFloatAttr("depth", shape.getDepth()).put(' ');
                break;
            }
            case SPHERE: {
                this.ind().put("<rigidShapeSphere ");
                this.putFloatAttr("radius", shape.getRadius()).put(' ');
                break;
            }
            case CAPSULE: {
                this.ind().put("<rigidShapeCapsule ");
                this.putFloatAttr("height", shape.getHeight()).put(' ');
                this.putFloatAttr("radius", shape.getRadius()).put(' ');
                break;
            }
            default: {
                assert (false);
                throw new AssertionError();
            }
        }
        this.put("/>").ln();
        return this;
    }

    private PmdXmlExporter putDynamics(DynamicsInfo dynamics) throws IOException {
        this.ind().put("<dynamics").ln();
        this.pushNest();
        this.ind().putFloatAttr("mass", dynamics.getMass()).ln();
        this.ind().putFloatAttr("dampingPosition", dynamics.getDampingPosition()).ln();
        this.ind().putFloatAttr("dampingRotation", dynamics.getDampingRotation()).ln();
        this.ind().putFloatAttr("restitution", dynamics.getRestitution()).ln();
        this.ind().putFloatAttr("friction", dynamics.getFriction()).ln();
        this.popNest();
        this.ind().put("/>").ln();
        return this;
    }

    private PmdXmlExporter putRigidGroupList(PmdModel model) throws IOException {
        this.ind().put("<rigidGroupList>").ln(2);
        this.pushNest();
        for (RigidGroup group : model.getRigidGroupList()) {
            this.ind().put("<rigidGroup ");
            this.putNumberedIdAttr((CharSequence)"rigidGroupId", (CharSequence)PFX_RIGIDGROUP, group.getSerialNumber() + 1);
            List<RigidInfo> rigidList = group.getRigidList();
            if (rigidList.size() <= 0) {
                this.put(" />").ln(2);
                continue;
            }
            this.put(">").ln();
            this.pushNest();
            for (RigidInfo rigid : rigidList) {
                this.ind().put("<rigidGroupMember ");
                this.putNumberedIdAttr((CharSequence)"rigidIdRef", (CharSequence)PFX_RIGID, rigid).put(' ');
                this.put("/>");
                this.put(' ');
                this.putLineComment("Ref:" + rigid.getRigidName().getText());
                this.ln();
            }
            this.popNest();
            this.ind().put("</rigidGroup>").ln(2);
        }
        this.popNest();
        this.ind().put("</rigidGroupList>").ln(2);
        return this;
    }

    private PmdXmlExporter putJointList(PmdModel model) throws IOException {
        this.ind().put("<jointList>").ln(2);
        this.pushNest();
        for (JointInfo joint : model.getJointList()) {
            this.putJoint(joint);
        }
        this.popNest();
        this.ind().put("</jointList>").ln(2);
        return this;
    }

    private PmdXmlExporter putJoint(JointInfo joint) throws IOException {
        I18nText i18nName = joint.getJointName();
        this.putLocalNameComment(i18nName).ln();
        this.ind().put("<joint ");
        this.putPrimaryNameAttr("name", i18nName);
        this.put(">").ln();
        this.pushNest();
        this.putI18nName(i18nName);
        RigidInfo rigidA = joint.getRigidA();
        RigidInfo rigidB = joint.getRigidB();
        this.ind().put("<jointedRigidPair ");
        this.putNumberedIdAttr((CharSequence)"rigidIdRef1", (CharSequence)PFX_RIGID, rigidA).put(' ');
        this.putNumberedIdAttr((CharSequence)"rigidIdRef2", (CharSequence)PFX_RIGID, rigidB).put(' ');
        this.put("/>").ln();
        this.ind();
        this.putLineComment("[" + rigidA.getRigidName().getText() + "]" + " <=> [" + rigidB.getRigidName().getText() + "]");
        this.ln(2);
        Pos3d position = joint.getPosition();
        this.ind().putPosition(position).ln();
        TripletRange posRange = joint.getPositionRange();
        this.ind().put("<limitPosition").ln();
        this.pushNest();
        this.ind();
        this.putFloatAttr("xFrom", posRange.getXFrom()).put(' ');
        this.putFloatAttr("xTo", posRange.getXTo()).ln();
        this.ind();
        this.putFloatAttr("yFrom", posRange.getYFrom()).put(' ');
        this.putFloatAttr("yTo", posRange.getYTo()).ln();
        this.ind();
        this.putFloatAttr("zFrom", posRange.getZFrom()).put(' ');
        this.putFloatAttr("zTo", posRange.getZTo()).ln();
        this.popNest();
        this.ind().put("/>").ln(2);
        Rad3d rotation = joint.getRotation();
        this.ind().putRadRotation(rotation).ln();
        TripletRange rotRange = joint.getRotationRange();
        this.ind().put("<limitRotation").ln();
        this.pushNest();
        this.ind();
        this.putFloatAttr("xFrom", rotRange.getXFrom()).put(' ');
        this.putFloatAttr("xTo", rotRange.getXTo()).ln();
        this.ind();
        this.putFloatAttr("yFrom", rotRange.getYFrom()).put(' ');
        this.putFloatAttr("yTo", rotRange.getYTo()).ln();
        this.ind();
        this.putFloatAttr("zFrom", rotRange.getZFrom()).put(' ');
        this.putFloatAttr("zTo", rotRange.getZTo()).ln();
        this.popNest();
        this.ind().put("/>").ln(2);
        Pos3d elaPosition = joint.getElasticPosition();
        this.ind().put("<elasticPosition ");
        this.putFloatAttr("x", elaPosition.getXPos()).put(' ');
        this.putFloatAttr("y", elaPosition.getYPos()).put(' ');
        this.putFloatAttr("z", elaPosition.getZPos()).put(' ');
        this.put("/>").ln();
        Deg3d elaRotation = joint.getElasticRotation();
        this.ind().put("<elasticRotation ");
        this.putFloatAttr("xDeg", elaRotation.getXDeg()).put(' ');
        this.putFloatAttr("yDeg", elaRotation.getYDeg()).put(' ');
        this.putFloatAttr("zDeg", elaRotation.getZDeg()).put(' ');
        this.put("/>").ln(2);
        this.popNest();
        this.ind().put("</joint>").ln(2);
        return this;
    }
}

