/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import jp.sourceforge.mikutoga.binio.FeedableOutputStream;
import jp.sourceforge.mikutoga.binio.IllegalTextExportException;
import jp.sourceforge.mikutoga.binio.TextExporter;

public class BinaryExporter {
    private static final Charset CS_UTF16LE = Charset.forName("UTF-16LE");
    private static final Charset CS_WIN31J = Charset.forName("windows-31j");
    private static final String ERRMSG_ILLENC = "illegal encoding";
    private static final String ERRMSG_TOOLONGTX = "too long text: text \"{0}\" needs {1}bytes encoded but limit={2}bytes";
    private static final int MASK_16 = 65535;
    private static final int BYTES_SHORT = 2;
    private static final int BYTES_INT = 4;
    private static final int BYTES_LONG = 8;
    private static final int BYTES_FLOAT = 4;
    private static final int BYTES_DOUBLE = 8;
    private static final int BUFSZ_PRIM = 8;
    private final OutputStream ostream;
    private final byte[] barray;
    private final ByteBuffer primbuf;
    private final TextExporter texporter_w31j;
    private final TextExporter texporter_u16le;
    private final FeedableOutputStream xos;

    public BinaryExporter(OutputStream ostream) throws NullPointerException {
        if (ostream == null) {
            throw new NullPointerException();
        }
        this.ostream = ostream;
        this.barray = new byte[8];
        this.primbuf = ByteBuffer.wrap(this.barray);
        this.primbuf.order(ByteOrder.LITTLE_ENDIAN);
        this.primbuf.clear();
        this.texporter_w31j = new TextExporter(CS_WIN31J);
        this.texporter_u16le = new TextExporter(CS_UTF16LE);
        this.xos = new FeedableOutputStream();
    }

    public void setOrder(ByteOrder order) {
        this.primbuf.order(order);
    }

    public ByteOrder getOrder() {
        return this.primbuf.order();
    }

    public void close() throws IOException {
        this.ostream.close();
    }

    public BinaryExporter flush() throws IOException {
        this.ostream.flush();
        return this;
    }

    public BinaryExporter dumpByte(byte bVal) throws IOException {
        this.ostream.write(bVal);
        return this;
    }

    public BinaryExporter dumpByte(int iVal) throws IOException {
        this.ostream.write(iVal);
        return this;
    }

    public BinaryExporter dumpByteArray(byte[] array) throws IOException {
        this.dumpByteArray(array, 0, array.length);
        return this;
    }

    public BinaryExporter dumpByteArray(byte[] array, int offset, int length) throws IOException {
        this.ostream.write(array, offset, length);
        return this;
    }

    private void dumpBuffer(int length) throws IOException {
        this.ostream.write(this.barray, 0, length);
    }

    public BinaryExporter dumpShort(short sVal) throws IOException {
        this.primbuf.putShort(0, sVal);
        this.dumpBuffer(2);
        return this;
    }

    public BinaryExporter dumpShort(int iVal) throws IOException {
        short sVal = (short)(iVal & 0xFFFF);
        this.dumpShort(sVal);
        return this;
    }

    public BinaryExporter dumpInt(int iVal) throws IOException {
        this.primbuf.putInt(0, iVal);
        this.dumpBuffer(4);
        return this;
    }

    public BinaryExporter dumpLong(long lVal) throws IOException {
        this.primbuf.putLong(0, lVal);
        this.dumpBuffer(8);
        return this;
    }

    public BinaryExporter dumpFloat(float fVal) throws IOException {
        this.primbuf.putFloat(0, fVal);
        this.dumpBuffer(4);
        return this;
    }

    public BinaryExporter dumpDouble(double dVal) throws IOException {
        this.primbuf.putDouble(0, dVal);
        this.dumpBuffer(8);
        return this;
    }

    public BinaryExporter dumpFiller(byte[] filler, int fillerLength) throws IOException {
        if (filler.length <= 0 || fillerLength <= 0) {
            return this;
        }
        byte lastData = filler[filler.length - 1];
        int fillerIdx = 0;
        for (int remain = fillerLength; remain > 0; --remain) {
            byte bVal = fillerIdx < filler.length ? filler[fillerIdx++] : lastData;
            this.dumpByte(bVal);
        }
        return this;
    }

    public BinaryExporter dumpFixedW31j(CharSequence text, int fixedLength, byte[] filler) throws IOException, IllegalTextExportException {
        int encodedSize;
        this.xos.reset();
        try {
            encodedSize = this.texporter_w31j.encodeToByteStream(text, this.xos);
        }
        catch (CharacterCodingException e) {
            throw new IllegalTextExportException(ERRMSG_ILLENC, e);
        }
        if (0 < fixedLength && fixedLength < encodedSize) {
            String message = MessageFormat.format(ERRMSG_TOOLONGTX, text, encodedSize, fixedLength);
            throw new IllegalTextExportException(message);
        }
        int xferred = this.xos.feedStored(this.ostream);
        int remain = fixedLength - xferred;
        if (remain > 0) {
            this.dumpFiller(filler, remain);
        }
        return this;
    }

    public int dumpHollerithUtf16LE(CharSequence text) throws IOException, IllegalTextExportException {
        int encodedSize;
        this.xos.reset();
        try {
            encodedSize = this.texporter_u16le.encodeToByteStream(text, this.xos);
        }
        catch (CharacterCodingException e) {
            throw new IllegalTextExportException(ERRMSG_ILLENC, e);
        }
        this.dumpInt(encodedSize);
        int xferred = this.xos.feedStored(this.ostream);
        assert (xferred == encodedSize);
        return xferred;
    }
}

