/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import jp.sourceforge.mikutoga.parser.MmdEofException;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;

public class TextDecoder {
    public static final int BYTEBUF_SZ = 512;
    private static final double WIDEN_RATE = 1.5;
    private final CharsetDecoder decoder;
    private boolean chopZero = false;
    private byte[] byteArray;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    private CharBuffer roBuffer;

    public TextDecoder(Charset cs) {
        this(cs.newDecoder());
    }

    public TextDecoder(CharsetDecoder decoder) {
        this.decoder = decoder;
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    protected void prepareBuffer(int newSize) {
        if (this.byteArray != null && this.byteArray.length >= newSize) {
            return;
        }
        int rounded = (int)((double)newSize * 1.5);
        if (rounded < 512) {
            rounded = 512;
        }
        this.byteArray = new byte[rounded];
        this.byteBuffer = ByteBuffer.wrap(this.byteArray);
        float maxCharsPerByte = this.decoder.maxCharsPerByte();
        int maxChars = (int)((float)this.byteBuffer.capacity() * maxCharsPerByte) + 1;
        this.charBuffer = CharBuffer.allocate(maxChars);
        this.roBuffer = this.charBuffer.asReadOnlyBuffer();
    }

    public void setZeroChopMode(boolean chop) {
        this.chopZero = chop;
    }

    public boolean isZeroChopMode() {
        return this.chopZero;
    }

    protected void chopZeroTermed() {
        if (!this.chopZero) {
            return;
        }
        int limit = this.byteBuffer.limit();
        for (int idx = 0; idx < limit; ++idx) {
            byte bVal = this.byteArray[idx];
            if (bVal != 0) continue;
            this.byteBuffer.limit(idx);
            break;
        }
    }

    public CharBuffer parseString(MmdSource source, int byteSize) throws MmdEofException, MmdFormatException, IOException {
        this.prepareBuffer(byteSize);
        source.parseByteArray(this.byteArray, 0, byteSize);
        this.byteBuffer.rewind().limit(byteSize);
        this.chopZeroTermed();
        this.charBuffer.clear();
        this.decoder.reset();
        CoderResult decResult = this.decoder.decode(this.byteBuffer, this.charBuffer, true);
        if (decResult.isError()) {
            if (decResult.isUnmappable()) {
                throw new MmdFormatException("unmapped character", source.getPosition());
            }
            throw new MmdFormatException("illegal character encoding", source.getPosition());
        }
        if (decResult.isOverflow()) assert (false);
        this.roBuffer.rewind().limit(this.charBuffer.position());
        return this.roBuffer;
    }
}

