/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd;

import java.util.Locale;
import java.util.ResourceBundle;

public enum MorphType {
    BASE(0),
    EYEBROW(1),
    EYE(2),
    LIP(3),
    EXTRA(4);

    private static final String FAMILY_NAME = "jp.sourceforge.mikutoga.pmd.resources.MorphTypeName";
    private final byte encoded;

    private MorphType(int code) {
        this((byte)code);
    }

    private MorphType(byte code) {
        this.encoded = code;
    }

    public static MorphType decode(byte code) {
        MorphType result = null;
        for (MorphType type : MorphType.values()) {
            if (type.encode() != code) continue;
            result = type;
            break;
        }
        return result;
    }

    public byte encode() {
        return this.encoded;
    }

    public String getGuiName() {
        Locale locale = Locale.getDefault();
        return this.getGuiName(locale);
    }

    public String getGuiName(Locale locale) {
        if (locale == null) {
            return this.getGuiName();
        }
        ResourceBundle rb = ResourceBundle.getBundle(FAMILY_NAME, locale);
        String key = this.name();
        String result = rb.getString(key);
        return result;
    }

    public boolean isBase() {
        return this == BASE;
    }
}

