/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.parser;

import java.io.IOException;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.MmdSource;
import jp.sourceforge.mikutoga.pmd.parser.PmdJointHandler;
import jp.sourceforge.mikutoga.pmd.parser.PmdParserExt2;
import jp.sourceforge.mikutoga.pmd.parser.PmdRigidHandler;

public class PmdParserExt3
extends PmdParserExt2 {
    private static final int RIGID_DATA_SZ = 83;
    private static final int JOINT_DATA_SZ = 124;
    private PmdRigidHandler rigidHandler = null;
    private PmdJointHandler jointHandler = null;

    public PmdParserExt3(MmdSource source) {
        super(source);
    }

    public void setRigidHandler(PmdRigidHandler handler) {
        this.rigidHandler = handler;
    }

    public void setJointHandler(PmdJointHandler handler) {
        this.jointHandler = handler;
    }

    @Override
    protected void parseBody() throws IOException, MmdFormatException {
        super.parseBody();
        if (this.hasMore()) {
            this.parseRigidList();
            this.parseJointList();
        }
    }

    private void parseRigidList() throws IOException, MmdFormatException {
        int rigidNum = this.parseInteger();
        if (this.rigidHandler == null) {
            this.skip(83 * rigidNum);
            return;
        }
        this.rigidHandler.loopStart(PmdRigidHandler.RIGID_LIST, rigidNum);
        for (int ct = 0; ct < rigidNum; ++ct) {
            String rigidName = this.parseZeroTermWin31J(20);
            this.rigidHandler.pmdRigidName(rigidName);
            int linkedBoneId = this.parseUShortAsInteger();
            int rigidGroupId = this.parseUByteAsInteger();
            short collisionMap = this.parseShort();
            this.rigidHandler.pmdRigidInfo(rigidGroupId, linkedBoneId);
            byte shapeType = this.parseByte();
            float width = this.parseFloat();
            float height = this.parseFloat();
            float depth = this.parseFloat();
            this.rigidHandler.pmdRigidShape(shapeType, width, height, depth);
            float posX = this.parseFloat();
            float posY = this.parseFloat();
            float posZ = this.parseFloat();
            this.rigidHandler.pmdRigidPosition(posX, posY, posZ);
            float rotX = this.parseFloat();
            float rotY = this.parseFloat();
            float rotZ = this.parseFloat();
            this.rigidHandler.pmdRigidRotation(rotX, rotY, rotZ);
            float mass = this.parseFloat();
            float dampingPos = this.parseFloat();
            float dampingRot = this.parseFloat();
            float restitution = this.parseFloat();
            float friction = this.parseFloat();
            this.rigidHandler.pmdRigidPhysics(mass, dampingPos, dampingRot, restitution, friction);
            byte behaveType = this.parseByte();
            this.rigidHandler.pmdRigidBehavior(behaveType, collisionMap);
            this.rigidHandler.loopNext(PmdRigidHandler.RIGID_LIST);
        }
        this.rigidHandler.loopEnd(PmdRigidHandler.RIGID_LIST);
    }

    private void parseJointList() throws IOException, MmdFormatException {
        int jointNum = this.parseInteger();
        if (this.jointHandler == null) {
            this.skip(124 * jointNum);
            return;
        }
        this.jointHandler.loopStart(PmdJointHandler.JOINT_LIST, jointNum);
        for (int ct = 0; ct < jointNum; ++ct) {
            String jointName = this.parseZeroTermWin31J(20);
            this.jointHandler.pmdJointName(jointName);
            int rigidIdA = this.parseInteger();
            int rigidIdB = this.parseInteger();
            this.jointHandler.pmdJointLink(rigidIdA, rigidIdB);
            float posX = this.parseFloat();
            float posY = this.parseFloat();
            float posZ = this.parseFloat();
            this.jointHandler.pmdJointPosition(posX, posY, posZ);
            float rotX = this.parseFloat();
            float rotY = this.parseFloat();
            float rotZ = this.parseFloat();
            this.jointHandler.pmdJointRotation(rotX, rotY, rotZ);
            float posXlim1 = this.parseFloat();
            float posYlim1 = this.parseFloat();
            float posZlim1 = this.parseFloat();
            float posXlim2 = this.parseFloat();
            float posYlim2 = this.parseFloat();
            float posZlim2 = this.parseFloat();
            this.jointHandler.pmdPositionLimit(posXlim1, posXlim2, posYlim1, posYlim2, posZlim1, posZlim2);
            float rotXlim1 = this.parseFloat();
            float rotYlim1 = this.parseFloat();
            float rotZlim1 = this.parseFloat();
            float rotXlim2 = this.parseFloat();
            float rotYlim2 = this.parseFloat();
            float rotZlim2 = this.parseFloat();
            this.jointHandler.pmdRotationLimit(rotXlim1, rotXlim2, rotYlim1, rotYlim2, rotZlim1, rotZlim2);
            float elasticPosX = this.parseFloat();
            float elasticPosY = this.parseFloat();
            float elasticPosZ = this.parseFloat();
            this.jointHandler.pmdElasticPosition(elasticPosX, elasticPosY, elasticPosZ);
            float elasticRotX = this.parseFloat();
            float elasticRotY = this.parseFloat();
            float elasticRotZ = this.parseFloat();
            this.jointHandler.pmdElasticRotation(elasticRotX, elasticRotY, elasticRotZ);
            this.jointHandler.loopNext(PmdJointHandler.JOINT_LIST);
        }
        this.jointHandler.loopEnd(PmdJointHandler.JOINT_LIST);
    }
}

