/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.typical;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.typical.TypicalObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TypicalMorph
extends TypicalObject {
    private static final Class<?> THISCLASS;
    private static final String MORPH_XML = "resources/typicalMorph.xml";
    private static final List<TypicalMorph> EMPTY;
    private static final Map<MorphType, List<TypicalMorph>> TYPED_MAP;
    private static final Map<String, TypicalMorph> PRIMARY_MAP;
    private static final Map<String, TypicalMorph> GLOBAL_MAP;
    private final MorphType type;

    private TypicalMorph(MorphType type, int primaryNo, int globalNo) {
        super(primaryNo, globalNo);
        this.type = type;
    }

    private static void parse(Element top) {
        NodeList groupList = top.getElementsByTagName("morphGroup");
        int groupNo = groupList.getLength();
        for (int idx = 0; idx < groupNo; ++idx) {
            Element group = (Element)groupList.item(idx);
            TypicalMorph.parseGroup(group);
        }
        for (MorphType morphType : MorphType.values()) {
            if (TYPED_MAP.containsKey((Object)morphType)) continue;
            TYPED_MAP.put(morphType, EMPTY);
        }
    }

    private static void parseGroup(Element group) {
        String typeAttr = group.getAttribute("type");
        MorphType morphType = MorphType.valueOf(typeAttr);
        NodeList morphList = group.getElementsByTagName("morph");
        int morphNo = morphList.getLength();
        ArrayList<TypicalMorph> groupedList = new ArrayList<TypicalMorph>(morphNo);
        for (int idx = 0; idx < morphNo; ++idx) {
            Element morph = (Element)morphList.item(idx);
            TypicalMorph common = TypicalMorph.parseMorph(morph, morphType);
            groupedList.add(common);
        }
        TYPED_MAP.put(morphType, Collections.unmodifiableList(groupedList));
    }

    private static TypicalMorph parseMorph(Element morph, MorphType mtype) {
        String name;
        int idx;
        NodeList primaryNodes = morph.getElementsByTagName("primary");
        NodeList globalNodes = morph.getElementsByTagName("global");
        int primaryNo = primaryNodes.getLength();
        int globalNo = globalNodes.getLength();
        TypicalMorph typMorph = new TypicalMorph(mtype, primaryNo, globalNo);
        for (idx = 0; idx < primaryNo; ++idx) {
            Element primary = (Element)primaryNodes.item(idx);
            name = primary.getAttribute("name");
            typMorph.primaryList.add(name);
        }
        for (idx = 0; idx < globalNo; ++idx) {
            Element global = (Element)globalNodes.item(idx);
            name = global.getAttribute("name");
            typMorph.globalList.add(name);
        }
        for (String primaryName : typMorph.primaryList) {
            PRIMARY_MAP.put(primaryName, typMorph);
        }
        for (String globalName : typMorph.globalList) {
            GLOBAL_MAP.put(globalName, typMorph);
        }
        return typMorph;
    }

    private static void numbering() {
        int order = 0;
        for (MorphType morphType : MorphType.values()) {
            for (TypicalMorph common : TYPED_MAP.get((Object)morphType)) {
                common.orderNo = order++;
            }
        }
    }

    public static List<TypicalMorph> getTypedMorphList(MorphType morphType) {
        List<TypicalMorph> result = TYPED_MAP.get((Object)morphType);
        return result;
    }

    public static TypicalMorph findWithPrimary(String primaryName) {
        TypicalMorph result = PRIMARY_MAP.get(primaryName);
        return result;
    }

    public static TypicalMorph findWithGlobal(String globalName) {
        TypicalMorph result = GLOBAL_MAP.get(globalName);
        return result;
    }

    public static String primary2global(String primaryName) {
        TypicalMorph morph = TypicalMorph.findWithPrimary(primaryName);
        if (morph == null) {
            return null;
        }
        String global = morph.getTopGlobalName();
        return global;
    }

    public static String global2primary(String globalName) {
        TypicalMorph morph = TypicalMorph.findWithGlobal(globalName);
        if (morph == null) {
            return null;
        }
        String primary = morph.getTopPrimaryName();
        return primary;
    }

    public MorphType getMorphType() {
        return this.type;
    }

    static {
        Element top;
        THISCLASS = TypicalMorph.class;
        EMPTY = Collections.emptyList();
        TYPED_MAP = new EnumMap<MorphType, List<TypicalMorph>>(MorphType.class);
        PRIMARY_MAP = new HashMap<String, TypicalMorph>();
        GLOBAL_MAP = new HashMap<String, TypicalMorph>();
        InputStream is = THISCLASS.getResourceAsStream(MORPH_XML);
        try {
            top = TypicalObject.loadXml(is);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        TypicalMorph.parse(top);
        TypicalMorph.numbering();
    }
}

