/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.typical;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class TypicalObject {
    public static final Comparator<TypicalObject> ORDER_COMPARATOR = new OrderComparator();
    protected final List<String> primaryList;
    protected final List<String> globalList;
    protected final List<String> umodPrimaryList;
    protected final List<String> umodGlobalList;
    protected int orderNo;

    protected TypicalObject(int primaryNo, int globalNo) {
        this.primaryList = primaryNo <= 0 ? new LinkedList<String>() : new ArrayList<String>(primaryNo);
        this.globalList = globalNo <= 0 ? new LinkedList<String>() : new ArrayList<String>(globalNo);
        this.umodPrimaryList = Collections.unmodifiableList(this.primaryList);
        this.umodGlobalList = Collections.unmodifiableList(this.globalList);
    }

    protected TypicalObject() {
        this(0, 0);
    }

    protected static Element loadXml(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        Element top = doc.getDocumentElement();
        return top;
    }

    public String getTopPrimaryName() {
        String result = this.primaryList.get(0);
        return result;
    }

    public String getTopGlobalName() {
        String result = this.globalList.isEmpty() ? null : this.globalList.get(0);
        return result;
    }

    public List<String> getPrimaryList() {
        return this.umodPrimaryList;
    }

    public List<String> getGlobalList() {
        return this.umodGlobalList;
    }

    private static class OrderComparator
    implements Comparator<TypicalObject> {
        OrderComparator() {
        }

        @Override
        public int compare(TypicalObject o1, TypicalObject o2) {
            int result = o1.orderNo - o2.orderNo;
            return result;
        }
    }
}

