/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd;

import java.nio.charset.Charset;

public final class VmdConst {
    public static final int HEADER_LENGTH = 30;
    public static final String MAGIC_TXT = "Vocaloid Motion Data 0002";
    public static final int MODELNAME_MAX = 20;
    public static final int BONENAME_MAX = 15;
    public static final int MORPHNAME_MAX = 15;
    public static final String MODELNAME_STAGEACT = "\u30ab\u30e1\u30e9\u30fb\u7167\u660e";
    public static final String MORPHNAME_BASE = "base";
    public static final int BONEMOTION_DATA_SZ = 111;
    public static final int MORPH_DATA_SZ = 23;
    public static final int CAMERA_DATA_SZ = 61;
    public static final int LUMINOUS_DATA_SZ = 28;
    public static final int SHADOW_DATA_SZ = 9;
    private static final Charset CS_ASCII = Charset.forName("US-ASCII");
    private static final byte[] MAGIC_BYTES = VmdConst.createMagicHeader();

    private VmdConst() {
        assert (false);
        throw new AssertionError();
    }

    public static byte[] createMagicHeader() {
        byte[] result = "Vocaloid Motion Data 0002\u0000".getBytes(CS_ASCII);
        return result;
    }

    public static boolean startsWithMagic(byte[] array) {
        if (MAGIC_BYTES.length > array.length) {
            return false;
        }
        for (int idx = 0; idx < MAGIC_BYTES.length; ++idx) {
            if (array[idx] == MAGIC_BYTES[idx]) continue;
            return false;
        }
        return true;
    }

    public static boolean isStageActName(String modelName) {
        return MODELNAME_STAGEACT.equals(modelName);
    }

    public static boolean isBaseMorphName(String morphName) {
        return MORPHNAME_BASE.equals(morphName);
    }

    static {
        assert (MAGIC_BYTES.length <= 30);
        assert (MODELNAME_STAGEACT.equals(MODELNAME_STAGEACT));
    }
}

