/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model;

import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.vmd.AbstractNumbered;
import jp.sourceforge.mikutoga.vmd.model.BezierParam;
import jp.sourceforge.mikutoga.vmd.model.CameraRotation;
import jp.sourceforge.mikutoga.vmd.model.PosCurve;

public class CameraMotion
extends AbstractNumbered {
    private final MkPos3D cameraTarget = new MkPos3D();
    private final PosCurve posCurve = new PosCurve();
    private final CameraRotation cameraRotation = new CameraRotation();
    private final BezierParam intpltRotation = new BezierParam();
    private float range;
    private final BezierParam intpltRange = new BezierParam();
    private boolean hasPerspective;
    private int projectionAngle;
    private final BezierParam intpltProjection = new BezierParam();

    public MkPos3D getCameraTarget() {
        return this.cameraTarget;
    }

    public PosCurve getTargetPosCurve() {
        return this.posCurve;
    }

    public CameraRotation getCameraRotation() {
        return this.cameraRotation;
    }

    public BezierParam getIntpltRotation() {
        return this.intpltRotation;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public BezierParam getIntpltRange() {
        return this.intpltRange;
    }

    public boolean hasPerspective() {
        return this.hasPerspective;
    }

    public void setPerspectiveMode(boolean mode) {
        this.hasPerspective = mode;
    }

    public int getProjectionAngle() {
        return this.projectionAngle;
    }

    public void setProjectionAngle(int angle) {
        this.projectionAngle = angle;
    }

    public BezierParam getIntpltProjection() {
        return this.intpltProjection;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("#").append(this.getFrameNumber()).append(' ');
        result.append(this.cameraRotation);
        result.append(" Rot-Bezier ").append(this.intpltRotation).append('\n');
        result.append("range : ").append(this.range);
        result.append(" Range-Bezier ").append(this.intpltRange).append('\n');
        result.append("target-pos : ").append(this.cameraTarget).append('\n');
        result.append(this.posCurve).append('\n');
        result.append("perspective : ");
        if (this.hasPerspective) {
            result.append("ON");
        } else {
            result.append("OFF");
        }
        result.append('\n');
        result.append("projection angle : ").append(this.projectionAngle);
        result.append("deg Bezier ").append(this.intpltProjection);
        return result.toString();
    }
}

