/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedListMap<E> {
    private final List<String> nameList = new LinkedList<String>();
    private final Map<String, List<E>> listMap = new HashMap<String, List<E>>();

    public void clear() {
        this.nameList.clear();
        this.listMap.clear();
    }

    public boolean isEmpty() {
        return this.listMap.isEmpty();
    }

    public List<String> getNames() {
        List<String> result = Collections.unmodifiableList(this.nameList);
        return result;
    }

    public List<E> getNamedList(String name) {
        List<E> result = this.listMap.get(name);
        return result;
    }

    public void removeNamedList(String name) {
        if (this.listMap.remove(name) == null) {
            return;
        }
        this.nameList.remove(name);
    }

    public void addNamedElement(String name, E elem) throws NullPointerException {
        if (name == null || elem == null) {
            throw new NullPointerException();
        }
        List<E> list = this.listMap.get(name);
        if (list == null) {
            list = new LinkedList();
            this.listMap.put(name, list);
            this.nameList.add(name);
        }
        list.add(elem);
    }
}

