/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mikutoga.vmd.AbstractNumbered;
import jp.sourceforge.mikutoga.vmd.FrameNumbered;
import jp.sourceforge.mikutoga.vmd.VmdConst;
import jp.sourceforge.mikutoga.vmd.model.BoneMotion;
import jp.sourceforge.mikutoga.vmd.model.CameraMotion;
import jp.sourceforge.mikutoga.vmd.model.LuminousMotion;
import jp.sourceforge.mikutoga.vmd.model.MorphMotion;
import jp.sourceforge.mikutoga.vmd.model.NamedListMap;
import jp.sourceforge.mikutoga.vmd.model.ShadowMotion;

public class VmdMotion {
    private String modelName = "\u30ab\u30e1\u30e9\u30fb\u7167\u660e";
    private final NamedListMap<BoneMotion> bonePartMap = new NamedListMap();
    private final NamedListMap<MorphMotion> morphPartMap = new NamedListMap();
    private final List<CameraMotion> cameraMotionList = new LinkedList<CameraMotion>();
    private final List<LuminousMotion> luminousMotionList = new LinkedList<LuminousMotion>();
    private final List<ShadowMotion> shadowMotionList = new LinkedList<ShadowMotion>();

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) throws NullPointerException {
        if (modelName == null) {
            throw new NullPointerException();
        }
        this.modelName = modelName;
    }

    public boolean isModelMotion() {
        return !VmdConst.isStageActName(this.modelName);
    }

    public NamedListMap<BoneMotion> getBonePartMap() {
        return this.bonePartMap;
    }

    public NamedListMap<MorphMotion> getMorphPartMap() {
        return this.morphPartMap;
    }

    public List<CameraMotion> getCameraMotionList() {
        return this.cameraMotionList;
    }

    public List<LuminousMotion> getLuminousMotionList() {
        return this.luminousMotionList;
    }

    public List<ShadowMotion> getShadowMotionList() {
        return this.shadowMotionList;
    }

    public void addBoneMotion(BoneMotion motion) {
        String name = motion.getBoneName();
        this.bonePartMap.addNamedElement(name, motion);
    }

    public void addMorphMotion(MorphMotion motion) {
        String name = motion.getMorphName();
        this.morphPartMap.addNamedElement(name, motion);
    }

    public void frameSort() {
        List<AbstractNumbered> motionList;
        for (String name : this.bonePartMap.getNames()) {
            motionList = this.bonePartMap.getNamedList(name);
            Collections.sort(motionList, FrameNumbered.COMPARATOR);
        }
        for (String name : this.morphPartMap.getNames()) {
            motionList = this.morphPartMap.getNamedList(name);
            Collections.sort(motionList, FrameNumbered.COMPARATOR);
        }
        Collections.sort(this.cameraMotionList, FrameNumbered.COMPARATOR);
        Collections.sort(this.luminousMotionList, FrameNumbered.COMPARATOR);
        Collections.sort(this.shadowMotionList, FrameNumbered.COMPARATOR);
    }

    public String toString() {
        List<AbstractNumbered> motionList;
        String dash = "---";
        StringBuilder result = new StringBuilder();
        result.append("model name : ").append(this.modelName).append('\n');
        for (String boneName : this.bonePartMap.getNames()) {
            motionList = this.bonePartMap.getNamedList(boneName);
            for (BoneMotion boneMotion : motionList) {
                result.append(dash).append('\n');
                result.append(boneMotion.toString()).append('\n');
            }
        }
        for (String morphName : this.morphPartMap.getNames()) {
            if (VmdConst.isBaseMorphName(morphName)) continue;
            motionList = this.morphPartMap.getNamedList(morphName);
            for (MorphMotion morphMotion : motionList) {
                result.append(morphMotion.toString()).append('\n');
            }
        }
        for (CameraMotion camera : this.cameraMotionList) {
            result.append(dash).append('\n');
            result.append(camera.toString()).append('\n');
        }
        for (LuminousMotion luminous : this.luminousMotionList) {
            result.append(luminous.toString()).append('\n');
        }
        for (ShadowMotion shadow : this.shadowMotionList) {
            result.append(shadow.toString()).append('\n');
        }
        return result.toString();
    }
}

