/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.sourceforge.mikutoga.binio.BinaryExporter;
import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.vmd.model.BezierParam;
import jp.sourceforge.mikutoga.vmd.model.CameraMotion;
import jp.sourceforge.mikutoga.vmd.model.CameraRotation;
import jp.sourceforge.mikutoga.vmd.model.PosCurve;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;

class CameraExporter
extends BinaryExporter {
    CameraExporter(OutputStream stream) {
        super(stream);
    }

    void dumpCameraMotion(VmdMotion motion) throws IOException {
        List<CameraMotion> list = motion.getCameraMotionList();
        int count = list.size();
        this.dumpInt(count);
        for (CameraMotion cameraMotion : list) {
            int frame = cameraMotion.getFrameNumber();
            this.dumpInt(frame);
            float range = cameraMotion.getRange();
            this.dumpFloat(range);
            MkPos3D targetPos = cameraMotion.getCameraTarget();
            this.dumpFloat((float)targetPos.getXpos());
            this.dumpFloat((float)targetPos.getYpos());
            this.dumpFloat((float)targetPos.getZpos());
            CameraRotation rotation = cameraMotion.getCameraRotation();
            this.dumpFloat(rotation.getLatitude());
            this.dumpFloat(rotation.getLongitude());
            this.dumpFloat(rotation.getRoll());
            this.dumpCameraCurve(cameraMotion);
            this.dumpInt(cameraMotion.getProjectionAngle());
            byte perspectiveSwitch = cameraMotion.hasPerspective() ? (byte)0 : 1;
            this.dumpByte(perspectiveSwitch);
        }
    }

    private void dumpCameraCurve(CameraMotion cameraMotion) throws IOException {
        PosCurve posCurve = cameraMotion.getTargetPosCurve();
        BezierParam xCurve = posCurve.getIntpltXpos();
        BezierParam yCurve = posCurve.getIntpltYpos();
        BezierParam zCurve = posCurve.getIntpltZpos();
        this.dumpCameraBezier(xCurve);
        this.dumpCameraBezier(yCurve);
        this.dumpCameraBezier(zCurve);
        BezierParam rotCurve = cameraMotion.getIntpltRotation();
        BezierParam rangeCurve = cameraMotion.getIntpltRange();
        BezierParam projCurve = cameraMotion.getIntpltProjection();
        this.dumpCameraBezier(rotCurve);
        this.dumpCameraBezier(rangeCurve);
        this.dumpCameraBezier(projCurve);
    }

    private void dumpCameraBezier(BezierParam bezier) throws IOException {
        this.dumpByte(bezier.getP1x());
        this.dumpByte(bezier.getP2x());
        this.dumpByte(bezier.getP1y());
        this.dumpByte(bezier.getP2y());
    }
}

