/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.binio;

import java.util.List;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.ParseStage;
import jp.sourceforge.mikutoga.vmd.model.BezierParam;
import jp.sourceforge.mikutoga.vmd.model.CameraMotion;
import jp.sourceforge.mikutoga.vmd.model.CameraRotation;
import jp.sourceforge.mikutoga.vmd.model.PosCurve;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;
import jp.sourceforge.mikutoga.vmd.parser.VmdCameraHandler;

class CameraLoader
implements VmdCameraHandler {
    private final List<CameraMotion> cameraMotionList;
    private CameraMotion currentCameraMotion;

    CameraLoader(VmdMotion vmdMotion) {
        this.cameraMotionList = vmdMotion.getCameraMotionList();
        this.currentCameraMotion = null;
    }

    @Override
    public void loopStart(ParseStage stage, int loops) throws MmdFormatException {
        this.currentCameraMotion = new CameraMotion();
    }

    @Override
    public void loopNext(ParseStage stage) throws MmdFormatException {
        this.cameraMotionList.add(this.currentCameraMotion);
        this.currentCameraMotion = new CameraMotion();
    }

    @Override
    public void loopEnd(ParseStage stage) throws MmdFormatException {
        this.currentCameraMotion = null;
    }

    @Override
    public void vmdCameraMotion(int keyFrameNo) throws MmdFormatException {
        this.currentCameraMotion.setFrameNumber(keyFrameNo);
    }

    @Override
    public void vmdCameraPosition(float xPos, float yPos, float zPos) throws MmdFormatException {
        this.currentCameraMotion.getCameraTarget().setPosition(xPos, yPos, zPos);
    }

    @Override
    public void vmdCameraRotation(float latitude, float longitude, float roll) throws MmdFormatException {
        CameraRotation rotation = this.currentCameraMotion.getCameraRotation();
        rotation.setLatitude(latitude);
        rotation.setLongitude(longitude);
        rotation.setRoll(roll);
    }

    @Override
    public void vmdCameraRange(float range) throws MmdFormatException {
        this.currentCameraMotion.setRange(range);
    }

    @Override
    public void vmdCameraProjection(int angle, boolean hasPerspective) throws MmdFormatException {
        this.currentCameraMotion.setProjectionAngle(angle);
        this.currentCameraMotion.setPerspectiveMode(hasPerspective);
    }

    @Override
    public void vmdCameraIntpltXpos(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        PosCurve posCurve = this.currentCameraMotion.getTargetPosCurve();
        BezierParam bezier = posCurve.getIntpltXpos();
        bezier.setP1(p1x, p1y);
        bezier.setP2(p2x, p2y);
    }

    @Override
    public void vmdCameraIntpltYpos(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        PosCurve posCurve = this.currentCameraMotion.getTargetPosCurve();
        BezierParam bezier = posCurve.getIntpltYpos();
        bezier.setP1(p1x, p1y);
        bezier.setP2(p2x, p2y);
    }

    @Override
    public void vmdCameraIntpltZpos(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        PosCurve posCurve = this.currentCameraMotion.getTargetPosCurve();
        BezierParam bezier = posCurve.getIntpltZpos();
        bezier.setP1(p1x, p1y);
        bezier.setP2(p2x, p2y);
    }

    @Override
    public void vmdCameraIntpltRotation(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        BezierParam bezier = this.currentCameraMotion.getIntpltRotation();
        bezier.setP1(p1x, p1y);
        bezier.setP2(p2x, p2y);
    }

    @Override
    public void vmdCameraIntpltRange(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        BezierParam bezier = this.currentCameraMotion.getIntpltRange();
        bezier.setP1(p1x, p1y);
        bezier.setP2(p2x, p2y);
    }

    @Override
    public void vmdCameraIntpltProjection(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        BezierParam bezier = this.currentCameraMotion.getIntpltProjection();
        bezier.setP1(p1x, p1y);
        bezier.setP2(p2x, p2y);
    }
}

