/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.binio;

import java.util.List;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.ParseStage;
import jp.sourceforge.mikutoga.vmd.model.LuminousColor;
import jp.sourceforge.mikutoga.vmd.model.LuminousMotion;
import jp.sourceforge.mikutoga.vmd.model.LuminousVector;
import jp.sourceforge.mikutoga.vmd.model.ShadowMode;
import jp.sourceforge.mikutoga.vmd.model.ShadowMotion;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;
import jp.sourceforge.mikutoga.vmd.parser.VmdLightingHandler;

class LightingLoader
implements VmdLightingHandler {
    private final List<LuminousMotion> luminousMotionList;
    private final List<ShadowMotion> shadowMotionList;
    private LuminousMotion currentLuminousMotion;
    private ShadowMotion currentShadowMotion;

    LightingLoader(VmdMotion vmdMotion) {
        this.luminousMotionList = vmdMotion.getLuminousMotionList();
        this.shadowMotionList = vmdMotion.getShadowMotionList();
        this.currentLuminousMotion = null;
        this.currentShadowMotion = null;
    }

    private static boolean isLuminousList(ParseStage stage) {
        return stage == VmdLightingHandler.LUMINOUS_LIST;
    }

    private static boolean isShadowList(ParseStage stage) {
        return stage == VmdLightingHandler.SHADOW_LIST;
    }

    @Override
    public void loopStart(ParseStage stage, int loops) throws MmdFormatException {
        if (LightingLoader.isLuminousList(stage)) {
            this.currentLuminousMotion = new LuminousMotion();
        } else if (LightingLoader.isShadowList(stage)) {
            this.currentShadowMotion = new ShadowMotion();
        }
    }

    @Override
    public void loopNext(ParseStage stage) throws MmdFormatException {
        if (LightingLoader.isLuminousList(stage)) {
            this.luminousMotionList.add(this.currentLuminousMotion);
            this.currentLuminousMotion = new LuminousMotion();
        } else if (LightingLoader.isShadowList(stage)) {
            this.shadowMotionList.add(this.currentShadowMotion);
            this.currentShadowMotion = new ShadowMotion();
        }
    }

    @Override
    public void loopEnd(ParseStage stage) throws MmdFormatException {
        if (LightingLoader.isLuminousList(stage)) {
            this.currentLuminousMotion = null;
        } else if (LightingLoader.isShadowList(stage)) {
            this.currentShadowMotion = null;
        }
    }

    @Override
    public void vmdLuminousMotion(int keyFrameNo) throws MmdFormatException {
        this.currentLuminousMotion.setFrameNumber(keyFrameNo);
    }

    @Override
    public void vmdLuminousColor(float rVal, float gVal, float bVal) throws MmdFormatException {
        LuminousColor color = this.currentLuminousMotion.getColor();
        color.setColR(rVal);
        color.setColG(gVal);
        color.setColB(bVal);
    }

    @Override
    public void vmdLuminousDirection(float xVec, float yVec, float zVec) throws MmdFormatException {
        LuminousVector direction = this.currentLuminousMotion.getDirection();
        direction.setVecX(xVec);
        direction.setVecY(yVec);
        direction.setVecZ(zVec);
    }

    @Override
    public void vmdShadowMotion(int keyFrameNo) throws MmdFormatException {
        this.currentShadowMotion.setFrameNumber(keyFrameNo);
    }

    @Override
    public void vmdShadowMode(byte shadowMode) throws MmdFormatException {
        ShadowMode mode = ShadowMode.decode(shadowMode);
        this.currentShadowMotion.setShadowMode(mode);
    }

    @Override
    public void vmdShadowScopeRaw(float shadowScope) throws MmdFormatException {
        this.currentShadowMotion.setRawScopeParam(shadowScope);
    }
}

