/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.model.xml;

import java.util.List;
import jp.sourceforge.mikutoga.vmd.model.LuminousColor;
import jp.sourceforge.mikutoga.vmd.model.LuminousMotion;
import jp.sourceforge.mikutoga.vmd.model.LuminousVector;
import jp.sourceforge.mikutoga.vmd.model.ShadowMode;
import jp.sourceforge.mikutoga.vmd.model.ShadowMotion;
import jp.sourceforge.mikutoga.vmd.model.VmdMotion;
import jp.sourceforge.mikutoga.vmd.model.xml.Xml;
import jp.sourceforge.mikutoga.xml.TogaXmlException;
import org.w3c.dom.Element;

final class XmlLightingLoader {
    private XmlLightingLoader() {
        assert (false);
        throw new AssertionError();
    }

    static void buildLuminousSeq(Element vmdMotionElem, VmdMotion vmdMotion) throws TogaXmlException {
        List<LuminousMotion> luminousList = vmdMotion.getLuminousMotionList();
        Element luminousSeqElem = Xml.getChild(vmdMotionElem, "luminousSequence");
        Iterable<Element> childs = Xml.eachChild(luminousSeqElem, "luminousAct");
        for (Element luminousActElem : childs) {
            XmlLightingLoader.buildLuminousAct(luminousActElem, luminousList);
        }
    }

    private static void buildLuminousAct(Element luminousActElem, List<LuminousMotion> luminousList) throws TogaXmlException {
        LuminousMotion luminousMotion = new LuminousMotion();
        int frameNo = Xml.getIntegerAttr(luminousActElem, "frame");
        luminousMotion.setFrameNumber(frameNo);
        Element lumiColorElem = Xml.getChild(luminousActElem, "lumiColor");
        LuminousColor color = luminousMotion.getColor();
        float rCol = Xml.getFloatAttr(lumiColorElem, "rCol");
        float gCol = Xml.getFloatAttr(lumiColorElem, "gCol");
        float bCol = Xml.getFloatAttr(lumiColorElem, "bCol");
        color.setColR(rCol);
        color.setColG(gCol);
        color.setColB(bCol);
        Element lumiDirectionElem = Xml.getChild(luminousActElem, "lumiDirection");
        LuminousVector vec = luminousMotion.getDirection();
        float xVec = Xml.getFloatAttr(lumiDirectionElem, "xVec");
        float yVec = Xml.getFloatAttr(lumiDirectionElem, "yVec");
        float zVec = Xml.getFloatAttr(lumiDirectionElem, "zVec");
        vec.setVecX(xVec);
        vec.setVecY(yVec);
        vec.setVecZ(zVec);
        luminousList.add(luminousMotion);
    }

    static void buildShadowSeq(Element vmdMotionElem, VmdMotion vmdMotion) throws TogaXmlException {
        List<ShadowMotion> shadowMotionList = vmdMotion.getShadowMotionList();
        Element shadowSeqElem = Xml.getChild(vmdMotionElem, "shadowSequence");
        for (Element shadowActElem : Xml.eachChild(shadowSeqElem, "shadowAct")) {
            XmlLightingLoader.buildShadowAct(shadowActElem, shadowMotionList);
        }
    }

    private static void buildShadowAct(Element shadowActElem, List<ShadowMotion> shadowMotionList) throws TogaXmlException {
        ShadowMotion shadowMotion = new ShadowMotion();
        int frameNo = Xml.getIntegerAttr(shadowActElem, "frame");
        shadowMotion.setFrameNumber(frameNo);
        float rawParam = Xml.getFloatAttr(shadowActElem, "rawParam");
        shadowMotion.setRawScopeParam(rawParam);
        String modeAttr = Xml.getStringAttr(shadowActElem, "mode");
        ShadowMode mode = ShadowMode.valueOf(modeAttr);
        shadowMotion.setShadowMode(mode);
        shadowMotionList.add(shadowMotion);
    }
}

