/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd2xml;

import java.util.Arrays;
import java.util.Iterator;

final class ArgInfo {
    public static final String CMD_HELP = "-h       : put help massage\n\n-vmd2xml : convert *.vmd to *.xml\n-xml2vmd : convert *.xml to *.vmd\n\n-i file  : specify input file\n-o file  : specify output file\n-f       : force overwriting\n\n-quat    : Quaternion output mode [default]\n-eyxz    : YXZ-Euler output mode\n";
    private static final String ERRMSG_UNKNOWN = "Unknown option : ";
    private static final String ERRMSG_INCOMP_I = "You need -i argument.";
    private static final String ERRMSG_INCOMP_O = "You need -o argument.";
    private static final String ERRMSG_EXCLUSIVE = "You must specify -vmd2xml or -xml2vmd.";
    private static final String ERRMSG_NOINPUT = "You must specify input file with -i.";
    private static final String ERRMSG_NOOUTPUT = "You must specify output file with -o.";
    private String inputFile = null;
    private String outputFile = null;
    private boolean vmd2xml = false;
    private boolean xml2vmd = false;
    private boolean force = false;
    private boolean helpMode = false;
    private boolean quaternionMode = true;
    private boolean hasOptionError = false;
    private String errorMessage = null;

    private ArgInfo() {
    }

    public static ArgInfo buildArgInfo(String[] args) {
        return ArgInfo.buildArgInfo(Arrays.asList(args));
    }

    public static ArgInfo buildArgInfo(Iterable<String> args) {
        return ArgInfo.buildArgInfo(args.iterator());
    }

    public static ArgInfo buildArgInfo(Iterator<String> argIter) {
        ArgInfo result = new ArgInfo();
        while (argIter.hasNext()) {
            String arg = argIter.next();
            OptSwitch option = OptSwitch.parse(arg);
            if (option == null) {
                result.setOptionError(ERRMSG_UNKNOWN + arg);
                break;
            }
            result.parseOption(option, argIter);
            if (!result.hasOptionError() && !result.isHelpMode()) continue;
            break;
        }
        result.checkOptionError();
        return result;
    }

    private void parseOption(OptSwitch option, Iterator<String> argIter) {
        switch (option) {
            case HELP: {
                this.helpMode = true;
                break;
            }
            case VMD2XML: {
                this.vmd2xml = true;
                this.xml2vmd = false;
                break;
            }
            case XML2VMD: {
                this.vmd2xml = false;
                this.xml2vmd = true;
                break;
            }
            case FORCE: {
                this.force = true;
                break;
            }
            case INPUTFILE: {
                if (!argIter.hasNext()) {
                    this.setOptionError(ERRMSG_INCOMP_I);
                    break;
                }
                this.inputFile = argIter.next();
                break;
            }
            case OUTPUTFILE: {
                if (!argIter.hasNext()) {
                    this.setOptionError(ERRMSG_INCOMP_O);
                    break;
                }
                this.outputFile = argIter.next();
                break;
            }
            case QUATERNION: {
                this.quaternionMode = true;
                break;
            }
            case EULERYXZ: {
                this.quaternionMode = false;
                break;
            }
            default: {
                assert (false);
                throw new AssertionError();
            }
        }
    }

    private void checkOptionError() {
        if (this.hasOptionError() || this.isHelpMode()) {
            return;
        }
        if (!this.isVmd2XmlMode() && !this.isXml2VmdMode()) {
            this.setOptionError(ERRMSG_EXCLUSIVE);
        } else if (this.getInputFile() == null) {
            this.setOptionError(ERRMSG_NOINPUT);
        } else if (this.getOutputFile() == null) {
            this.setOptionError(ERRMSG_NOOUTPUT);
        }
    }

    private void setOptionError(CharSequence text) {
        if (text == null) {
            this.errorMessage = null;
            this.hasOptionError = false;
        } else {
            this.errorMessage = ((Object)text).toString();
            this.hasOptionError = true;
        }
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean isForceMode() {
        return this.force;
    }

    public boolean isVmd2XmlMode() {
        return this.vmd2xml;
    }

    public boolean isXml2VmdMode() {
        return this.xml2vmd;
    }

    public boolean isHelpMode() {
        return this.helpMode;
    }

    public boolean isQuaternionMode() {
        return this.quaternionMode;
    }

    public boolean hasOptionError() {
        return this.hasOptionError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private static enum OptSwitch implements Iterable<String>
    {
        HELP("-h", "-help", "-?"),
        VMD2XML("-vmd2xml"),
        XML2VMD("-xml2vmd"),
        FORCE("-f"),
        INPUTFILE("-i"),
        OUTPUTFILE("-o"),
        QUATERNION("-quat"),
        EULERYXZ("-eyxz");

        private final Iterable<String> optLines;

        private OptSwitch(String ... optLines) {
            this.optLines = Arrays.asList(optLines);
        }

        @Override
        public Iterator<String> iterator() {
            return this.optLines.iterator();
        }

        private static OptSwitch parse(String arg) {
            for (OptSwitch opt : OptSwitch.values()) {
                for (String optLine : opt) {
                    if (!optLine.equals(arg)) continue;
                    return opt;
                }
            }
            return null;
        }
    }
}

