/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.binio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import jp.sfjp.mikutoga.pmd.binio.PmdExporterBase;
import jp.sfjp.mikutoga.pmd.model.BoneGroup;
import jp.sfjp.mikutoga.pmd.model.BoneInfo;
import jp.sfjp.mikutoga.pmd.model.MorphPart;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sourceforge.mikutoga.binio.IllegalTextExportException;
import jp.sourceforge.mikutoga.pmd.IllegalPmdDataException;
import jp.sourceforge.mikutoga.pmd.MorphType;

public class PmdExporterExt1
extends PmdExporterBase {
    public PmdExporterExt1(OutputStream stream) throws NullPointerException {
        super(stream);
    }

    @Override
    public void dumpPmdModel(PmdModel model) throws IOException, IllegalPmdDataException {
        super.dumpPmdModel(model);
        this.dumpGlobalInfo(model);
    }

    private void dumpGlobalInfo(PmdModel model) throws IOException, IllegalPmdDataException {
        boolean hasGlobal = model.hasGlobalText();
        byte globalFlag = hasGlobal ? (byte)1 : 0;
        this.dumpByte(globalFlag);
        if (hasGlobal) {
            try {
                this.dumpBasicGlobal(model);
                this.dumpBoneGlobal(model);
                this.dumpMorphGlobal(model);
                this.dumpBoneGroupGlobal(model);
            }
            catch (IllegalTextExportException e) {
                throw new IllegalPmdDataException(e);
            }
        }
        this.flush();
    }

    private void dumpBasicGlobal(PmdModel model) throws IOException, IllegalTextExportException {
        String modelName = model.getModelName().getGlobalText();
        if (modelName == null) {
            modelName = "";
        }
        this.dumpText(modelName, 20);
        String description = model.getDescription().getGlobalText();
        if (description == null) {
            description = "";
        }
        this.dumpText(description, 256);
        this.flush();
    }

    private void dumpBoneGlobal(PmdModel model) throws IOException, IllegalTextExportException {
        for (BoneInfo bone : model.getBoneList()) {
            String boneName = bone.getBoneName().getGlobalText();
            if (boneName == null) {
                boneName = "";
            }
            this.dumpText(boneName, 20);
        }
        this.flush();
    }

    private void dumpMorphGlobal(PmdModel model) throws IOException, IllegalTextExportException {
        Map<MorphType, List<MorphPart>> morphMap = model.getMorphMap();
        for (MorphType type : MorphType.values()) {
            List<MorphPart> partList;
            if (type.isBase() || (partList = morphMap.get((Object)type)) == null) continue;
            for (MorphPart part : partList) {
                String morphName = part.getMorphName().getGlobalText();
                if (morphName == null) {
                    morphName = "";
                }
                this.dumpText(morphName, 20);
            }
        }
        this.flush();
    }

    private void dumpBoneGroupGlobal(PmdModel model) throws IOException, IllegalTextExportException {
        for (BoneGroup group : model.getBoneGroupList()) {
            if (group.isDefaultBoneGroup()) continue;
            String groupName = group.getGroupName().getGlobalText();
            if (groupName == null) {
                groupName = "";
            }
            this.dumpText(groupName, 50);
        }
        this.flush();
    }
}

