/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.binio;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.sfjp.mikutoga.pmd.binio.BoneBuilder;
import jp.sfjp.mikutoga.pmd.binio.JointBuilder;
import jp.sfjp.mikutoga.pmd.binio.MaterialBuilder;
import jp.sfjp.mikutoga.pmd.binio.MorphBuilder;
import jp.sfjp.mikutoga.pmd.binio.RigidBuilder;
import jp.sfjp.mikutoga.pmd.binio.ShapeBuilder;
import jp.sfjp.mikutoga.pmd.binio.TextBuilder;
import jp.sfjp.mikutoga.pmd.binio.ToonBuilder;
import jp.sfjp.mikutoga.pmd.model.MorphPart;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.pmd.parser.PmdParser;

public class PmdLoader {
    private PmdModel model = new PmdModel();
    private PmdParser parser;
    private TextBuilder textBuilder;
    private boolean loaded = false;
    private boolean hasMoreData = false;

    public PmdLoader(InputStream source) {
        this.parser = new PmdParser(source);
        this.textBuilder = new TextBuilder(this.model);
        this.setHandler();
    }

    private void setHandler() {
        ShapeBuilder shapeBuilder = new ShapeBuilder(this.model);
        MaterialBuilder materialBuilder = new MaterialBuilder(this.model);
        BoneBuilder boneBuilder = new BoneBuilder(this.model);
        MorphBuilder morphBuilder = new MorphBuilder(this.model);
        ToonBuilder toonBuilder = new ToonBuilder(this.model);
        RigidBuilder rigidBuilder = new RigidBuilder(this.model);
        JointBuilder jointBuilder = new JointBuilder(this.model);
        this.parser.setBasicHandler(this.textBuilder);
        this.parser.setShapeHandler(shapeBuilder);
        this.parser.setMaterialHandler(materialBuilder);
        this.parser.setBoneHandler(boneBuilder);
        this.parser.setMorphHandler(morphBuilder);
        this.parser.setEngHandler(this.textBuilder);
        this.parser.setToonHandler(toonBuilder);
        this.parser.setRigidHandler(rigidBuilder);
        this.parser.setJointHandler(jointBuilder);
        ArrayList<MorphPart> morphPartList = new ArrayList<MorphPart>();
        morphBuilder.setMorphPartList(morphPartList);
        this.textBuilder.setMorphPartList(morphPartList);
        morphPartList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PmdModel load() throws IOException, MmdFormatException, IllegalStateException {
        PmdModel result;
        if (this.loaded) {
            throw new IllegalStateException();
        }
        try {
            this.parser.parsePmd();
        }
        finally {
            this.loaded = true;
            result = this.model;
            this.hasMoreData = this.textBuilder.hasMoreData();
            this.model = null;
            this.parser = null;
            this.textBuilder = null;
        }
        return result;
    }

    public boolean hasMoreData() {
        return this.hasMoreData;
    }
}

