/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd2xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.sfjp.mikutoga.pmd2xml.OptSwitch;

class CmdLine {
    private OptSwitch opt;
    private List<String> optArgs;

    private CmdLine() {
    }

    static List<CmdLine> parse(String ... args) {
        List<String> list = Arrays.asList(args);
        return CmdLine.parse(list);
    }

    static List<CmdLine> parse(List<String> argList) {
        LinkedList<CmdLine> result = new LinkedList<CmdLine>();
        Iterator<String> it = argList.iterator();
        while (it.hasNext()) {
            String arg = it.next();
            CmdLine info = new CmdLine();
            result.add(info);
            info.opt = OptSwitch.parse(arg);
            int exArgNum = 0;
            if (info.opt != null) {
                exArgNum = info.opt.getExArgNum();
            }
            info.optArgs = new ArrayList<String>(exArgNum + 1);
            info.optArgs.add(arg);
            for (int argCt = 0; argCt < exArgNum && it.hasNext(); ++argCt) {
                String exarg = it.next();
                info.optArgs.add(exarg);
            }
        }
        return result;
    }

    OptSwitch getOptSwitch() {
        return this.opt;
    }

    List<String> getOptArgs() {
        return this.optArgs;
    }
}

