/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd2xml;

import java.text.MessageFormat;
import java.util.List;
import jp.sfjp.mikutoga.pmd2xml.CmdLine;
import jp.sfjp.mikutoga.pmd2xml.CmdLineException;
import jp.sfjp.mikutoga.pmd2xml.ModelFileType;
import jp.sfjp.mikutoga.pmd2xml.OptSwitch;
import jp.sfjp.mikutoga.pmd2xml.Pmd2Xml;

final class OptInfo {
    private static final String EOL_LF = "\n";
    private static final String EOL_CRLF = "\r\n";
    private static final String EOL_DEFAULT = "\n";
    private static final String FORMAT_PMD = "pmd";
    private static final String FORMAT_XML = "xml";
    private static final String FORMAT_XML101009 = "xml101009";
    private static final String FORMAT_XML130128 = "xml130128";
    private static final String SFX_PMD = ".pmd";
    private static final String SFX_XML = ".xml";
    private static final String NL_LF = "lf";
    private static final String NL_CRLF = "crlf";
    private static final String GENERATOR = Pmd2Xml.APPNAME + ' ' + Pmd2Xml.APPVER;
    private static final String ERRMSG_UNKNOWN = "Unknown option : {0}";
    private static final String ERRMSG_MOREARG = "You need option arg with : {0}";
    private static final String ERRMSG_INTYPE = "You must specify input format with -iform.";
    private static final String ERRMSG_OUTTYPE = "You must specify output format with -oform.";
    private static final String ERRMSG_NOINFILE = "You must specify input file with -i.";
    private static final String ERRMSG_NOOUTFILE = "You must specify output file with -o.";
    private static final String ERRMSG_INVFORM = "Unknown format : \"{0}\" must be \"pmd\" or \"xml\" or \"xml101009\" or \"xml130128\"";
    private static final String ERRMSG_INVNL = "Unknown newline : \"{0}\" must be \"lf\" or \"crlf\"";
    private static final String ERRMSG_INVBOOL = "Unknown switch : \"{0}\" must be \"on\" or \"off\"";
    private boolean needHelp = false;
    private ModelFileType inTypes = ModelFileType.NONE;
    private ModelFileType outTypes = ModelFileType.NONE;
    private String inFilename = null;
    private String outFilename = null;
    private boolean overwrite = false;
    private String newline = "\n";
    private String generator = GENERATOR;

    private OptInfo() {
    }

    private static ModelFileType decodeFormatType(String arg) throws CmdLineException {
        ModelFileType result;
        if (FORMAT_PMD.equals(arg)) {
            result = ModelFileType.PMD;
        } else if (FORMAT_XML.equals(arg)) {
            result = ModelFileType.XML_AUTO;
        } else if (FORMAT_XML101009.equals(arg)) {
            result = ModelFileType.XML_101009;
        } else if (FORMAT_XML130128.equals(arg)) {
            result = ModelFileType.XML_130128;
        } else {
            String errMsg = MessageFormat.format(ERRMSG_INVFORM, arg);
            throw new CmdLineException(errMsg);
        }
        return result;
    }

    private static String decodeNewline(String arg) throws CmdLineException {
        String result;
        if (NL_LF.equals(arg)) {
            result = "\n";
        } else if (NL_CRLF.equals(arg)) {
            result = EOL_CRLF;
        } else {
            String errMsg = MessageFormat.format(ERRMSG_INVNL, arg);
            throw new CmdLineException(errMsg);
        }
        return result;
    }

    private static boolean decodeBoolean(String arg) throws CmdLineException {
        boolean result;
        if ("on".equals(arg) || "true".equals(arg) || "yes".equals(arg)) {
            result = true;
        } else if ("off".equals(arg) || "false".equals(arg) || "no".equals(arg)) {
            result = false;
        } else {
            String errMsg = MessageFormat.format(ERRMSG_INVBOOL, arg);
            throw new CmdLineException(errMsg);
        }
        return result;
    }

    private static ModelFileType getFileType(String fileName) {
        ModelFileType result = ModelFileType.NONE;
        if (fileName == null) {
            return result;
        }
        String lower = fileName.toLowerCase();
        if (lower.endsWith(SFX_PMD)) {
            result = ModelFileType.PMD;
        } else if (lower.endsWith(SFX_XML)) {
            result = ModelFileType.XML_AUTO;
        }
        return result;
    }

    static OptInfo parseOption(String ... args) throws CmdLineException {
        OptInfo result = new OptInfo();
        List<CmdLine> cmdLines = CmdLine.parse(args);
        for (CmdLine cmd : cmdLines) {
            OptSwitch opt = cmd.getOptSwitch();
            if (opt != OptSwitch.OPT_HELP) continue;
            result.needHelp = true;
            return result;
        }
        OptInfo.checkCmdLineList(cmdLines);
        block11: for (CmdLine cmd : cmdLines) {
            List<String> optArgs = cmd.getOptArgs();
            String exArg1 = null;
            if (optArgs.size() >= 2) {
                exArg1 = optArgs.get(1);
            }
            OptSwitch opt = cmd.getOptSwitch();
            switch (opt) {
                case OPT_HELP: {
                    continue block11;
                }
                case OPT_FORCE: {
                    result.overwrite = true;
                    continue block11;
                }
                case OPT_INFILE: {
                    result.inFilename = exArg1;
                    continue block11;
                }
                case OPT_OUTFILE: {
                    result.outFilename = exArg1;
                    continue block11;
                }
                case OPT_NEWLINE: {
                    result.newline = OptInfo.decodeNewline(exArg1);
                    continue block11;
                }
                case OPT_GENOUT: {
                    boolean genout = OptInfo.decodeBoolean(exArg1);
                    if (genout) {
                        result.generator = GENERATOR;
                        continue block11;
                    }
                    result.generator = null;
                    continue block11;
                }
                case OPT_IFORM: {
                    ModelFileType itype;
                    result.inTypes = itype = OptInfo.decodeFormatType(exArg1);
                    continue block11;
                }
                case OPT_OFORM: {
                    ModelFileType otype;
                    result.outTypes = otype = OptInfo.decodeFormatType(exArg1);
                    continue block11;
                }
            }
            assert (false);
            throw new AssertionError();
        }
        OptInfo.fixFormat(result);
        OptInfo.checkResult(result);
        return result;
    }

    private static void checkCmdLineList(List<CmdLine> cmdLines) throws CmdLineException {
        for (CmdLine cmd : cmdLines) {
            List<String> optArgs = cmd.getOptArgs();
            assert (optArgs.size() > 0);
            String optTxt = optArgs.get(0);
            assert (optTxt != null);
            OptSwitch opt = cmd.getOptSwitch();
            if (opt == null) {
                String errMsg = MessageFormat.format(ERRMSG_UNKNOWN, optTxt);
                throw new CmdLineException(errMsg);
            }
            int exArgNum = opt.getExArgNum();
            if (optArgs.size() == 1 + exArgNum) continue;
            String errMsg = MessageFormat.format(ERRMSG_MOREARG, optTxt);
            throw new CmdLineException(errMsg);
        }
    }

    private static void fixFormat(OptInfo result) {
        if (result.inTypes == ModelFileType.NONE) {
            result.inTypes = OptInfo.getFileType(result.inFilename);
        }
        if (result.outTypes == ModelFileType.NONE) {
            result.outTypes = OptInfo.getFileType(result.outFilename);
        }
    }

    private static void checkResult(OptInfo result) throws CmdLineException {
        if (result.getInFilename() == null) {
            throw new CmdLineException(ERRMSG_NOINFILE);
        }
        if (result.getOutFilename() == null) {
            throw new CmdLineException(ERRMSG_NOOUTFILE);
        }
        if (result.getInFileType() == ModelFileType.NONE) {
            throw new CmdLineException(ERRMSG_INTYPE);
        }
        if (result.getOutFileType() == ModelFileType.NONE) {
            throw new CmdLineException(ERRMSG_OUTTYPE);
        }
    }

    boolean needHelp() {
        return this.needHelp;
    }

    ModelFileType getInFileType() {
        return this.inTypes;
    }

    ModelFileType getOutFileType() {
        return this.outTypes;
    }

    String getInFilename() {
        return this.inFilename;
    }

    String getOutFilename() {
        return this.outFilename;
    }

    boolean overwriteMode() {
        return this.overwrite;
    }

    String getNewline() {
        return this.newline;
    }

    String getGenerator() {
        return this.generator;
    }
}

