/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.binio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class FileUtils {
    private FileUtils() {
        assert (false);
        throw new AssertionError();
    }

    public static boolean isExistsNormalFile(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.isFile();
    }

    public static boolean isExistsUnnormalFile(File file) {
        if (!file.exists()) {
            return false;
        }
        return !file.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trunc(File file) throws IOException {
        if (!FileUtils.isExistsNormalFile(file)) {
            return;
        }
        if (file.length() <= 0L) {
            return;
        }
        FileOutputStream foStream = new FileOutputStream(file);
        try {
            FileChannel channnel = foStream.getChannel();
            try {
                channnel.truncate(0L);
            }
            finally {
                channnel.close();
            }
        }
        finally {
            foStream.close();
        }
        assert (file.length() <= 0L);
    }
}

