/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.typical;

import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class I18nAlias {
    public static final Comparator<I18nAlias> ORDER_COMPARATOR = new OrderComparator();
    private int orderNo;
    private final List<String> primaryList;
    private final List<String> globalList;
    private final List<String> umodPrimaryList;
    private final List<String> umodGlobalList;

    protected I18nAlias(int primaryNo, int globalNo) {
        this.primaryList = primaryNo <= 0 ? new LinkedList<String>() : new ArrayList<String>(primaryNo);
        this.globalList = globalNo <= 0 ? new LinkedList<String>() : new ArrayList<String>(globalNo);
        this.umodPrimaryList = Collections.unmodifiableList(this.primaryList);
        this.umodGlobalList = Collections.unmodifiableList(this.globalList);
    }

    protected I18nAlias() {
        this(0, 0);
    }

    protected static Element loadXml(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        Element top = doc.getDocumentElement();
        return top;
    }

    protected static String normalize(CharSequence name) {
        String result = Normalizer.normalize(name, Normalizer.Form.NFKC);
        return result;
    }

    protected int getOrderNo() {
        return this.orderNo;
    }

    protected void setOrderNo(int orderNo) {
        this.orderNo = orderNo;
    }

    public String getTopPrimaryName() {
        String result = this.primaryList.get(0);
        return result;
    }

    public String getTopGlobalName() {
        String result = this.globalList.isEmpty() ? null : this.globalList.get(0);
        return result;
    }

    public List<String> getPrimaryList() {
        return this.umodPrimaryList;
    }

    protected void addPrimaryName(String name) {
        this.primaryList.add(name);
    }

    public List<String> getGlobalList() {
        return this.umodGlobalList;
    }

    protected void addGlobalName(String name) {
        this.globalList.add(name);
    }

    private static class OrderComparator
    implements Comparator<I18nAlias> {
        OrderComparator() {
        }

        @Override
        public int compare(I18nAlias o1, I18nAlias o2) {
            int result = o1.getOrderNo() - o2.getOrderNo();
            return result;
        }
    }
}

