/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.typical;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.mikutoga.typical.I18nAlias;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TypicalBone
extends I18nAlias {
    private static final Class<?> THISCLASS;
    private static final String BONE_XML = "resources/typicalBone.xml";
    private static final List<TypicalBone> TYP_BONE_LIST;
    private static final Map<String, TypicalBone> PRIMARY_MAP;
    private static final Map<String, TypicalBone> GLOBAL_MAP;
    private static final List<TypicalBone> TYP_BONE_UNMODLIST;

    private TypicalBone(int primaryNo, int globalNo) {
        super(primaryNo, globalNo);
    }

    private static void parse(Element top) {
        NodeList boneList = top.getElementsByTagName("bone");
        int boneNo = boneList.getLength();
        for (int idx = 0; idx < boneNo; ++idx) {
            Element bone = (Element)boneList.item(idx);
            TypicalBone typBone = TypicalBone.parseBone(bone);
            TYP_BONE_LIST.add(typBone);
        }
    }

    private static TypicalBone parseBone(Element bone) {
        String key;
        String name;
        int idx;
        NodeList primaryNodes = bone.getElementsByTagName("primary");
        NodeList globalNodes = bone.getElementsByTagName("global");
        int primaryNo = primaryNodes.getLength();
        int globalNo = globalNodes.getLength();
        TypicalBone typBone = new TypicalBone(primaryNo, globalNo);
        for (idx = 0; idx < primaryNo; ++idx) {
            Element primary = (Element)primaryNodes.item(idx);
            name = primary.getAttribute("name");
            typBone.addPrimaryName(name);
        }
        for (idx = 0; idx < globalNo; ++idx) {
            Element global = (Element)globalNodes.item(idx);
            name = global.getAttribute("name");
            typBone.addGlobalName(name);
        }
        for (String primaryName : typBone.getPrimaryList()) {
            key = TypicalBone.normalize(primaryName).intern();
            PRIMARY_MAP.put(key, typBone);
        }
        for (String globalName : typBone.getGlobalList()) {
            key = TypicalBone.normalize(globalName).intern();
            GLOBAL_MAP.put(key, typBone);
        }
        return typBone;
    }

    private static void numbering() {
        int order = 0;
        for (TypicalBone bone : TYP_BONE_LIST) {
            bone.setOrderNo(order++);
        }
    }

    public static List<TypicalBone> getBoneList() {
        return TYP_BONE_UNMODLIST;
    }

    public static TypicalBone findWithPrimary(String primaryName) {
        String key = TypicalBone.normalize(primaryName);
        TypicalBone result = PRIMARY_MAP.get(key);
        return result;
    }

    public static TypicalBone findWithGlobal(String globalName) {
        String key = TypicalBone.normalize(globalName);
        TypicalBone result = GLOBAL_MAP.get(key);
        return result;
    }

    public static String primary2global(String primaryName) {
        TypicalBone bone = TypicalBone.findWithPrimary(primaryName);
        if (bone == null) {
            return null;
        }
        String global = bone.getTopGlobalName();
        return global;
    }

    public static String global2primary(String globalName) {
        TypicalBone bone = TypicalBone.findWithGlobal(globalName);
        if (bone == null) {
            return null;
        }
        String primary = bone.getTopPrimaryName();
        return primary;
    }

    static {
        Element top;
        THISCLASS = TypicalBone.class;
        TYP_BONE_LIST = new LinkedList<TypicalBone>();
        PRIMARY_MAP = new HashMap<String, TypicalBone>();
        GLOBAL_MAP = new HashMap<String, TypicalBone>();
        TYP_BONE_UNMODLIST = Collections.unmodifiableList(TYP_BONE_LIST);
        InputStream is = THISCLASS.getResourceAsStream(BONE_XML);
        try {
            top = I18nAlias.loadXml(is);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        TypicalBone.parse(top);
        TypicalBone.numbering();
    }
}

