/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.binio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.sfjp.mikutoga.pmd.model.ListUtil;
import jp.sfjp.mikutoga.pmd.model.MorphPart;
import jp.sfjp.mikutoga.pmd.model.MorphVertex;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sfjp.mikutoga.pmd.model.Vertex;
import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.parser.ParseStage;
import jp.sourceforge.mikutoga.pmd.MorphType;
import jp.sourceforge.mikutoga.pmd.parser.PmdMorphHandler;

class MorphBuilder
implements PmdMorphHandler {
    private final Map<MorphType, List<MorphPart>> morphMap;
    private List<MorphPart> morphPartList;
    private Iterator<MorphPart> morphPartIt;
    private MorphPart currentMorphPart;
    private final List<Vertex> vertexList;
    private final List<Vertex> morphVertexList = new ArrayList<Vertex>();

    MorphBuilder(PmdModel model) {
        this.vertexList = model.getVertexList();
        this.morphMap = model.getMorphMap();
    }

    void setMorphPartList(List<MorphPart> list) {
        this.morphPartList = list;
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        if (stage == PmdMorphHandler.MORPH_LIST) {
            ListUtil.prepareDefConsList(this.morphPartList, MorphPart.class, loops);
            ListUtil.assignIndexedSerial(this.morphPartList);
            this.morphPartIt = this.morphPartList.iterator();
            if (this.morphPartIt.hasNext()) {
                this.currentMorphPart = this.morphPartIt.next();
            }
        } else if (stage != PmdMorphHandler.MORPHVERTEX_LIST && stage != PmdMorphHandler.MORPHORDER_LIST) {
            assert (false);
            throw new AssertionError();
        }
    }

    @Override
    public void loopNext(ParseStage stage) {
        if (stage == PmdMorphHandler.MORPH_LIST) {
            if (this.morphPartIt.hasNext()) {
                this.currentMorphPart = this.morphPartIt.next();
            }
        } else if (stage != PmdMorphHandler.MORPHVERTEX_LIST && stage != PmdMorphHandler.MORPHORDER_LIST) {
            assert (false);
            throw new AssertionError();
        }
    }

    @Override
    public void loopEnd(ParseStage stage) {
        if (stage != PmdMorphHandler.MORPH_LIST && stage != PmdMorphHandler.MORPHVERTEX_LIST && stage != PmdMorphHandler.MORPHORDER_LIST) {
            assert (false);
            throw new AssertionError();
        }
    }

    @Override
    public void pmdMorphInfo(String morphName, byte morphType) {
        this.currentMorphPart.getMorphName().setPrimaryText(morphName);
        MorphType type = MorphType.decode(morphType);
        this.currentMorphPart.setMorphType(type);
    }

    @Override
    public void pmdMorphVertexInfo(int serialId, float xPos, float yPos, float zPos) {
        Vertex vertex;
        MorphVertex morphVertex = new MorphVertex();
        MkPos3D position = morphVertex.getOffset();
        position.setXpos(xPos);
        position.setYpos(yPos);
        position.setZpos(zPos);
        if (this.currentMorphPart.getMorphType().isBase()) {
            vertex = this.vertexList.get(serialId);
            this.morphVertexList.add(vertex);
        } else {
            vertex = this.morphVertexList.get(serialId);
        }
        morphVertex.setBaseVertex(vertex);
        this.currentMorphPart.getMorphVertexList().add(morphVertex);
    }

    @Override
    public void pmdMorphOrderInfo(int morphId) {
        MorphPart part = this.morphPartList.get(morphId);
        MorphType type = part.getMorphType();
        List<MorphPart> partList = this.morphMap.get((Object)type);
        if (partList == null) {
            partList = new LinkedList<MorphPart>();
            this.morphMap.put(type, partList);
        }
        partList.add(part);
    }
}

