/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.binio;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sfjp.mikutoga.pmd.model.BoneGroup;
import jp.sfjp.mikutoga.pmd.model.BoneInfo;
import jp.sfjp.mikutoga.pmd.model.IKChain;
import jp.sfjp.mikutoga.pmd.model.Material;
import jp.sfjp.mikutoga.pmd.model.MorphPart;
import jp.sfjp.mikutoga.pmd.model.MorphVertex;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sfjp.mikutoga.pmd.model.SerialNumbered;
import jp.sfjp.mikutoga.pmd.model.ShadeInfo;
import jp.sfjp.mikutoga.pmd.model.Surface;
import jp.sfjp.mikutoga.pmd.model.Vertex;
import jp.sourceforge.mikutoga.binio.BinaryExporter;
import jp.sourceforge.mikutoga.binio.IllegalTextExportException;
import jp.sourceforge.mikutoga.math.MkPos2D;
import jp.sourceforge.mikutoga.math.MkPos3D;
import jp.sourceforge.mikutoga.math.MkVec3D;
import jp.sourceforge.mikutoga.pmd.BoneType;
import jp.sourceforge.mikutoga.pmd.IllegalPmdDataException;
import jp.sourceforge.mikutoga.pmd.MorphType;

public class PmdExporterBase
extends BinaryExporter {
    public static final int NOPREVBONE_ID = 65535;
    public static final int NONEXTBONE_ID = 0;
    public static final int NOIKBONE_ID = 0;
    private static final byte[] MAGIC_BYTES = new byte[]{80, 109, 100, 0, 0, -128, 63};
    private static final byte[] NULLFILLER = new byte[]{0};
    private static final byte[] FDFILLER = new byte[]{0, -3};
    private static final byte[] LFFILLER = new byte[]{10, 0, -3};
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";

    public PmdExporterBase(OutputStream stream) throws NullPointerException {
        super(stream);
    }

    protected static String normalizeBreak(String text) {
        String result = text;
        result = result.replace(CRLF, LF);
        result = result.replace(CR, LF);
        return result;
    }

    protected void dumpText(String text, int maxByteLength) throws IOException, IllegalTextExportException {
        this.dumpFixedW31j(text, maxByteLength, FDFILLER);
    }

    public void dumpPmdModel(PmdModel model) throws IOException, IllegalPmdDataException {
        try {
            this.dumpBasic(model);
            this.dumpVertexList(model);
            this.dumpSurfaceList(model);
            this.dumpMaterialList(model);
            this.dumpBoneList(model);
            this.dumpIKChainList(model);
            this.dumpMorphList(model);
            this.dumpMorphGroup(model);
            this.dumpBoneGroupList(model);
        }
        catch (IllegalTextExportException e) {
            throw new IllegalPmdDataException(e);
        }
    }

    private void dumpBasic(PmdModel model) throws IOException, IllegalTextExportException {
        for (int idx = 0; idx < MAGIC_BYTES.length; ++idx) {
            this.dumpByte(MAGIC_BYTES[idx]);
        }
        String modelName = model.getModelName().getPrimaryText();
        String description = model.getDescription().getPrimaryText();
        this.dumpText(modelName, 20);
        this.dumpText(description, 256);
        this.flush();
    }

    private void dumpVertexList(PmdModel model) throws IOException {
        List<Vertex> vList = model.getVertexList();
        int vertexNum = vList.size();
        this.dumpLeInt(vertexNum);
        for (Vertex vertex : vList) {
            this.dumpVertex(vertex);
        }
        this.flush();
    }

    private void dumpVertex(Vertex vertex) throws IOException {
        MkPos3D position = vertex.getPosition();
        this.dumpPos3D(position);
        MkVec3D normal = vertex.getNormal();
        this.dumpVec3D(normal);
        MkPos2D uv = vertex.getUVPosition();
        this.dumpPos2d(uv);
        BoneInfo boneA = vertex.getBoneA();
        BoneInfo boneB = vertex.getBoneB();
        this.dumpSerialIdAsShort(boneA);
        this.dumpSerialIdAsShort(boneB);
        int weight = vertex.getWeightA();
        this.dumpByte((byte)weight);
        boolean hasEdge = vertex.getEdgeAppearance();
        byte edgeFlag = hasEdge ? (byte)0 : 1;
        this.dumpByte(edgeFlag);
    }

    private void dumpSurfaceList(PmdModel model) throws IOException {
        int surfaceNum = 0;
        List<Material> materialList = model.getMaterialList();
        for (Material material : materialList) {
            surfaceNum += material.getSurfaceList().size();
        }
        this.dumpLeInt(surfaceNum * 3);
        Vertex[] triangle = new Vertex[3];
        for (Material material : materialList) {
            for (Surface surface : material) {
                surface.getTriangle(triangle);
                this.dumpLeShort(triangle[0].getSerialNumber());
                this.dumpLeShort(triangle[1].getSerialNumber());
                this.dumpLeShort(triangle[2].getSerialNumber());
            }
        }
        this.flush();
    }

    private void dumpMaterialList(PmdModel model) throws IOException, IllegalTextExportException {
        List<Material> materialList = model.getMaterialList();
        int materialNum = materialList.size();
        this.dumpLeInt(materialNum);
        float[] rgba = new float[4];
        for (Material material : materialList) {
            Color diffuse = material.getDiffuseColor();
            diffuse.getRGBComponents(rgba);
            this.dumpLeFloat(rgba[0]);
            this.dumpLeFloat(rgba[1]);
            this.dumpLeFloat(rgba[2]);
            this.dumpLeFloat(rgba[3]);
            float shininess = material.getShininess();
            this.dumpLeFloat(shininess);
            Color specular = material.getSpecularColor();
            specular.getRGBComponents(rgba);
            this.dumpLeFloat(rgba[0]);
            this.dumpLeFloat(rgba[1]);
            this.dumpLeFloat(rgba[2]);
            Color ambient = material.getAmbientColor();
            ambient.getRGBComponents(rgba);
            this.dumpLeFloat(rgba[0]);
            this.dumpLeFloat(rgba[1]);
            this.dumpLeFloat(rgba[2]);
            ShadeInfo shade = material.getShadeInfo();
            int toonIdx = shade.getToonIndex();
            this.dumpByte(toonIdx);
            boolean showEdge = material.getEdgeAppearance();
            byte edgeFlag = showEdge ? (byte)1 : 0;
            this.dumpByte(edgeFlag);
            int surfaceNum = material.getSurfaceList().size();
            this.dumpLeInt(surfaceNum * 3);
            this.dumpShadeFileInfo(shade);
        }
        this.flush();
    }

    private void dumpShadeFileInfo(ShadeInfo shade) throws IOException, IllegalTextExportException {
        String textureFile = shade.getTextureFileName();
        String spheremapFile = shade.getSpheremapFileName();
        StringBuilder text = new StringBuilder();
        if (textureFile != null) {
            text.append(textureFile);
        }
        if (spheremapFile != null && spheremapFile.length() > 0) {
            text.append('*').append(spheremapFile);
        }
        byte[] filler = text.length() <= 0 ? NULLFILLER : FDFILLER;
        this.dumpFixedW31j(text.toString(), 20, filler);
    }

    private void dumpBoneList(PmdModel model) throws IOException, IllegalTextExportException {
        List<BoneInfo> boneList = model.getBoneList();
        int boneNum = boneList.size();
        this.dumpLeShort(boneNum);
        for (BoneInfo bone : boneList) {
            this.dumpBone(bone);
        }
        this.flush();
    }

    private void dumpBone(BoneInfo bone) throws IOException, IllegalTextExportException {
        String boneName = bone.getBoneName().getPrimaryText();
        this.dumpText(boneName, 20);
        BoneInfo prev = bone.getPrevBone();
        if (prev != null) {
            this.dumpSerialIdAsShort(prev);
        } else {
            this.dumpLeShort(65535);
        }
        BoneInfo next = bone.getNextBone();
        if (next != null) {
            this.dumpSerialIdAsShort(next);
        } else {
            this.dumpLeShort(0);
        }
        BoneType type = bone.getBoneType();
        this.dumpByte(type.encode());
        if (type == BoneType.LINKEDROT) {
            int ratio = bone.getRotationRatio();
            this.dumpLeShort(ratio);
        } else {
            BoneInfo srcBone = bone.getSrcBone();
            if (srcBone != null) {
                this.dumpSerialIdAsShort(srcBone);
            } else {
                this.dumpLeShort(0);
            }
        }
        MkPos3D position = bone.getPosition();
        this.dumpPos3D(position);
    }

    private void dumpIKChainList(PmdModel model) throws IOException {
        List<IKChain> ikChainList = model.getIKChainList();
        int ikNum = ikChainList.size();
        this.dumpLeShort(ikNum);
        for (IKChain chain : ikChainList) {
            this.dumpIKChain(chain);
        }
        this.flush();
    }

    private void dumpIKChain(IKChain chain) throws IOException {
        BoneInfo ikBone = chain.getIkBone();
        this.dumpSerialIdAsShort(ikBone);
        List<BoneInfo> boneList = chain.getChainedBoneList();
        BoneInfo bone1st = boneList.get(0);
        this.dumpSerialIdAsShort(bone1st);
        int boneNum = boneList.size();
        this.dumpByte(boneNum - 1);
        int depth = chain.getIKDepth();
        float weight = chain.getIKWeight();
        this.dumpLeShort(depth);
        this.dumpLeFloat(weight);
        for (int idx = 1; idx < boneNum; ++idx) {
            BoneInfo bone = boneList.get(idx);
            this.dumpSerialIdAsShort(bone);
        }
    }

    private void dumpMorphList(PmdModel model) throws IOException, IllegalTextExportException {
        Map<MorphType, List<MorphPart>> morphMap = model.getMorphMap();
        Set<MorphType> typeSet = morphMap.keySet();
        List<MorphVertex> mergedMorphVertexList = model.mergeMorphVertex();
        int totalMorphPart = 0;
        for (MorphType type : typeSet) {
            List<MorphPart> partList = morphMap.get((Object)type);
            if (partList == null) continue;
            totalMorphPart += partList.size();
        }
        if (totalMorphPart <= 0) {
            this.dumpLeShort(0);
            return;
        }
        this.dumpLeShort(++totalMorphPart);
        this.dumpText("base", 20);
        int totalVertex = mergedMorphVertexList.size();
        this.dumpLeInt(totalVertex);
        this.dumpByte(MorphType.BASE.encode());
        for (MorphVertex morphVertex : mergedMorphVertexList) {
            Vertex baseVertex = morphVertex.getBaseVertex();
            this.dumpLeInt(baseVertex.getSerialNumber());
            this.dumpPos3D(baseVertex.getPosition());
        }
        for (MorphType type : typeSet) {
            List<MorphPart> partList = morphMap.get((Object)type);
            if (partList == null) continue;
            for (MorphPart part : partList) {
                this.dumpText(part.getMorphName().getPrimaryText(), 20);
                List<MorphVertex> morphVertexList = part.getMorphVertexList();
                this.dumpLeInt(morphVertexList.size());
                this.dumpByte(part.getMorphType().encode());
                for (MorphVertex morphVertex : morphVertexList) {
                    this.dumpLeInt(morphVertex.getSerialNumber());
                    this.dumpPos3D(morphVertex.getOffset());
                }
            }
        }
        this.flush();
    }

    private void dumpMorphGroup(PmdModel model) throws IOException {
        Map<MorphType, List<MorphPart>> morphMap = model.getMorphMap();
        Set<MorphType> typeSet = morphMap.keySet();
        int totalMorph = 0;
        for (MorphType type : typeSet) {
            List<MorphPart> partList = morphMap.get((Object)type);
            if (partList == null) continue;
            totalMorph += partList.size();
        }
        this.dumpByte(totalMorph);
        LinkedList<MorphType> typeList = new LinkedList<MorphType>();
        for (MorphType type : typeSet) {
            assert (!type.isBase());
            typeList.add(type);
        }
        Collections.reverse(typeList);
        for (MorphType type : typeList) {
            List<MorphPart> partList = morphMap.get((Object)type);
            if (partList == null) continue;
            for (MorphPart part : partList) {
                this.dumpSerialIdAsShort(part);
            }
        }
        this.flush();
    }

    private void dumpBoneGroupList(PmdModel model) throws IOException, IllegalTextExportException {
        List<BoneGroup> groupList = model.getBoneGroupList();
        int groupNum = groupList.size();
        this.dumpByte(groupNum - 1);
        int dispBoneNum = 0;
        for (BoneGroup group : groupList) {
            if (group.isDefaultBoneGroup()) continue;
            this.dumpFixedW31j(group.getGroupName().getPrimaryText(), 50, LFFILLER);
            dispBoneNum += group.getBoneList().size();
        }
        this.dumpLeInt(dispBoneNum);
        for (BoneGroup group : groupList) {
            if (group.isDefaultBoneGroup()) continue;
            for (BoneInfo bone : group) {
                this.dumpSerialIdAsShort(bone);
                int groupId = group.getSerialNumber();
                this.dumpByte(groupId);
            }
        }
        this.flush();
    }

    protected void dumpSerialIdAsShort(SerialNumbered obj) throws IOException {
        int serialId = obj.getSerialNumber();
        this.dumpLeShort(serialId);
    }

    protected void dumpPos2d(MkPos2D position) throws IOException {
        float xPos = (float)position.getXpos();
        float yPos = (float)position.getYpos();
        this.dumpLeFloat(xPos);
        this.dumpLeFloat(yPos);
    }

    protected void dumpPos3D(MkPos3D position) throws IOException {
        float xPos = (float)position.getXpos();
        float yPos = (float)position.getYpos();
        float zPos = (float)position.getZpos();
        this.dumpLeFloat(xPos);
        this.dumpLeFloat(yPos);
        this.dumpLeFloat(zPos);
    }

    protected void dumpVec3D(MkVec3D vector) throws IOException {
        float xVal = (float)vector.getXVal();
        float yVal = (float)vector.getYVal();
        float zVal = (float)vector.getZVal();
        this.dumpLeFloat(xVal);
        this.dumpLeFloat(yVal);
        this.dumpLeFloat(zVal);
    }
}

