/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.binio;

import java.util.Iterator;
import java.util.List;
import jp.sfjp.mikutoga.pmd.model.BoneGroup;
import jp.sfjp.mikutoga.pmd.model.BoneInfo;
import jp.sfjp.mikutoga.pmd.model.MorphPart;
import jp.sfjp.mikutoga.pmd.model.PmdModel;
import jp.sourceforge.mikutoga.corelib.I18nText;
import jp.sourceforge.mikutoga.parser.ParseStage;
import jp.sourceforge.mikutoga.pmd.parser.PmdBasicHandler;
import jp.sourceforge.mikutoga.pmd.parser.PmdEngHandler;

class TextBuilder
implements PmdBasicHandler,
PmdEngHandler {
    private final PmdModel model;
    private final I18nText modelName;
    private final I18nText description;
    private final List<BoneInfo> boneList;
    private Iterator<BoneInfo> boneIt;
    private BoneInfo currentBone = null;
    private List<MorphPart> morphPartList;
    private Iterator<MorphPart> morphPartIt;
    private MorphPart currentMorphPart = null;
    private final List<BoneGroup> boneGroupList;
    private Iterator<BoneGroup> boneGroupIt;
    private BoneGroup currentBoneGroup = null;
    private boolean hasMoreData = false;

    TextBuilder(PmdModel model) {
        this.model = model;
        this.modelName = model.getModelName();
        this.description = model.getDescription();
        this.boneList = model.getBoneList();
        this.boneGroupList = model.getBoneGroupList();
    }

    void setMorphPartList(List<MorphPart> list) {
        this.morphPartList = list;
    }

    @Override
    public void pmdParseStart() {
    }

    @Override
    public void pmdParseEnd(boolean hasMoreData) {
        this.hasMoreData = hasMoreData;
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        if (stage == PmdEngHandler.ENGBONE_LIST) {
            this.boneIt = this.boneList.iterator();
            if (this.boneIt.hasNext()) {
                this.currentBone = this.boneIt.next();
            }
        } else if (stage == PmdEngHandler.ENGMORPH_LIST) {
            if (this.morphPartList.isEmpty()) {
                return;
            }
            this.morphPartIt = this.morphPartList.iterator();
            MorphPart part = this.morphPartIt.next();
            assert (part != null);
            if (this.morphPartIt.hasNext()) {
                this.currentMorphPart = this.morphPartIt.next();
            }
        } else if (stage == PmdEngHandler.ENGBONEGROUP_LIST) {
            this.boneGroupIt = this.boneGroupList.iterator();
            assert (this.boneGroupIt.hasNext());
            BoneGroup group = this.boneGroupIt.next();
            assert (group != null);
            if (this.boneGroupIt.hasNext()) {
                this.currentBoneGroup = this.boneGroupIt.next();
            }
        } else {
            assert (false);
            throw new AssertionError();
        }
    }

    @Override
    public void loopNext(ParseStage stage) {
        if (stage == PmdEngHandler.ENGBONE_LIST) {
            if (this.boneIt.hasNext()) {
                this.currentBone = this.boneIt.next();
            }
        } else if (stage == PmdEngHandler.ENGMORPH_LIST) {
            if (this.morphPartIt.hasNext()) {
                this.currentMorphPart = this.morphPartIt.next();
            }
        } else if (stage == PmdEngHandler.ENGBONEGROUP_LIST) {
            if (this.boneGroupIt.hasNext()) {
                this.currentBoneGroup = this.boneGroupIt.next();
            }
        } else {
            assert (false);
            throw new AssertionError();
        }
    }

    @Override
    public void loopEnd(ParseStage stage) {
    }

    @Override
    public void pmdHeaderInfo(byte[] header) {
    }

    @Override
    public void pmdModelInfo(String modelName, String description) {
        this.modelName.setPrimaryText(modelName);
        this.description.setPrimaryText(description);
    }

    @Override
    public void pmdEngEnabled(boolean hasEnglishInfo) {
    }

    @Override
    public void pmdEngModelInfo(String modelName, String description) {
        this.modelName.setGlobalText(modelName);
        this.description.setGlobalText(description);
    }

    @Override
    public void pmdEngBoneInfo(String boneName) {
        this.currentBone.getBoneName().setGlobalText(boneName);
    }

    @Override
    public void pmdEngMorphInfo(String morphName) {
        this.currentMorphPart.getMorphName().setGlobalText(morphName);
    }

    @Override
    public void pmdEngBoneGroupInfo(String groupName) {
        this.currentBoneGroup.getGroupName().setGlobalText(groupName);
    }

    public boolean hasMoreData() {
        return this.hasMoreData;
    }
}

