/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.vmd.parser;

import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.vmd.parser.VmdBasicHandler;
import jp.sourceforge.mikutoga.vmd.parser.VmdBasicParser;
import jp.sourceforge.mikutoga.vmd.parser.VmdCameraHandler;
import jp.sourceforge.mikutoga.vmd.parser.VmdCameraParser;
import jp.sourceforge.mikutoga.vmd.parser.VmdLightingHandler;
import jp.sourceforge.mikutoga.vmd.parser.VmdLightingParser;

public class VmdParser {
    private final InputStream source;
    private final VmdBasicParser basicParser;
    private final VmdCameraParser cameraParser;
    private final VmdLightingParser lightingParser;
    private VmdBasicHandler basicHandler = null;
    private boolean strictMode = true;

    public VmdParser(InputStream source) throws NullPointerException {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source = source;
        this.basicParser = new VmdBasicParser(source);
        this.cameraParser = new VmdCameraParser(source);
        this.lightingParser = new VmdLightingParser(source);
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setBasicHandler(VmdBasicHandler handler) {
        this.basicParser.setBasicHandler(handler);
        this.basicHandler = handler;
    }

    public void setCameraHandler(VmdCameraHandler cameraHandler) {
        this.cameraParser.setCameraHandler(cameraHandler);
    }

    public void setLightingHandler(VmdLightingHandler lightingHandler) {
        this.lightingParser.setLightingHandler(lightingHandler);
    }

    public void setStrictMode(boolean mode) {
        this.strictMode = mode;
        this.basicParser.setStrictMode(this.strictMode);
    }

    public void parseVmd() throws IOException, MmdFormatException {
        if (this.basicHandler != null) {
            this.basicHandler.vmdParseStart();
        }
        this.parseBody();
        boolean hasMoreData = this.lightingParser.hasMore();
        if (this.basicHandler != null) {
            this.basicHandler.vmdParseEnd(hasMoreData);
        }
    }

    private void parseBody() throws IOException, MmdFormatException {
        this.basicParser.parse();
        if (this.basicParser.hasStageActName() || this.strictMode) {
            this.cameraParser.parse();
            this.lightingParser.parse();
        }
    }
}

